/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.content.Context;
import android.net.Uri;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.tac.TACApplication;
import com.tencent.tac.TACBaseService;
import com.tencent.tac.option.TACApplicationOptions;
import com.tencent.tac.storage.TACStorageOptions;
import com.tencent.tac.storage.TACStorageReference;
import java.util.HashMap;
import java.util.Map;

public class TACStorageService
extends TACBaseService {
    private static final Map<String, TACStorageService> instanceMap = new HashMap<String, TACStorageService>();
    private String bucket;
    private String region;
    private QCloudHttpClient client;
    private QCloudCredentialProvider credentialProvider;

    public static TACStorageService getInstance() {
        TACStorageOptions options = (TACStorageOptions)TACApplication.options().sub("storage");
        String defaultBucket = options.getDefaultBucket();
        return TACStorageService.getInstance(defaultBucket, options.getRegion(defaultBucket), options, TACApplication.options());
    }

    public static TACStorageService getInstance(String bucket, String region) {
        TACStorageOptions options = (TACStorageOptions)TACApplication.options().sub("storage");
        return TACStorageService.getInstance(bucket, region, options, TACApplication.options());
    }

    public TACStorageReference rootReference() {
        return new TACStorageReference(Uri.parse((String)"/"), this);
    }

    public TACStorageReference referenceWithPath(String path) {
        return new TACStorageReference(Uri.parse((String)path), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TACStorageService getInstance(String bucket, String region, TACStorageOptions options, TACApplicationOptions applicationOptions) {
        TACStorageService instance;
        if (bucket == null) {
            throw new IllegalArgumentException("bucket is null");
        }
        String[] bucketNameAndAppId = options.getBucketNameAndAppId(bucket);
        if (bucketNameAndAppId == null) {
            throw new IllegalArgumentException("bucket is not legal : " + bucket);
        }
        if (region == null) {
            throw new IllegalArgumentException("region is null");
        }
        Map<String, TACStorageService> map = instanceMap;
        synchronized (map) {
            instance = instanceMap.get(bucket);
            if (instance == null) {
                instance = new TACStorageService(bucket, region, options, applicationOptions);
            }
            instanceMap.put(bucket, instance);
        }
        return instance;
    }

    String getBucket() {
        return this.bucket;
    }

    String getRegion() {
        return this.region;
    }

    Context getAppContext() {
        return TACApplication.getAppContext();
    }

    <T> HttpTask<T> schedule(QCloudHttpRequest<T> request) {
        return this.client.resolveRequest(request, this.credentialProvider).schedule();
    }

    <T> HttpTask<T> resolveRequest(QCloudHttpRequest<T> request) {
        return this.client.resolveRequest(request, this.credentialProvider);
    }

    private TACStorageService(String bucket, String region, TACStorageOptions options, TACApplicationOptions applicationOptions) {
        this.bucket = bucket;
        this.region = region;
        this.credentialProvider = options.getCredentialProvider();
        this.client = QCloudHttpClient.getDefault();
        this.client.addVerifiedHost("*.myqcloud.com");
        this.client.setDebuggable(applicationOptions.isEnableLogging());
    }
}

