/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.storage;

import android.net.Uri;
import com.tencent.tac.storage.TACStorageDeleteTask;
import com.tencent.tac.storage.TACStorageDownloadTask;
import com.tencent.tac.storage.TACStorageMetadata;
import com.tencent.tac.storage.TACStorageMultiPartUploadTask;
import com.tencent.tac.storage.TACStorageService;
import com.tencent.tac.storage.TACStorageUploadTask;
import java.io.File;
import java.io.InputStream;

public class TACStorageReference {
    private final Uri storageUri;
    private final TACStorageService storageService;

    TACStorageReference(Uri uri, TACStorageService service) {
        this.storageService = service;
        this.storageUri = uri;
    }

    public TACStorageReference child(String path) {
        Uri childUri = this.storageUri.buildUpon().appendEncodedPath(path).build();
        return new TACStorageReference(childUri, this.storageService);
    }

    public TACStorageReference parent() {
        String stringUri = this.storageUri.getPath();
        if (stringUri != null && !stringUri.equals("/")) {
            int lastSeparator = stringUri.lastIndexOf(47);
            stringUri = lastSeparator == -1 ? "/" : stringUri.substring(0, lastSeparator);
            Uri parentUri = this.storageUri.buildUpon().path(stringUri).build();
            return new TACStorageReference(parentUri, this.storageService);
        }
        return null;
    }

    public TACStorageReference root() {
        Uri rootUri = this.storageUri.buildUpon().path("").build();
        return new TACStorageReference(rootUri, this.storageService);
    }

    public String getPath() {
        return this.storageUri.getPath();
    }

    public String getBucket() {
        return this.storageService.getBucket();
    }

    public String getRegion() {
        return this.storageService.getRegion();
    }

    public String getName() {
        String stringUri = this.storageUri.getPath();
        int lastSeparator = stringUri.lastIndexOf(47);
        return lastSeparator != -1 ? stringUri.substring(lastSeparator + 1) : stringUri;
    }

    public TACStorageUploadTask putData(byte[] data, TACStorageMetadata metadata) {
        TACStorageUploadTask uploadTask = new TACStorageUploadTask(this.storageService, this, metadata, data);
        uploadTask.enqueue();
        return uploadTask;
    }

    public TACStorageUploadTask putFile(Uri fileUri, TACStorageMetadata metadata, String uploadId) {
        File file = new File(fileUri.getPath());
        if (!file.exists()) {
            throw new IllegalArgumentException("file not exists : " + fileUri);
        }
        TACStorageUploadTask uploadTask = file.length() <= 0x200000L ? new TACStorageUploadTask(this.storageService, this, metadata, file) : new TACStorageMultiPartUploadTask(this.storageService, this, metadata, file, uploadId);
        uploadTask.enqueue();
        return uploadTask;
    }

    public TACStorageUploadTask putFile(Uri fileUri, TACStorageMetadata metadata) {
        return this.putFile(fileUri, metadata, null);
    }

    public TACStorageUploadTask putStream(InputStream inputStream, TACStorageMetadata metadata) {
        TACStorageUploadTask uploadTask = new TACStorageUploadTask(this.storageService, this, metadata, this.storageService.getAppContext(), inputStream);
        uploadTask.enqueue();
        return uploadTask;
    }

    public TACStorageDownloadTask downloadToFile(Uri fileUri) {
        TACStorageDownloadTask downloadTask = new TACStorageDownloadTask(this.storageService, this, fileUri);
        downloadTask.enqueue();
        return downloadTask;
    }

    public TACStorageDeleteTask delete() {
        TACStorageDeleteTask deleteTask = new TACStorageDeleteTask(this.storageService, this);
        deleteTask.enqueue();
        return deleteTask;
    }
}

