/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.stat.StatServiceImpl;
import com.tencent.stat.StatSpecifyReportedInfo;
import com.tencent.tac.TACApplication;
import java.util.Properties;

public class TACAppTracker {
    private static StatSpecifyReportedInfo a = new StatSpecifyReportedInfo();

    public static void onAppLaunched(@NonNull Context context) {
        TACAppTracker.trackEvent(context, "app_launched", null);
    }

    public static void onConfigLoaded(@NonNull Context context, boolean fromResource) {
        Properties properties = new Properties();
        properties.put("from", fromResource ? "xml" : "json");
        TACAppTracker.trackEvent(context, "config_loaded", properties);
    }

    public static void trackServiceActive(@NonNull String name) {
        Context context = TACApplication.getAppContext();
        if (context != null) {
            TACAppTracker.trackServiceActive(context, name);
        }
    }

    public static void trackServiceActive(@NonNull Context context, @NonNull String name) {
        Properties properties = new Properties();
        properties.put("name", name);
        TACAppTracker.trackEvent(context, "service_active", properties);
    }

    public static void trackEvent(@NonNull Context context, @NonNull String event, @Nullable Properties properties) {
        if (properties != null) {
            StatServiceImpl.trackCustomKVEvent((Context)context, (String)event, (Properties)properties, (StatSpecifyReportedInfo)a);
        } else {
            StatServiceImpl.trackCustomEvent((Context)context, (String)event, (StatSpecifyReportedInfo)a, (String[])new String[0]);
        }
    }

    static {
        a.setAppKey("Aqcloud100888");
        a.setInstallChannel("TAC_SDK");
        a.setVersion("1.3.1");
        a.setSendImmediately(true);
    }
}

