/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.analytics;

import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.stat.MtaSDkException;
import com.tencent.stat.StatAppMonitor;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatService;
import com.tencent.stat.hybrid.StatHybridHandler;
import com.tencent.tac.TACApplication;
import com.tencent.tac.TACBaseService;
import com.tencent.tac.analytics.TACAnalyticsEvent;
import com.tencent.tac.analytics.TACAnalyticsOptions;
import com.tencent.tac.analytics.TACNetworkMetrics;
import com.tencent.tac.option.TACApplicationOptions;
import java.util.Enumeration;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class TACAnalyticsService
extends TACBaseService {
    private static volatile TACAnalyticsService a;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static TACAnalyticsService getInstance() {
        if (a != null) return a;
        Class<TACAnalyticsService> clazz = TACAnalyticsService.class;
        synchronized (TACAnalyticsService.class) {
            if (a != null) return a;
            a = new TACAnalyticsService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    private TACAnalyticsService() {
    }

    @Override
    protected void onUserIdChanged(@NonNull Context appContext, @Nullable String userId) {
        StatConfig.setCustomUserId((Context)appContext, (String)userId);
    }

    public void start(@NonNull Context context) {
        if (this.isActive()) {
            return;
        }
        TACApplicationOptions tACApplicationOptions = TACApplication.options();
        if (tACApplicationOptions == null) {
            QCloudLogger.w((String)"tacApp", (String)"TACApplicationOptions is Null. Analytics Service cannot work !", (Object[])new Object[0]);
            return;
        }
        TACAnalyticsOptions tACAnalyticsOptions = (TACAnalyticsOptions)tACApplicationOptions.sub("analytics");
        if (TextUtils.isEmpty((CharSequence)tACAnalyticsOptions.o)) {
            QCloudLogger.w((String)"tacApp", (String)"No valid AppKey. Analytics Service cannot work !", (Object[])new Object[0]);
            return;
        }
        this.a(tACAnalyticsOptions, tACApplicationOptions, context.getApplicationContext());
        this.a(context);
        try {
            StatService.startStatService((Context)context, (String)tACAnalyticsOptions.o, (String)"3.4.2");
            this.setActive(true);
            QCloudLogger.i((String)"tacApp", (String)"Analytics Service starts successfully.", (Object[])new Object[0]);
        }
        catch (MtaSDkException mtaSDkException) {
            mtaSDkException.printStackTrace();
            QCloudLogger.w((String)"tacApp", (String)("start Analytics Service failed by : " + (Object)((Object)mtaSDkException)), (Object[])new Object[0]);
        }
    }

    private void a(@NonNull Context context) {
        StatHybridHandler.init((Context)context);
    }

    private void a(@NonNull TACAnalyticsOptions tACAnalyticsOptions, @NonNull TACApplicationOptions tACApplicationOptions, @NonNull Context context) {
        QCloudLogger.d((String)"tacApp", (String)"Analytics set appKey = %s, channel = %s, userId = %s, strategy = %s", (Object[])new Object[]{tACAnalyticsOptions.o, tACAnalyticsOptions.p, TACApplication.getCurrentUserId(), tACAnalyticsOptions.i.name()});
        StatConfig.setSessionTimoutMillis((int)Double.valueOf(tACAnalyticsOptions.a).intValue());
        StatConfig.setMaxSendRetryCount((int)tACAnalyticsOptions.b);
        StatConfig.setEnableConcurrentProcess((boolean)tACAnalyticsOptions.c);
        StatConfig.setDebugEnable((boolean)tACApplicationOptions.isEnableLogging());
        StatConfig.setEnableSmartReporting((boolean)tACAnalyticsOptions.d);
        StatConfig.setMaxReportEventLength((int)Double.valueOf(tACAnalyticsOptions.e).intValue());
        StatConfig.setSendPeriodMinutes((int)((int)(tACAnalyticsOptions.g / 60000L)));
        StatConfig.setMaxBatchReportCount((int)tACAnalyticsOptions.f);
        StatConfig.setStatSendStrategy((StatReportStrategy)StatReportStrategy.valueOf((String)tACAnalyticsOptions.i.name()));
        StatConfig.setMaxParallelTimmingEvents((int)tACAnalyticsOptions.j);
        StatConfig.setMaxSessionStatReportCount((int)tACAnalyticsOptions.k);
        StatConfig.setMaxDaySessionNumbers((int)tACAnalyticsOptions.l);
        StatConfig.setMaxStoreEventCount((int)tACAnalyticsOptions.m);
        StatConfig.setAppKey((Context)context, (String)tACAnalyticsOptions.o);
        StatConfig.setTLinkStatus((boolean)tACAnalyticsOptions.h);
        StatConfig.setEnableAutoMonitorActivityCycle((boolean)tACAnalyticsOptions.n);
        if (tACAnalyticsOptions.p != null) {
            StatConfig.setInstallChannel((Context)context, (String)tACAnalyticsOptions.p);
        }
        if (!TextUtils.isEmpty((CharSequence)TACApplication.getCurrentUserId())) {
            StatConfig.setCustomUserId((Context)context, (String)TACApplication.getCurrentUserId());
        }
        StatService.setContext((Context)context.getApplicationContext());
        if (tACAnalyticsOptions.n) {
            StatService.registerActivityLifecycleCallbacks((Application)((Application)context));
        }
    }

    public void monitorWebViewEvent(@NonNull WebView webView) {
        if (webView == null) {
            throw new IllegalArgumentException("WebView is null");
        }
        StatHybridHandler.initWebSettings((WebSettings)webView.getSettings());
    }

    public boolean handleWebViewUrl(@NonNull WebView webView, @NonNull String url) {
        return StatHybridHandler.handleWebViewUrl((WebView)webView, (String)url);
    }

    public void invokeTBSSdkOnUiThread(@NonNull Context context) {
        StatConfig.invokeTBSSdkOnUiThread((Context)context);
    }

    public void exchangeNewSession(@NonNull Context context) {
        StatService.startNewSession((Context)context);
    }

    public void trackPageAppear(@NonNull Context context, @NonNull String pageName) {
        StatService.trackBeginPage((Context)context, (String)pageName);
    }

    public void trackPageDisappear(@NonNull Context context, @NonNull String pageName) {
        StatService.trackEndPage((Context)context, (String)pageName);
    }

    public void trackEvent(@NonNull Context context, @NonNull TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDurationBegin(@NonNull Context context, @NonNull TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomBeginKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomBeginEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDurationEnd(@NonNull Context context, @NonNull TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomEndKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomEndEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDuration(@NonNull Context context, @NonNull TACAnalyticsEvent event, long duration) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        StatService.trackCustomKVTimeIntervalEvent((Context)context, (int)((int)(duration / 1000L)), (String)event.a(), (Properties)event.b());
    }

    public void trackNetworkMetrics(@NonNull Context context, @NonNull TACNetworkMetrics metrics) {
        if (metrics == null || context == null) {
            throw new IllegalArgumentException("metrics or context is null");
        }
        StatService.reportAppMonitorStat((Context)context, (StatAppMonitor)metrics.a());
    }

    public void setUserProperties(@NonNull Context context, @NonNull Properties properties) {
        if (properties == null || context == null) {
            throw new IllegalArgumentException("properties or context is null");
        }
        try {
            JSONObject jSONObject = new JSONObject();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                jSONObject.put(string, (Object)properties.getProperty(string));
            }
            StatService.reportCustomProperty((Context)context, (JSONObject)jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    @Nullable
    public String getCustomProperty(@NonNull Context context, @NonNull String key) {
        return StatConfig.getCustomProperty((Context)context, (String)key);
    }

    @Nullable
    public String getCustomProperty(@NonNull Context context, @NonNull String key, @NonNull String defaultValue) {
        return StatConfig.getCustomProperty((Context)context, (String)key, (String)defaultValue);
    }

    public void sendEvents(@NonNull Context context, int number) {
        StatService.commitEvents((Context)context, (int)number);
    }

    public void flushData(@NonNull Context context) {
        StatService.flushDataToDB((Context)context);
    }
}

