/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.analytics;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.stat.MtaSDkException;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatService;
import com.tencent.stat.hybrid.StatHybridHandler;
import com.tencent.tac.TACApplication;
import com.tencent.tac.TACBaseService;
import com.tencent.tac.analytics.TACAnalyticsEvent;
import com.tencent.tac.analytics.TACAnalyticsOptions;
import java.util.Properties;

public class TACAnalyticsService
extends TACBaseService {
    private static volatile TACAnalyticsService a;
    private boolean b;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TACAnalyticsService getInstance() {
        if (a != null) return a;
        Class<TACAnalyticsService> clazz = TACAnalyticsService.class;
        synchronized (TACAnalyticsService.class) {
            if (a != null) return a;
            a = new TACAnalyticsService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    private TACAnalyticsService() {
    }

    @Override
    protected void onUserIdChanged(Context appContext, String userId) {
        if (appContext != null) {
            StatConfig.setCustomUserId((Context)appContext, (String)userId);
        }
    }

    public void start(Context context) {
        if (this.b) {
            return;
        }
        QCloudLogger.i((String)"tacApp", (String)"TACAnalyticsService is starting.", (Object[])new Object[0]);
        TACAnalyticsOptions tACAnalyticsOptions = (TACAnalyticsOptions)TACApplication.options().sub("analytics");
        this.a(tACAnalyticsOptions, context.getApplicationContext());
        this.a(context);
        try {
            StatService.startStatService((Context)context, (String)tACAnalyticsOptions.o, (String)"3.3.1");
            this.b = true;
        }
        catch (MtaSDkException mtaSDkException) {
            mtaSDkException.printStackTrace();
            throw new IllegalStateException("start mta service failed by : " + mtaSDkException.getMessage());
        }
    }

    private void a(Context context) {
        StatHybridHandler.init((Context)context);
    }

    private void a(TACAnalyticsOptions tACAnalyticsOptions, Context context) {
        StatConfig.setSessionTimoutMillis((int)Double.valueOf(tACAnalyticsOptions.a).intValue());
        StatConfig.setMaxSendRetryCount((int)tACAnalyticsOptions.b);
        StatConfig.setEnableConcurrentProcess((boolean)tACAnalyticsOptions.c);
        StatConfig.setDebugEnable((boolean)TACApplication.options().isEnableLogging());
        StatConfig.setEnableSmartReporting((boolean)tACAnalyticsOptions.d);
        StatConfig.setMaxReportEventLength((int)Double.valueOf(tACAnalyticsOptions.e).intValue());
        StatConfig.setSendPeriodMinutes((int)((int)(tACAnalyticsOptions.g / 60000L)));
        StatConfig.setMaxBatchReportCount((int)tACAnalyticsOptions.f);
        StatConfig.setStatSendStrategy((StatReportStrategy)StatReportStrategy.valueOf((String)tACAnalyticsOptions.i.name()));
        StatConfig.setMaxParallelTimmingEvents((int)tACAnalyticsOptions.j);
        StatConfig.setMaxSessionStatReportCount((int)tACAnalyticsOptions.k);
        StatConfig.setMaxDaySessionNumbers((int)tACAnalyticsOptions.l);
        StatConfig.setMaxStoreEventCount((int)tACAnalyticsOptions.m);
        StatConfig.setAppKey((Context)context, (String)tACAnalyticsOptions.o);
        QCloudLogger.i((String)"tacApp", (String)"Analytics set app key : %s and channel : %s", (Object[])new Object[]{tACAnalyticsOptions.o, tACAnalyticsOptions.p});
        if (tACAnalyticsOptions.p != null) {
            StatConfig.setInstallChannel((Context)context, (String)tACAnalyticsOptions.p);
        }
        StatConfig.setTLinkStatus((boolean)tACAnalyticsOptions.h);
        if (tACAnalyticsOptions.n) {
            StatService.registerActivityLifecycleCallbacks((Application)((Application)context));
        }
        if (!TextUtils.isEmpty((CharSequence)TACApplication.getCurrentUserId())) {
            StatConfig.setCustomUserId((Context)context, (String)TACApplication.getCurrentUserId());
        }
        StatService.setContext((Context)context.getApplicationContext());
    }

    public void monitorWebViewEvent(WebView webView) {
        if (webView == null) {
            throw new IllegalArgumentException("WebView is null");
        }
        StatHybridHandler.initWebSettings((WebSettings)webView.getSettings());
    }

    public boolean handleWebViewUrl(WebView webView, String url) {
        return StatHybridHandler.handleWebViewUrl((WebView)webView, (String)url);
    }

    public void invokeTBSSdkOnUiThread(Context context) {
        StatConfig.invokeTBSSdkOnUiThread((Context)context);
    }

    public void exchangeNewSession(Context context) {
        StatService.startNewSession((Context)context);
    }

    public void trackPageAppear(Context context, String pageName) {
        StatService.trackBeginPage((Context)context, (String)pageName);
    }

    public void trackPageDisappear(Context context, String pageName) {
        StatService.trackEndPage((Context)context, (String)pageName);
    }

    public void trackEvent(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDurationBegin(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomBeginKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomBeginEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDurationEnd(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.b() != null) {
            StatService.trackCustomEndKVEvent((Context)context, (String)event.a(), (Properties)event.b());
        } else {
            StatService.trackCustomEndEvent((Context)context, (String)event.a(), (String[])event.c());
        }
    }

    public void trackEventDuration(Context context, TACAnalyticsEvent event, long duration) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        StatService.trackCustomKVTimeIntervalEvent((Context)context, (int)((int)(duration / 1000L)), (String)event.a(), (Properties)event.b());
    }

    public void sendEvents(Context context, int number) {
        StatService.commitEvents((Context)context, (int)number);
    }
}

