/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.option;

import android.content.Context;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TACApplicationOptions {
    private static final String TAC_LOG_TAG = "tac";
    private boolean isLoggingEnabled;
    private static final String TAC_CONFIG_FILE_PATTERN = "^tac_service_configurations(_\\S+)?.json$";
    private Map<String, Object> sServices = new HashMap<String, Object>();

    private TACApplicationOptions() {
    }

    public static TACApplicationOptions newDefaultOptions(Context context) {
        TACApplicationOptions options = new TACApplicationOptions();
        try {
            JSONObject config = TACApplicationOptions.readConfigFile(context);
            if (config != null) {
                options.initAllServiceOptions(context, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return options;
    }

    public <T> T sub(String serviceName) {
        return (T)this.sServices.get(serviceName);
    }

    public boolean isEnableLogging() {
        return this.isLoggingEnabled || QCloudLogger.isTagLoggable((String)TAC_LOG_TAG);
    }

    public void setLoggingEnable(boolean enable) {
        this.isLoggingEnabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject readConfigFile(Context context) throws IOException, JSONException {
        JSONObject configObject = null;
        Object[] fileNames = context.getAssets().list("");
        Arrays.sort(fileNames);
        for (Object file : fileNames) {
            String suffix;
            if (!((String)file).matches(TAC_CONFIG_FILE_PATTERN)) continue;
            Matcher matcher = Pattern.compile(TAC_CONFIG_FILE_PATTERN).matcher((CharSequence)file);
            if (matcher.matches() && "_unpackage".equals(suffix = matcher.group(1))) {
                throw new IllegalStateException("PLEASE REMOVE 'tac_service_configurations_unpackage.json' from your application ASSETS folder !");
            }
            try (InputStream inputStream = null;){
                inputStream = context.getAssets().open((String)file);
                String text = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
                JSONObject newConfig = new JSONObject(text);
                if (configObject == null) {
                    configObject = newConfig;
                    continue;
                }
                TACApplicationOptions.deepMerge(newConfig, configObject);
            }
        }
        return configObject;
    }

    private static JSONObject deepMerge(JSONObject source, JSONObject target) throws JSONException {
        Iterator keys = source.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = source.get(key);
            if (!target.has(key)) {
                target.put(key, value);
                continue;
            }
            Object pValue = target.get(key);
            if (value.getClass() != pValue.getClass()) {
                target.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject valueJson = (JSONObject)value;
                TACApplicationOptions.deepMerge(valueJson, target.getJSONObject(key));
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray pArray = (JSONArray)pValue;
                JSONArray nArray = (JSONArray)value;
                for (int i = 0; i < nArray.length(); ++i) {
                    Object nItem = nArray.get(i);
                    boolean newOne = true;
                    if (nItem instanceof Long || nItem instanceof Integer || nItem instanceof Double || nItem instanceof Boolean || nItem instanceof String) {
                        for (int j = 0; j < pArray.length(); ++j) {
                            Object pItem = pArray.get(j);
                            if (!pItem.equals(nItem)) continue;
                            newOne = false;
                            break;
                        }
                    }
                    if (!newOne) continue;
                    pArray.put(nItem);
                }
                continue;
            }
            target.put(key, value);
        }
        return target;
    }

    private void initAllServiceOptions(Context context, JSONObject config) throws JSONException {
        JSONObject servicesNode = config.getJSONObject("services");
        Iterator iService = servicesNode.keys();
        while (iService.hasNext()) {
            String serviceName = (String)iService.next();
            JSONObject serviceConfig = servicesNode.getJSONObject(serviceName);
            this.initServiceOptionByName(serviceName, context, serviceConfig);
        }
    }

    private void initServiceOptionByName(String serviceName, Context context, JSONObject serviceConfig) {
        String optionClassFullName = "com.tencent.tac." + serviceName + ".TAC" + serviceName.toUpperCase().charAt(0) + serviceName.substring(1) + "Options";
        try {
            Class<?> serviceOptionClass = Class.forName(optionClassFullName);
            Constructor<?> privateCons = serviceOptionClass.getDeclaredConstructor(Context.class, JSONObject.class);
            privateCons.setAccessible(true);
            Object options = privateCons.newInstance(context, serviceConfig);
            this.sServices.put(serviceName, options);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}

