/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.option;

import android.content.Context;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TACApplicationOptions {
    private static final String TAC_LOG_TAG = "tac";
    private Map<String, Object> sServices = new HashMap<String, Object>();

    private TACApplicationOptions() {
    }

    public static TACApplicationOptions newDefaultOptions(Context context) {
        TACApplicationOptions options = new TACApplicationOptions();
        try {
            JSONObject config = TACApplicationOptions.readConfigFile(context);
            options.initAllServiceOptions(context, config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return options;
    }

    public <T> T sub(String serviceName) {
        return (T)this.sServices.get(serviceName);
    }

    public boolean isEnableLogging() {
        return QCloudLogger.isTagLoggable((String)TAC_LOG_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject readConfigFile(Context context) throws IOException, JSONException {
        try (InputStream inputStream = null;){
            inputStream = context.getAssets().open("tac.json");
            String text = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            JSONObject jSONObject = new JSONObject(text);
            return jSONObject;
        }
    }

    private void initAllServiceOptions(Context context, JSONObject config) throws JSONException {
        JSONObject servicesNode = config.getJSONObject("services");
        Iterator iService = servicesNode.keys();
        while (iService.hasNext()) {
            String serviceName = (String)iService.next();
            JSONObject serviceConfig = servicesNode.getJSONObject(serviceName);
            this.initServiceOptionByName(serviceName, context, serviceConfig);
        }
    }

    private void initServiceOptionByName(String serviceName, Context context, JSONObject serviceConfig) {
        String optionClassFullName = "com.tencent.tac." + serviceName + ".TAC" + serviceName.toUpperCase().charAt(0) + serviceName.substring(1) + "Options";
        try {
            Class<?> serviceOptionClass = Class.forName(optionClassFullName);
            Constructor<?> privateCons = serviceOptionClass.getDeclaredConstructor(Context.class, JSONObject.class);
            privateCons.setAccessible(true);
            Object options = privateCons.newInstance(context, serviceConfig);
            this.sServices.put(serviceName, options);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}

