/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.mid.api.MidCallback;
import com.tencent.mid.api.MidEntity;
import com.tencent.mid.api.MidService;
import com.tencent.tac.TACBaseService;
import com.tencent.tac.option.TACApplicationOptions;
import java.util.ArrayList;
import java.util.List;

public class TACApplication {
    private static TACApplicationOptions options;
    private static Context appContext;
    private static volatile String userId;
    private static volatile String deviceId;
    private static final List<TACBaseService> sActiveServices;

    public static TACApplicationOptions options() {
        return options;
    }

    public static void configure(Context context) {
        options = TACApplicationOptions.newDefaultOptions(context);
        appContext = context.getApplicationContext();
    }

    public static void configureWithOptions(Context context, TACApplicationOptions applicationOptions) {
        options = applicationOptions;
        appContext = context.getApplicationContext();
    }

    public static Context getAppContext() {
        return appContext;
    }

    public static String getCurrentUserId() {
        return userId;
    }

    public static String getDeviceId() {
        return deviceId;
    }

    public static void bindUserId(String customId) {
        userId = customId;
        TACApplication.notifyService(userId, null);
    }

    public static void useOpenId(String openId) {
        userId = openId;
        TACApplication.notifyService(userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TACBaseService> void onServiceActive(T service) {
        List<TACBaseService> list = sActiveServices;
        synchronized (list) {
            sActiveServices.add(service);
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            TACApplication.requestDeviceId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends TACBaseService> void onServiceInActive(T service) {
        List<TACBaseService> list = sActiveServices;
        synchronized (list) {
            sActiveServices.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyService(String userId, String deviceId) {
        ArrayList<TACBaseService> services;
        List<TACBaseService> list = sActiveServices;
        synchronized (list) {
            services = new ArrayList<TACBaseService>(sActiveServices);
        }
        for (TACBaseService service : services) {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                service.onUserIdChanged(appContext, userId);
                continue;
            }
            service.onDeviceIdChanged(appContext, deviceId);
        }
    }

    private static void requestDeviceId() {
        if (appContext != null) {
            MidService.requestMid((Context)appContext, (MidCallback)new MidCallback(){

                public void onSuccess(Object data) {
                    MidEntity entity = MidEntity.parse((String)data.toString());
                    deviceId = entity.getMid();
                    TACApplication.notifyService(null, deviceId);
                }

                public void onFail(int i, String s) {
                }
            });
        }
    }

    static {
        sActiveServices = new ArrayList<TACBaseService>(10);
    }
}

