/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.analytics;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.tencent.stat.StatAppMonitor;
import com.tencent.stat.StatConfig;
import com.tencent.stat.StatReportStrategy;
import com.tencent.stat.StatService;
import com.tencent.tac.TACApplication;
import com.tencent.tac.TACBaseService;
import com.tencent.tac.analytics.TACAnalyticsEvent;
import com.tencent.tac.analytics.TACAnalyticsOptions;
import com.tencent.tac.analytics.TACNetworkMetrics;
import java.util.Enumeration;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class TACAnalyticsService
extends TACBaseService {
    private static volatile TACAnalyticsService instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TACAnalyticsService getInstance() {
        if (instance != null) return instance;
        Class<TACAnalyticsService> clazz = TACAnalyticsService.class;
        synchronized (TACAnalyticsService.class) {
            if (instance != null) return instance;
            instance = new TACAnalyticsService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TACAnalyticsService() {
    }

    @Override
    protected void onUserIdChanged(Context appContext, String userId) {
        if (appContext != null && !TextUtils.isEmpty((CharSequence)userId)) {
            StatConfig.setCustomUserId((Context)appContext, (String)userId);
        }
    }

    public void start(Context context) {
        TACAnalyticsOptions options = (TACAnalyticsOptions)TACApplication.options().sub("analytics");
        this.applyConfig(options, context.getApplicationContext());
        this.onUserIdChanged(context, TACApplication.getCurrentUserId());
    }

    private void applyConfig(TACAnalyticsOptions options, Context context) {
        StatConfig.setSessionTimoutMillis((int)Double.valueOf(options.sessionTimeoutMillis).intValue());
        StatConfig.setMaxSendRetryCount((int)options.maxSendRetryCount);
        StatConfig.setEnableConcurrentProcess((boolean)options.multiProcess);
        StatConfig.setDebugEnable((boolean)TACApplication.options().isEnableLogging());
        StatConfig.setEnableSmartReporting((boolean)options.enableWifiInstantSend);
        StatConfig.setMaxReportEventLength((int)Double.valueOf(options.maxReportEventLength).intValue());
        StatConfig.setSendPeriodMinutes((int)((int)(options.sendPeriodMillis / 600000L)));
        StatConfig.setMaxBatchReportCount((int)options.minBatchReportCount);
        StatConfig.setStatSendStrategy((StatReportStrategy)StatReportStrategy.valueOf((String)options.strategy.name()));
        StatConfig.setMaxParallelTimmingEvents((int)options.maxParallelTimingEvents);
        StatConfig.setMaxSessionStatReportCount((int)options.maxSessionStatReportCount);
        StatConfig.setMaxDaySessionNumbers((int)options.maxDaySessionNumbers);
        StatConfig.setMaxStoreEventCount((int)options.maxStoreEventCount);
        StatConfig.setAppKey((Context)context, (String)options.appKey);
        StatConfig.setInstallChannel((Context)context, (String)options.channel);
        StatConfig.setTLinkStatus((boolean)options.enableTLink);
        if (options.enableAutoTrackPageView) {
            StatService.registerActivityLifecycleCallbacks((Application)((Application)context));
        }
        StatService.setContext((Context)context.getApplicationContext());
    }

    public void exchangeNewSession(Context context) {
        StatService.startNewSession((Context)context);
    }

    public void trackPageAppear(Context context, String pageName) {
        StatService.trackBeginPage((Context)context, (String)pageName);
    }

    public void trackPageDisappear(Context context, String pageName) {
        StatService.trackEndPage((Context)context, (String)pageName);
    }

    public void trackEvent(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.getProperties() != null) {
            StatService.trackCustomKVEvent((Context)context, (String)event.getEventId(), (Properties)event.getProperties());
        } else {
            StatService.trackCustomEvent((Context)context, (String)event.getEventId(), (String[])event.getParams());
        }
    }

    public void trackEventDurationBegin(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.getProperties() != null) {
            StatService.trackCustomBeginKVEvent((Context)context, (String)event.getEventId(), (Properties)event.getProperties());
        } else {
            StatService.trackCustomBeginEvent((Context)context, (String)event.getEventId(), (String[])event.getParams());
        }
    }

    public void trackEventDurationEnd(Context context, TACAnalyticsEvent event) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        if (event.getProperties() != null) {
            StatService.trackCustomEndKVEvent((Context)context, (String)event.getEventId(), (Properties)event.getProperties());
        } else {
            StatService.trackCustomEndEvent((Context)context, (String)event.getEventId(), (String[])event.getParams());
        }
    }

    public void trackEventDuration(Context context, TACAnalyticsEvent event, long duration) {
        if (event == null || context == null) {
            throw new IllegalArgumentException("event or context is null");
        }
        StatService.trackCustomKVTimeIntervalEvent((Context)context, (int)((int)(duration / 1000L)), (String)event.getEventId(), (Properties)event.getProperties());
    }

    public void trackNetworkMetrics(Context context, TACNetworkMetrics metrics) {
        if (metrics == null || context == null) {
            throw new IllegalArgumentException("metrics or context is null");
        }
        StatService.reportAppMonitorStat((Context)context, (StatAppMonitor)metrics.getMonitor());
    }

    public void setUserProperties(Context context, Properties properties) {
        if (properties == null || context == null) {
            throw new IllegalArgumentException("properties or context is null");
        }
        try {
            JSONObject jsonObject = new JSONObject();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                jsonObject.put(key, (Object)properties.getProperty(key));
            }
            StatService.reportCustomProperty((Context)context, (JSONObject)jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getCustomProperty(Context context, String key) {
        return StatConfig.getCustomProperty((Context)context, (String)key);
    }

    public String getCustomProperty(Context context, String key, String defaultValue) {
        return StatConfig.getCustomProperty((Context)context, (String)key, (String)defaultValue);
    }

    public void sendEvents(Context context, int number) {
        StatService.commitEvents((Context)context, (int)number);
    }

    public void flushData(Context context) {
        StatService.flushDataToDB((Context)context);
    }
}

