/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.analytics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.tencent.tac.analytics.TACAnalyticsStrategy;
import org.json.JSONObject;

public final class TACAnalyticsOptions {
    long sessionTimeoutMillis = 30000L;
    int maxSendRetryCount = 3;
    boolean multiProcess = true;
    boolean enableWifiInstantSend = false;
    long maxReportEventLength = 4096L;
    int minBatchReportCount = 30;
    long sendPeriodMillis = 10800000L;
    boolean enableTLink = false;
    TACAnalyticsStrategy strategy = TACAnalyticsStrategy.BATCH;
    int maxParallelTimingEvents = 4096;
    int maxSessionStatReportCount = 0;
    int maxDaySessionNumbers = 100;
    int maxStoreEventCount = 500000;
    boolean enableVisualMode = false;
    boolean enableAutoTrackPageView = true;
    String appKey;
    String channel;

    private TACAnalyticsOptions(Context context, JSONObject config) {
        this.appKey = config.optString("appKey");
        this.channel = this.getChannelFromMetadata(context);
    }

    private String getChannelFromMetadata(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                return (String)applicationInfo.metaData.get("com.tencent.tac.channel");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public TACAnalyticsOptions sessionTimeoutMillis(long val) {
        this.sessionTimeoutMillis = val;
        return this;
    }

    public TACAnalyticsOptions setChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public TACAnalyticsOptions multiProcess(boolean val) {
        this.multiProcess = val;
        return this;
    }

    public TACAnalyticsOptions setTLinkEnabled(boolean val) {
        this.enableTLink = val;
        return this;
    }

    public TACAnalyticsOptions setAutoTrackPageViewEnabled(boolean enableAutoTrackPageView) {
        this.enableAutoTrackPageView = enableAutoTrackPageView;
        return this;
    }

    private TACAnalyticsOptions setVisualModeEnabled(boolean enableVisualMode) {
        this.enableVisualMode = enableVisualMode;
        return this;
    }

    public TACAnalyticsOptions setWifiInstantSendEnabled(boolean val) {
        this.enableWifiInstantSend = val;
        return this;
    }

    public TACAnalyticsOptions minBatchReportCount(int val) {
        this.minBatchReportCount = val;
        return this;
    }

    public TACAnalyticsOptions sendPeriodMillis(long val) {
        this.sendPeriodMillis = val;
        return this;
    }

    public TACAnalyticsOptions strategy(TACAnalyticsStrategy val) {
        this.strategy = val;
        return this;
    }
}

