/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.tac.authorization.oauth2.WeChatAuthProvider;
import com.tencent.tac.social.SocialWeChat;

public abstract class WeChatBaseSignInActivity
extends Activity
implements IWXAPIEventHandler {
    private IWXAPI api;
    private String appId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SocialWeChat socialWeChat = SocialWeChat.getInstance((Context)this);
        this.appId = socialWeChat.getAppId();
        this.api = socialWeChat.getApi();
        try {
            this.api.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.api.handleIntent(intent, (IWXAPIEventHandler)this);
    }

    public void onResp(BaseResp resp) {
        switch (resp.errCode) {
            case 0: {
                WeChatAuthProvider.setAuthorizationCode(((SendAuth.Resp)resp).code, this.appId, null, resp.errCode);
                break;
            }
            default: {
                WeChatAuthProvider.setAuthorizationCode(null, this.appId, null, resp.errCode);
            }
        }
        this.finish();
    }

    public void onReq(BaseReq baseReq) {
    }
}

