/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.tencent.connect.UserInfo;
import com.tencent.connect.auth.QQToken;
import com.tencent.qcloud.core.auth.OAuth2Credentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.tac.authorization.TACOpenUserInfo;
import com.tencent.tac.social.SocialQQ;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import org.json.JSONObject;

public class QQAuthProvider {
    private Tencent mTencent;
    private static final String DEFAULT_SCOPE = "get_simple_userinfo";
    public static final String PLATFORM = "QQ";
    private UILoginListenerWrapper tencentUiListener;
    private Context mContext;

    public QQAuthProvider(Context context) {
        this.mContext = context.getApplicationContext();
        this.mTencent = SocialQQ.getInstance((Context)this.mContext).getApi();
    }

    public void getUserInfo(OAuth2Credentials credentials, QCloudResultListener<TACOpenUserInfo> listener) {
        QQToken qqToken = this.mTencent.getQQToken();
        this.mTencent.setOpenId(credentials.getOpenId());
        this.mTencent.setAccessToken(credentials.getAccessToken(), "" + credentials.getExpiresInSeconds());
        if (qqToken == null || !qqToken.isSessionValid()) {
            listener.onFailure(new QCloudClientException("credential is expired"), null);
            return;
        }
        UserInfo userInfo = new UserInfo(this.mContext, qqToken);
        userInfo.getUserInfo((IUiListener)new UIUserInfoListenerWrapper(qqToken, listener));
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.tencentUiListener != null && (requestCode == 11101 || requestCode == 10102)) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.tencentUiListener);
        }
    }

    public void signIn(Activity entrance, QCloudResultListener<OAuth2Credentials> resultListener) {
        this.tencentUiListener = new UILoginListenerWrapper(resultListener);
        this.mTencent.login(entrance, DEFAULT_SCOPE, (IUiListener)this.tencentUiListener);
    }

    private static class UIUserInfoListenerWrapper
    extends UIListenerWrapper<TACOpenUserInfo> {
        private QQToken qqToken;

        UIUserInfoListenerWrapper(QQToken qqToken, QCloudResultListener<TACOpenUserInfo> listener) {
            super(listener);
            this.qqToken = qqToken;
        }

        @Override
        protected TACOpenUserInfo convert(JSONObject response) {
            String avatar = response.optString("figureurl_qq_2") == null ? response.optString("figureurl_qq_1") : response.optString("figureurl_qq_2");
            return new TACOpenUserInfo(this.qqToken.getOpenId(), response.optString("nickname"), avatar, response);
        }
    }

    private static class UILoginListenerWrapper
    extends UIListenerWrapper<OAuth2Credentials> {
        UILoginListenerWrapper(QCloudResultListener<OAuth2Credentials> listener) {
            super(listener);
        }

        @Override
        protected OAuth2Credentials convert(JSONObject response) {
            return new OAuth2Credentials.Builder().accessToken(response.optString("access_token")).tokenStartTime(System.currentTimeMillis()).expiresInSeconds(response.optLong("expires_in")).openId(response.optString("openid")).scope(QQAuthProvider.DEFAULT_SCOPE).platform(QQAuthProvider.PLATFORM).build();
        }
    }

    private static abstract class UIListenerWrapper<T>
    implements IUiListener {
        private final QCloudResultListener<T> customListener;

        UIListenerWrapper(QCloudResultListener<T> listener) {
            this.customListener = listener;
        }

        protected abstract T convert(JSONObject var1);

        public void onComplete(Object o) {
            if (o instanceof JSONObject) {
                JSONObject response = (JSONObject)o;
                T result = this.convert(response);
                this.customListener.onSuccess(result);
            } else {
                this.customListener.onFailure(null, new QCloudServiceException("qq json error"));
            }
        }

        public void onError(UiError uiError) {
            this.customListener.onFailure(null, null);
        }

        public void onCancel() {
        }
    }
}

