/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.qcloud.core.auth.OAuth2Credentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.tac.authorization.TACOpenUserInfo;
import com.tencent.tac.social.SocialWeChat;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class WeChatAuthProvider {
    private IWXAPI a;
    private static QCloudResultListener<OAuth2Credentials> b;
    private static QCloudResultListener<String> c;
    public static final String PLATFORM = "WeChat";
    private final String d;

    public WeChatAuthProvider(Context context) {
        SocialWeChat socialWeChat = SocialWeChat.getInstance((Context)context);
        this.a = socialWeChat.getApi();
        this.d = socialWeChat.getAppId();
    }

    public void signIn(QCloudResultListener<OAuth2Credentials> listener) {
        b = listener;
        SendAuth.Req req = new SendAuth.Req();
        req.scope = "snsapi_userinfo";
        req.state = "none";
        this.a.sendReq((BaseReq)req);
    }

    public void requestAuthorizationCode(QCloudResultListener<String> listener) {
        c = listener;
        SendAuth.Req req = new SendAuth.Req();
        req.scope = "snsapi_userinfo";
        req.state = "none";
        this.a.sendReq((BaseReq)req);
    }

    public static boolean isUserNeedSignIn(QCloudServiceException exception) {
        if (exception != null) {
            int n = Integer.parseInt(exception.getErrorCode());
            return n == 40030 || n == 42002;
        }
        return false;
    }

    public void getUserInfo(OAuth2Credentials credentials, final QCloudResultListener<TACOpenUserInfo> listener) {
        if (credentials.isExpired()) {
            listener.onFailure(new QCloudClientException("credential is expired"), null);
            return;
        }
        QCloudHttpClient.getDefault().resolveRequest(new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/userinfo").query("access_token", credentials.getAccessToken()).query("openid", credentials.getOpenId()).build()).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

            public void a(HttpResult<String> httpResult) {
                if (httpResult.isSuccessful()) {
                    WeChatAuthProvider.f((String)httpResult.content(), (QCloudResultListener<TACOpenUserInfo>)listener);
                } else {
                    WeChatAuthProvider.d((String)httpResult.content(), listener);
                }
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                listener.onFailure(clientException, serviceException);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((HttpResult<String>)((HttpResult)object));
            }
        });
    }

    public void refreshCredentialInBackground(OAuth2Credentials credentials, final QCloudResultListener<OAuth2Credentials> listener) {
        if (credentials.getRefreshToken() != null) {
            QCloudHttpClient.getDefault().resolveRequest(new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/oauth2/refresh_token").query("appid", this.d).query("grant_type", "refresh_token").query("refresh_token", credentials.getRefreshToken()).build()).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

                public void a(HttpResult<String> httpResult) {
                    if (httpResult.isSuccessful()) {
                        WeChatAuthProvider.e((String)httpResult.content(), (QCloudResultListener<OAuth2Credentials>)listener);
                    } else {
                        WeChatAuthProvider.d((String)httpResult.content(), listener);
                    }
                }

                public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                    listener.onFailure(clientException, serviceException);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((HttpResult<String>)((HttpResult)object));
                }
            });
        } else {
            listener.onFailure(new QCloudClientException("missing refresh token"), null);
        }
    }

    static void a(String string, String string2, String string3, int n) {
        if (b == null && c == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (b != null && !TextUtils.isEmpty((CharSequence)string3)) {
                HttpRequest httpRequest = new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/oauth2/access_token").query("appid", string2).query("secret", string3).query("grant_type", "authorization_code").query("code", string).build();
                QCloudHttpClient.getDefault().resolveRequest(httpRequest).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

                    public void a(HttpResult<String> httpResult) {
                        if (httpResult.isSuccessful()) {
                            WeChatAuthProvider.e((String)httpResult.content(), (QCloudResultListener<OAuth2Credentials>)b);
                        } else {
                            WeChatAuthProvider.d((String)httpResult.content(), b);
                        }
                        b = null;
                    }

                    public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                        b.onFailure(clientException, serviceException);
                        b = null;
                    }

                    public /* synthetic */ void onSuccess(Object object) {
                        this.a((HttpResult<String>)((HttpResult)object));
                    }
                });
            } else if (b != null) {
                b.onSuccess((Object)new OAuth2Credentials.Builder().authorizationCode(string).build());
                b = null;
            } else {
                c.onSuccess((Object)string);
                c = null;
            }
        } else {
            Object object = b != null ? b : c;
            object.onFailure(new QCloudClientException(String.format(Locale.ENGLISH, "login fails, error code is %d, message is %s", n, WeChatAuthProvider.a(n))), null);
            b = null;
            c = null;
        }
    }

    private static String a(int n) {
        switch (n) {
            case -4: {
                return "auth denied";
            }
            case -2: {
                return "user canceled";
            }
            case -6: {
                return "app signature is not matched";
            }
            case -5: {
                return "wechat client version not support";
            }
        }
        return "unknown reason";
    }

    private static <T> void d(String string, QCloudResultListener<T> qCloudResultListener) {
        if (qCloudResultListener == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n = jSONObject.optInt("errcode");
            String string2 = jSONObject.optString("errmsg");
            QCloudServiceException qCloudServiceException = new QCloudServiceException(string2);
            qCloudServiceException.setErrorCode("" + n);
            qCloudResultListener.onFailure(null, qCloudServiceException);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            qCloudResultListener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)jSONException)));
        }
    }

    private static void e(String string, QCloudResultListener<OAuth2Credentials> qCloudResultListener) {
        if (qCloudResultListener == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            OAuth2Credentials oAuth2Credentials = new OAuth2Credentials.Builder().accessToken(jSONObject.optString("access_token")).tokenStartTime(System.currentTimeMillis()).expiresInSeconds(jSONObject.optLong("expires_in")).openId(jSONObject.optString("openid")).refreshToken(jSONObject.optString("refresh_token")).scope(jSONObject.optString("scope")).platform(PLATFORM).build();
            qCloudResultListener.onSuccess((Object)oAuth2Credentials);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            qCloudResultListener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)jSONException)));
        }
    }

    private static void f(String string, QCloudResultListener<TACOpenUserInfo> qCloudResultListener) {
        if (qCloudResultListener == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            TACOpenUserInfo tACOpenUserInfo = new TACOpenUserInfo(jSONObject.optString("openid"), jSONObject.optString("nickname"), jSONObject.optString("headimgurl"), jSONObject);
            qCloudResultListener.onSuccess((Object)tACOpenUserInfo);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            qCloudResultListener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)jSONException)));
        }
    }
}

