/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization;

import android.content.Context;
import org.json.JSONArray;
import org.json.JSONObject;

public class TACAuthorizationOptions {
    private final JSONObject providerConfig;
    private boolean autoRefreshCredential = true;
    private JSONObject qqProviderConfig;
    private JSONObject wxProviderConfig;

    private TACAuthorizationOptions(Context context, JSONObject config) {
        this.providerConfig = config;
        this.qqProviderConfig = this.getProviderConfig("qq");
        this.wxProviderConfig = this.getProviderConfig("wechat");
    }

    public JSONObject getQQProviderConfig() {
        return this.qqProviderConfig;
    }

    public JSONObject getWxProviderConfig() {
        return this.wxProviderConfig;
    }

    private JSONObject getProviderConfig(String name) {
        JSONArray providers;
        if (this.providerConfig != null && (providers = this.providerConfig.optJSONArray("provider")) != null) {
            for (int i = 0; i < providers.length(); ++i) {
                JSONObject providerConfig = providers.optJSONObject(i);
                String providerName = providerConfig.optString("name");
                if (!name.equals(providerName)) continue;
                return providerConfig;
            }
        }
        return null;
    }

    TACAuthorizationOptions setAutoRefreshCredential(boolean autoRefreshCredential) {
        this.autoRefreshCredential = autoRefreshCredential;
        return this;
    }
}

