/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.tencent.tac.TACApplication;
import com.tencent.tac.authorization.TACAuthorizationOptions;
import com.tencent.tac.authorization.oauth2.WeChatAuthProvider;
import com.tencent.tac.option.TACApplicationOptions;
import org.json.JSONObject;

public abstract class WeChatBaseSignInActivity
extends Activity
implements IWXAPIEventHandler {
    private IWXAPI weixinAPI;
    private String appId;
    private String appKey;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TACApplicationOptions options = TACApplication.options();
        TACAuthorizationOptions authorizationOptions = (TACAuthorizationOptions)options.sub("authorization");
        JSONObject wxProviderConfig = authorizationOptions.getWxProviderConfig();
        if (wxProviderConfig == null) {
            throw new IllegalArgumentException("missing weixin config");
        }
        this.appId = wxProviderConfig.optString("app_id");
        this.appKey = wxProviderConfig.optString("app_key");
        this.weixinAPI = WXAPIFactory.createWXAPI((Context)this, (String)this.appId, (boolean)false);
        try {
            this.weixinAPI.handleIntent(this.getIntent(), (IWXAPIEventHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.weixinAPI.handleIntent(intent, (IWXAPIEventHandler)this);
    }

    public void onResp(BaseResp resp) {
        switch (resp.errCode) {
            case 0: {
                WeChatAuthProvider.setAuthorizationCode(((SendAuth.Resp)resp).code, this.appId, this.appKey, resp.errCode);
                break;
            }
            default: {
                WeChatAuthProvider.setAuthorizationCode(null, this.appId, this.appKey, resp.errCode);
            }
        }
        this.finish();
    }

    public void onReq(BaseReq baseReq) {
    }
}

