/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;
import com.tencent.qcloud.core.auth.OAuth2Credentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.tac.TACApplication;
import com.tencent.tac.authorization.TACAuthorizationOptions;
import com.tencent.tac.authorization.TACOpenUserInfo;
import com.tencent.tac.authorization.oauth2.QQAuthProvider;
import com.tencent.tac.option.TACApplicationOptions;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

public class WeChatAuthProvider {
    private static volatile IWXAPI api;
    private static QCloudResultListener<OAuth2Credentials> resultListener;
    private static QCloudResultListener<String> acListener;
    public static final String PLATFORM = "WeChat";
    private static final String DEFAULT_SCOPE = "snsapi_userinfo";
    private final String appId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WeChatAuthProvider(Context context) {
        TACApplicationOptions options = TACApplication.options();
        TACAuthorizationOptions authorizationOptions = (TACAuthorizationOptions)options.sub("authorization");
        JSONObject wxConfig = authorizationOptions.getWxProviderConfig();
        if (wxConfig == null) {
            throw new IllegalArgumentException("missing wechat config");
        }
        this.appId = wxConfig.optString("app_id");
        if (api != null) return;
        Class<QQAuthProvider> clazz = QQAuthProvider.class;
        synchronized (QQAuthProvider.class) {
            if (api != null) return;
            this.initWeChatApi(context, wxConfig);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void initWeChatApi(Context context, JSONObject wxConfig) {
        if (!this.hasWxOpenSdkLibrary()) {
            throw new IllegalStateException("missing wechat opensdk");
        }
        String appId = wxConfig.optString("app_id");
        api = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), (String)appId, (boolean)true);
        api.registerApp(appId);
    }

    public void signIn(QCloudResultListener<OAuth2Credentials> listener) {
        resultListener = listener;
        SendAuth.Req req = new SendAuth.Req();
        req.scope = DEFAULT_SCOPE;
        req.state = "none";
        api.sendReq((BaseReq)req);
    }

    public void requestAuthorizationCode(QCloudResultListener<String> listener) {
        acListener = listener;
        SendAuth.Req req = new SendAuth.Req();
        req.scope = DEFAULT_SCOPE;
        req.state = "none";
        api.sendReq((BaseReq)req);
    }

    public static boolean isUserNeedSignIn(QCloudServiceException exception) {
        if (exception != null) {
            int errorCode = Integer.parseInt(exception.getErrorCode());
            return errorCode == 40030 || errorCode == 42002;
        }
        return false;
    }

    public void getUserInfo(OAuth2Credentials credentials, final QCloudResultListener<TACOpenUserInfo> listener) {
        if (credentials.isExpired()) {
            listener.onFailure(new QCloudClientException("credential is expired"), null);
            return;
        }
        QCloudHttpClient.getDefault().resolveRequest(new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/userinfo").query("access_token", credentials.getAccessToken()).query("openid", credentials.getOpenId()).build()).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

            public void onSuccess(HttpResult<String> result) {
                if (result.isSuccessful()) {
                    WeChatAuthProvider.parseUserInfo((String)result.content(), (QCloudResultListener<TACOpenUserInfo>)listener);
                } else {
                    WeChatAuthProvider.parseError((String)result.content(), listener);
                }
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                listener.onFailure(clientException, serviceException);
            }
        });
    }

    public void refreshCredentialInBackground(OAuth2Credentials credentials, final QCloudResultListener<OAuth2Credentials> listener) {
        if (credentials.getRefreshToken() != null) {
            QCloudHttpClient.getDefault().resolveRequest(new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/oauth2/refresh_token").query("appid", this.appId).query("grant_type", "refresh_token").query("refresh_token", credentials.getRefreshToken()).build()).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

                public void onSuccess(HttpResult<String> result) {
                    if (result.isSuccessful()) {
                        WeChatAuthProvider.parseCredentials((String)result.content(), (QCloudResultListener<OAuth2Credentials>)listener);
                    } else {
                        WeChatAuthProvider.parseError((String)result.content(), listener);
                    }
                }

                public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                    listener.onFailure(clientException, serviceException);
                }
            });
        } else {
            listener.onFailure(new QCloudClientException("missing refresh token"), null);
        }
    }

    static void setAuthorizationCode(String authorizationCode, String appId, String appKey, int errorCode) {
        if (resultListener == null && acListener == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)authorizationCode)) {
            if (resultListener != null && !TextUtils.isEmpty((CharSequence)appKey)) {
                HttpRequest request = new HttpRequest.Builder().scheme("https").method("GET").host("api.weixin.qq.com").path("/sns/oauth2/access_token").query("appid", appId).query("secret", appKey).query("grant_type", "authorization_code").query("code", authorizationCode).build();
                QCloudHttpClient.getDefault().resolveRequest(request).schedule().observeOn((Executor)TaskExecutors.UI_THREAD_EXECUTOR).addResultListener((QCloudResultListener)new QCloudResultListener<HttpResult<String>>(){

                    public void onSuccess(HttpResult<String> result) {
                        if (result.isSuccessful()) {
                            WeChatAuthProvider.parseCredentials((String)result.content(), (QCloudResultListener<OAuth2Credentials>)resultListener);
                        } else {
                            WeChatAuthProvider.parseError((String)result.content(), resultListener);
                        }
                        resultListener = null;
                    }

                    public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                        resultListener.onFailure(clientException, serviceException);
                        resultListener = null;
                    }
                });
            } else if (resultListener != null) {
                resultListener.onSuccess((Object)new OAuth2Credentials.Builder().authorizationCode(authorizationCode).build());
                resultListener = null;
            } else {
                acListener.onSuccess((Object)authorizationCode);
                acListener = null;
            }
        } else {
            Object listener = resultListener != null ? resultListener : acListener;
            listener.onFailure(new QCloudClientException(String.format(Locale.ENGLISH, "login fails, error code is %d, message is %s", errorCode, WeChatAuthProvider.getErrorMessage(errorCode))), null);
            resultListener = null;
            acListener = null;
        }
    }

    private static String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case -4: {
                return "auth denied";
            }
            case -2: {
                return "user canceled";
            }
            case -6: {
                return "app signature is not matched";
            }
            case -5: {
                return "wechat client version not support";
            }
        }
        return "unknown reason";
    }

    private static <T> void parseError(String jsonResponse, QCloudResultListener<T> listener) {
        if (listener == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            int errorCode = jsonObject.optInt("errcode");
            String errorMessage = jsonObject.optString("errmsg");
            QCloudServiceException exception = new QCloudServiceException(errorMessage);
            exception.setErrorCode("" + errorCode);
            listener.onFailure(null, exception);
        }
        catch (JSONException e) {
            e.printStackTrace();
            listener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)e)));
        }
    }

    private static void parseCredentials(String jsonResponse, QCloudResultListener<OAuth2Credentials> listener) {
        if (listener == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            OAuth2Credentials wxCredentials = new OAuth2Credentials.Builder().accessToken(jsonObject.optString("access_token")).tokenStartTime(System.currentTimeMillis()).expiresInSeconds(jsonObject.optLong("expires_in")).openId(jsonObject.optString("openid")).refreshToken(jsonObject.optString("refresh_token")).scope(jsonObject.optString("scope")).platform(PLATFORM).build();
            listener.onSuccess((Object)wxCredentials);
        }
        catch (JSONException e) {
            e.printStackTrace();
            listener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)e)));
        }
    }

    private static void parseUserInfo(String jsonResponse, QCloudResultListener<TACOpenUserInfo> listener) {
        if (listener == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonResponse);
            TACOpenUserInfo userInfo = new TACOpenUserInfo(jsonObject.optString("openid"), jsonObject.optString("nickname"), jsonObject.optString("headimgurl"), jsonObject);
            listener.onSuccess((Object)userInfo);
        }
        catch (JSONException e) {
            e.printStackTrace();
            listener.onFailure(null, new QCloudServiceException("wechat json error", (Exception)((Object)e)));
        }
    }

    private boolean hasWxOpenSdkLibrary() {
        try {
            return Class.forName("com.tencent.mm.opensdk.openapi.IWXAPI") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

