/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tac.authorization.oauth2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.tencent.connect.UserInfo;
import com.tencent.connect.auth.QQToken;
import com.tencent.qcloud.core.auth.OAuth2Credentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.tac.TACApplication;
import com.tencent.tac.authorization.TACAuthorizationOptions;
import com.tencent.tac.authorization.TACOpenUserInfo;
import com.tencent.tac.option.TACApplicationOptions;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import org.json.JSONObject;

public class QQAuthProvider {
    private static volatile Tencent mTencent;
    private static final String DEFAULT_SCOPE = "get_simple_userinfo";
    public static final String PLATFORM = "QQ";
    private UILoginListenerWrapper tencentUiListener;
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QQAuthProvider(Context context) {
        TACApplicationOptions options = TACApplication.options();
        TACAuthorizationOptions authorizationOptions = (TACAuthorizationOptions)options.sub("authorization");
        JSONObject qqConfig = authorizationOptions.getQQProviderConfig();
        if (qqConfig == null) {
            throw new IllegalArgumentException("missing qq config");
        }
        this.mContext = context.getApplicationContext();
        if (mTencent != null) return;
        Class<QQAuthProvider> clazz = QQAuthProvider.class;
        synchronized (QQAuthProvider.class) {
            if (mTencent != null) return;
            this.initTencent(context, qqConfig);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void getUserInfo(OAuth2Credentials credentials, QCloudResultListener<TACOpenUserInfo> listener) {
        QQToken qqToken = mTencent.getQQToken();
        mTencent.setOpenId(credentials.getOpenId());
        mTencent.setAccessToken(credentials.getAccessToken(), "" + credentials.getExpiresInSeconds());
        if (qqToken == null || !qqToken.isSessionValid()) {
            listener.onFailure(new QCloudClientException("credential is expired"), null);
            return;
        }
        UserInfo userInfo = new UserInfo(this.mContext, qqToken);
        userInfo.getUserInfo((IUiListener)new UIUserInfoListenerWrapper(qqToken, listener));
    }

    public void handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.tencentUiListener != null && (requestCode == 11101 || requestCode == 10102)) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.tencentUiListener);
        }
    }

    public void signIn(Activity entrance, QCloudResultListener<OAuth2Credentials> resultListener) {
        this.tencentUiListener = new UILoginListenerWrapper(resultListener);
        mTencent.login(entrance, DEFAULT_SCOPE, (IUiListener)this.tencentUiListener);
    }

    private void initTencent(Context context, JSONObject qqConfig) {
        if (!this.hasQQOpenSdkLibrary()) {
            throw new IllegalStateException("missing qq opensdk");
        }
        String appId = qqConfig.optString("app_id");
        mTencent = Tencent.createInstance((String)appId, (Context)context.getApplicationContext());
    }

    private boolean hasQQOpenSdkLibrary() {
        try {
            return Class.forName("com.tencent.tauth.Tencent") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class UIUserInfoListenerWrapper
    extends UIListenerWrapper<TACOpenUserInfo> {
        private QQToken qqToken;

        UIUserInfoListenerWrapper(QQToken qqToken, QCloudResultListener<TACOpenUserInfo> listener) {
            super(listener);
            this.qqToken = qqToken;
        }

        @Override
        protected TACOpenUserInfo convert(JSONObject response) {
            String avatar = response.optString("figureurl_qq_2") == null ? response.optString("figureurl_qq_1") : response.optString("figureurl_qq_2");
            return new TACOpenUserInfo(this.qqToken.getOpenId(), response.optString("nickname"), avatar, response);
        }
    }

    private static class UILoginListenerWrapper
    extends UIListenerWrapper<OAuth2Credentials> {
        UILoginListenerWrapper(QCloudResultListener<OAuth2Credentials> listener) {
            super(listener);
        }

        @Override
        protected OAuth2Credentials convert(JSONObject response) {
            return new OAuth2Credentials.Builder().accessToken(response.optString("access_token")).tokenStartTime(System.currentTimeMillis()).expiresInSeconds(response.optLong("expires_in")).openId(response.optString("openid")).scope(QQAuthProvider.DEFAULT_SCOPE).platform(QQAuthProvider.PLATFORM).build();
        }
    }

    private static abstract class UIListenerWrapper<T>
    implements IUiListener {
        private final QCloudResultListener<T> customListener;

        UIListenerWrapper(QCloudResultListener<T> listener) {
            this.customListener = listener;
        }

        protected abstract T convert(JSONObject var1);

        public void onComplete(Object o) {
            if (o instanceof JSONObject) {
                JSONObject response = (JSONObject)o;
                T result = this.convert(response);
                this.customListener.onSuccess(result);
            } else {
                this.customListener.onFailure(null, new QCloudServiceException("qq json error"));
            }
        }

        public void onError(UiError uiError) {
            this.customListener.onFailure(null, null);
        }

        public void onCancel() {
        }
    }
}

