/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk.download;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicUtils;
import com.tencent.sonic.sdk.download.SonicDownloadCache;
import com.tencent.sonic.sdk.download.SonicDownloadCallback;
import com.tencent.sonic.sdk.download.SonicDownloadClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SonicDownloadEngine
implements Handler.Callback {
    public static final String TAG = "SonicSdk_SonicDownloadEngine";
    private static final int MSG_ENQUEUE = 0;
    private static final int MSG_DEQUEUE = 1;
    private ConcurrentMap<String, SonicDownloadClient.DownloadTask> resourceTasks = new ConcurrentHashMap<String, SonicDownloadClient.DownloadTask>();
    private final SonicDownloadQueue mQueue = new SonicDownloadQueue();
    private Handler mHandler;
    private AtomicInteger mNumOfDownloadingTask;
    private SonicDownloadCache mCache;

    public SonicDownloadEngine(SonicDownloadCache cache) {
        HandlerThread queueThread = new HandlerThread("Download-Thread");
        queueThread.start();
        this.mHandler = new Handler(queueThread.getLooper(), (Handler.Callback)this);
        this.mNumOfDownloadingTask = new AtomicInteger(0);
        this.mCache = cache;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                SonicDownloadClient.DownloadTask task = (SonicDownloadClient.DownloadTask)msg.obj;
                this.mQueue.enqueue(task);
                task.mState.set(1);
                SonicUtils.log(TAG, 4, "enqueue sub resource(" + task.mResourceUrl + ").");
                break;
            }
            case 1: {
                if (this.mQueue.isEmpty()) break;
                SonicDownloadClient.DownloadTask task = this.mQueue.dequeue();
                this.startDownload(task);
                SonicUtils.log(TAG, 4, "dequeue sub resource(" + task.mResourceUrl + ").");
                break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SonicDownloadClient.DownloadTask download(String resourceUrl, String ipAddress, String cookie, SonicDownloadCallback callback) {
        if (TextUtils.isEmpty((CharSequence)resourceUrl)) {
            return null;
        }
        SonicDownloadQueue sonicDownloadQueue = this.mQueue;
        synchronized (sonicDownloadQueue) {
            if (this.mQueue.containsKey(resourceUrl)) {
                SonicUtils.log(TAG, 4, "sub resource download task has been in queue (" + resourceUrl + ").");
                return (SonicDownloadClient.DownloadTask)this.mQueue.get(resourceUrl);
            }
        }
        final SonicDownloadClient.DownloadTask task = new SonicDownloadClient.DownloadTask();
        task.mResourceUrl = resourceUrl;
        task.mCallbacks.add(callback);
        task.mCallbacks.add(new SonicDownloadCallback.SimpleDownloadCallback(){

            @Override
            public void onFinish() {
                task.mState.set(3);
                SonicDownloadEngine.this.mHandler.sendEmptyMessage(1);
            }
        });
        byte[] resourceBytes = this.mCache.getResourceCache(resourceUrl);
        if (resourceBytes != null) {
            task.mInputStream = new ByteArrayInputStream(resourceBytes);
            task.mRspHeaders = this.mCache.getResourceCacheHeader(resourceUrl);
            task.mState.set(4);
            SonicUtils.log(TAG, 4, "load sub resource(" + resourceUrl + ") from cache.");
            return task;
        }
        task.mIpAddress = ipAddress;
        task.mCookie = cookie;
        if (this.mNumOfDownloadingTask.get() < SonicEngine.getInstance().getConfig().SONIC_MAX_NUM_OF_DOWNLOADING_TASK) {
            this.startDownload(task);
        } else {
            Message enqueueMsg = this.mHandler.obtainMessage(0, (Object)task);
            this.mHandler.sendMessage(enqueueMsg);
        }
        return task;
    }

    private void startDownload(final SonicDownloadClient.DownloadTask task) {
        SonicEngine.getInstance().getRuntime().postTaskToSessionThread(new Runnable(){

            @Override
            public void run() {
                SonicDownloadEngine.this.mNumOfDownloadingTask.incrementAndGet();
                task.mState.set(2);
                SonicDownloadClient engine = new SonicDownloadClient(task);
                engine.download();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onRequestSubResource(String url, SonicSession session) {
        Object webResourceResponse;
        SonicDownloadClient.DownloadTask subRes;
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session onRequestSubResource: resource url(" + url + ").");
        }
        InputStream inputStream = null;
        Map<String, List<String>> headers = null;
        if (this.resourceTasks.containsKey(url)) {
            subRes = (SonicDownloadClient.DownloadTask)this.resourceTasks.get(url);
            subRes.mWasInterceptInvoked.set(true);
            if (subRes.mState.get() == 0 || subRes.mState.get() == 1) {
                return null;
            }
            if (subRes.mInputStream == null) {
                AtomicBoolean atomicBoolean = subRes.mWasInterceptInvoked;
                synchronized (atomicBoolean) {
                    try {
                        subRes.mWasInterceptInvoked.wait(3000L);
                    }
                    catch (InterruptedException e) {
                        SonicUtils.log(TAG, 6, "session onRequestSubResource error: " + e.getMessage());
                    }
                }
            }
            if (subRes.mInputStream == null) {
                return null;
            }
        } else {
            return null;
        }
        inputStream = subRes.mInputStream;
        headers = subRes.mRspHeaders;
        if (!session.isDestroyedOrWaitingForDestroy()) {
            String mime = SonicUtils.getMime(url);
            HashMap<String, String> filteredHeaders = SonicUtils.getFilteredHeaders(headers);
            webResourceResponse = SonicEngine.getInstance().getRuntime().createWebResourceResponse(mime, session.getCharsetFromHeaders(filteredHeaders), inputStream, filteredHeaders);
        } else {
            webResourceResponse = null;
            SonicUtils.log(TAG, 6, "session onRequestSubResource error: session is destroyed!");
        }
        return webResourceResponse;
    }

    public void addSubResourcePreloadTask(List<String> preloadLinks) {
        SonicRuntime runtime = SonicEngine.getInstance().getRuntime();
        for (String link : preloadLinks) {
            if (this.resourceTasks.containsKey(link)) continue;
            this.resourceTasks.put(link, this.download(link, runtime.getHostDirectAddress(link), runtime.getCookie(link), new SonicDownloadClient.SubResourceDownloadCallback(link)));
        }
    }

    private static class SonicDownloadQueue
    extends LinkedHashMap<String, SonicDownloadClient.DownloadTask> {
        private SonicDownloadQueue() {
        }

        synchronized SonicDownloadClient.DownloadTask dequeue() {
            if (this.values().iterator().hasNext()) {
                SonicDownloadClient.DownloadTask task = (SonicDownloadClient.DownloadTask)this.values().iterator().next();
                return (SonicDownloadClient.DownloadTask)this.remove(task.mResourceUrl);
            }
            return null;
        }

        synchronized void enqueue(SonicDownloadClient.DownloadTask task) {
            if (task != null && !TextUtils.isEmpty((CharSequence)task.mResourceUrl)) {
                this.put(task.mResourceUrl, task);
            }
        }
    }
}

