/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.support.annotation.NonNull;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public class SonicSessionStream
extends InputStream {
    private static final String TAG = "SonicSdk_SonicSessionStream";
    private BufferedInputStream netStream;
    private BufferedInputStream memStream;
    private ByteArrayOutputStream outputStream;
    private boolean netStreamReadComplete = true;
    private boolean memStreamReadComplete = true;
    private final WeakReference<Callback> callbackWeakReference;

    public SonicSessionStream(Callback callback, ByteArrayOutputStream outputStream, BufferedInputStream netStream) {
        if (null != netStream) {
            this.netStream = netStream;
            this.netStreamReadComplete = false;
        }
        if (outputStream != null) {
            this.outputStream = outputStream;
            this.memStream = new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
            this.memStreamReadComplete = false;
        } else {
            this.outputStream = new ByteArrayOutputStream();
        }
        this.callbackWeakReference = new WeakReference<Callback>(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Callback callback;
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "close: memory stream and socket stream, netStreamReadComplete=" + this.netStreamReadComplete + ", memStreamReadComplete=" + this.memStreamReadComplete);
        }
        Throwable error = null;
        try {
            if (null != this.memStream) {
                this.memStream.close();
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "close memStream error:" + e.getMessage());
            error = e;
        }
        finally {
            this.memStream = null;
        }
        try {
            if (null != this.netStream) {
                this.netStream.close();
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "close netStream error:" + e.getMessage());
            error = e;
        }
        finally {
            this.netStream = null;
        }
        if (null != (callback = (Callback)this.callbackWeakReference.get())) {
            callback.onClose(this.netStreamReadComplete && this.memStreamReadComplete, this.outputStream);
        }
        this.outputStream = null;
        if (error != null) {
            SonicUtils.log(TAG, 6, "throw error:" + error.getMessage());
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            throw new IOException(error);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        int c = -1;
        try {
            if (null != this.memStream && !this.memStreamReadComplete) {
                c = this.memStream.read();
            }
            if (-1 == c) {
                this.memStreamReadComplete = true;
                if (null != this.netStream && !this.netStreamReadComplete) {
                    c = this.netStream.read();
                    if (-1 != c) {
                        this.outputStream.write(c);
                    } else {
                        this.netStreamReadComplete = true;
                    }
                }
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "read error:" + e.getMessage());
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        return c;
    }

    @Override
    public synchronized int read(@NonNull byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public synchronized int read(@NonNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int arrayLength = buffer.length;
        if ((byteOffset | byteCount) < 0 || byteOffset > arrayLength || arrayLength - byteOffset < byteCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < byteCount; ++i) {
            int c;
            try {
                c = this.read();
                if (c == -1) {
                    return i == 0 ? -1 : i;
                }
            }
            catch (IOException e) {
                if (i != 0) {
                    return i;
                }
                throw e;
            }
            buffer[byteOffset + i] = (byte)c;
        }
        return byteCount;
    }

    public static interface Callback {
        public void onClose(boolean var1, ByteArrayOutputStream var2);
    }
}

