/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionCallback;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class QuickSonicSession
extends SonicSession
implements Handler.Callback {
    private static final String TAG = "SonicSdk_QuickSonicSession";
    private static final int CLIENT_CORE_MSG_BEGIN = 4;
    private static final int CLIENT_CORE_MSG_PRE_LOAD = 5;
    private static final int CLIENT_CORE_MSG_FIRST_LOAD = 6;
    private static final int CLIENT_CORE_MSG_DATA_UPDATE = 7;
    private static final int CLIENT_CORE_MSG_TEMPLATE_CHANGE = 8;
    private static final int CLIENT_CORE_MSG_CONNECTION_ERROR = 9;
    private static final int CLIENT_CORE_MSG_SERVICE_UNAVAILABLE = 10;
    private static final int CLIENT_CORE_MSG_END = 11;
    private Message pendingClientCoreMessage;
    private static final int PRE_LOAD_NO_CACHE = 1;
    private static final int PRE_LOAD_WITH_CACHE = 2;
    private static final int FIRST_LOAD_NO_DATA = 1;
    private static final int FIRST_LOAD_WITH_DATA = 2;
    private static final int TEMPLATE_CHANGE_REFRESH = 1;
    private final AtomicBoolean wasLoadUrlInvoked = new AtomicBoolean(false);
    private final AtomicBoolean wasLoadDataInvoked = new AtomicBoolean(false);

    QuickSonicSession(String id, String url, SonicSessionConfig config) {
        super(id, url, config);
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (super.handleMessage(msg)) {
            return true;
        }
        if (4 < msg.what && msg.what < 11 && !this.clientIsReady.get()) {
            this.pendingClientCoreMessage = Message.obtain((Message)msg);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleMessage: client not ready, core msg = " + msg.what + ".");
            return true;
        }
        switch (msg.what) {
            case 5: {
                this.handleClientCoreMessage_PreLoad(msg);
                break;
            }
            case 6: {
                this.handleClientCoreMessage_FirstLoad(msg);
                break;
            }
            case 9: {
                this.handleClientCoreMessage_ConnectionError(msg);
                break;
            }
            case 10: {
                this.handleClientCoreMessage_ServiceUnavailable(msg);
                break;
            }
            case 7: {
                this.handleClientCoreMessage_DataUpdate(msg);
                break;
            }
            case 8: {
                this.handleClientCoreMessage_TemplateChange(msg);
                break;
            }
            case 1: {
                this.setResult(msg.arg1, msg.arg2, true);
                break;
            }
            case 2: {
                this.diffDataCallback = (SonicDiffDataCallback)msg.obj;
                this.setResult(this.srcResultCode, this.finalResultCode, true);
                break;
            }
            default: {
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") can not  recognize refresh type: " + msg.what);
                }
                return false;
            }
        }
        return true;
    }

    private void handleClientCoreMessage_ConnectionError(Message msg) {
        if (this.wasLoadUrlInvoked.compareAndSet(false, true)) {
            if (SonicUtils.shouldLog(4)) {
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_ConnectionError: load src url.");
            }
            this.sessionClient.loadUrl(this.srcUrl, null);
        }
    }

    private void handleClientCoreMessage_ServiceUnavailable(Message msg) {
        if (this.wasLoadUrlInvoked.compareAndSet(false, true)) {
            if (SonicUtils.shouldLog(4)) {
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_ServiceUnavailable:load src url.");
            }
            this.sessionClient.loadUrl(this.srcUrl, null);
        }
    }

    private void handleClientCoreMessage_PreLoad(Message msg) {
        switch (msg.arg1) {
            case 1: {
                if (this.wasLoadUrlInvoked.compareAndSet(false, true)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleClientCoreMessage_PreLoad:PRE_LOAD_NO_CACHE load url.");
                    this.sessionClient.loadUrl(this.srcUrl, null);
                    break;
                }
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleClientCoreMessage_PreLoad:wasLoadUrlInvoked = true.");
                break;
            }
            case 2: {
                if (this.wasLoadDataInvoked.compareAndSet(false, true)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleClientCoreMessage_PreLoad:PRE_LOAD_WITH_CACHE load data.");
                    String html = (String)msg.obj;
                    this.sessionClient.loadDataWithBaseUrlAndHeader(this.srcUrl, html, "text/html", SonicUtils.DEFAULT_CHARSET, this.srcUrl, this.getCacheHeaders());
                    break;
                }
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleClientCoreMessage_PreLoad:wasLoadDataInvoked = true.");
            }
        }
    }

    private void handleClientCoreMessage_FirstLoad(Message msg) {
        switch (msg.arg1) {
            case 1: {
                if (this.wasInterceptInvoked.get()) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleClientCoreMessage_FirstLoad:FIRST_LOAD_NO_DATA.");
                    this.setResult(1000, 1000, true);
                    break;
                }
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleClientCoreMessage_FirstLoad:url was not invoked.");
                break;
            }
            case 2: {
                if (this.wasLoadUrlInvoked.compareAndSet(false, true)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleClientCoreMessage_FirstLoad:oh yeah, first load hit 304.");
                    this.sessionClient.loadDataWithBaseUrlAndHeader(this.srcUrl, (String)msg.obj, "text/html", this.getCharsetFromHeaders(), this.srcUrl, this.getHeaders());
                    this.setResult(1000, 304, false);
                    break;
                }
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") FIRST_LOAD_WITH_DATA load url was invoked.");
                this.setResult(1000, 1000, true);
            }
        }
    }

    private void handleClientCoreMessage_DataUpdate(Message msg) {
        String htmlString = (String)msg.obj;
        String diffData = msg.getData().getString("_diff_data_");
        if (this.wasLoadDataInvoked.get()) {
            this.pendingDiffData = diffData;
            if (!TextUtils.isEmpty((CharSequence)diffData)) {
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_DataUpdate:try to notify web callback.");
                this.setResult(200, 200, true);
            } else {
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_DataUpdate:diffData is null, cache-offline = store , do not refresh.");
                this.setResult(200, 304, true);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)htmlString)) {
            SonicUtils.log(TAG, 4, "handleClientCoreMessage_DataUpdate:oh yeah data update hit 304, now clear pending data ->" + (null != this.pendingDiffData) + ".");
            this.pendingDiffData = null;
            this.sessionClient.loadDataWithBaseUrlAndHeader(this.srcUrl, htmlString, "text/html", this.getCharsetFromHeaders(), this.srcUrl, this.getHeaders());
            this.setResult(200, 304, false);
            return;
        }
        SonicUtils.log(TAG, 6, "handleClientCoreMessage_DataUpdate error:call load url.");
        this.sessionClient.loadUrl(this.srcUrl, null);
        this.setResult(200, 1000, false);
    }

    private void handleClientCoreMessage_TemplateChange(Message msg) {
        SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange wasLoadDataInvoked = " + this.wasLoadDataInvoked.get() + ",msg arg1 = " + msg.arg1);
        if (this.wasLoadDataInvoked.get()) {
            if (1 == msg.arg1) {
                String html = (String)msg.obj;
                if (TextUtils.isEmpty((CharSequence)html)) {
                    SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:load url with preload=2, webCallback is null? ->" + (null != this.diffDataCallback));
                    this.sessionClient.loadUrl(this.srcUrl, null);
                } else {
                    SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:load data.");
                    this.sessionClient.loadDataWithBaseUrlAndHeader(this.srcUrl, html, "text/html", this.getCharsetFromHeaders(), this.srcUrl, this.getHeaders());
                }
                this.setResult(2000, 2000, false);
            } else {
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:not refresh.");
                this.setResult(2000, 304, true);
            }
        } else {
            SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:oh yeah template change hit 304.");
            if (msg.obj instanceof String) {
                String html = (String)msg.obj;
                this.sessionClient.loadDataWithBaseUrlAndHeader(this.srcUrl, html, "text/html", this.getCharsetFromHeaders(), this.srcUrl, this.getHeaders());
                this.setResult(2000, 304, false);
            } else {
                SonicUtils.log(TAG, 6, "handleClientCoreMessage_TemplateChange error:call load url.");
                this.sessionClient.loadUrl(this.srcUrl, null);
                this.setResult(2000, 1000, false);
            }
        }
        this.diffDataCallback = null;
        this.mainHandler.removeMessages(2);
    }

    @Override
    protected void handleFlow_LoadLocalCache(String cacheHtml) {
        Message msg = this.mainHandler.obtainMessage(5);
        if (!TextUtils.isEmpty((CharSequence)cacheHtml)) {
            msg.arg1 = 2;
            msg.obj = cacheHtml;
        } else {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") runSonicFlow has no cache, do first load flow.");
            msg.arg1 = 1;
        }
        this.mainHandler.sendMessage(msg);
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionLoadLocalCache(cacheHtml);
        }
    }

    @Override
    public boolean onWebReady(SonicDiffDataCallback callback) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") onWebReady: webCallback has set ? ->" + (null != this.diffDataCallback));
        if (null != this.diffDataCallback) {
            this.diffDataCallback = null;
            SonicUtils.log(TAG, 5, "session(" + this.sId + ") onWebReady: call more than once.");
        }
        Message msg = Message.obtain();
        msg.what = 2;
        msg.obj = callback;
        this.mainHandler.sendMessage(msg);
        return true;
    }

    @Override
    public boolean onClientReady() {
        if (this.clientIsReady.compareAndSet(false, true)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClientReady: have pending client core message ? -> " + (null != this.pendingClientCoreMessage) + ".");
            if (null != this.pendingClientCoreMessage) {
                Message message = this.pendingClientCoreMessage;
                this.pendingClientCoreMessage = null;
                this.handleMessage(message);
            } else if (0 == this.sessionState.get()) {
                this.start();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object onRequestResource(String url) {
        if (this.wasInterceptInvoked.get() || !this.isMatchCurrentUrl(url)) {
            return null;
        }
        if (!this.wasInterceptInvoked.compareAndSet(false, true)) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ")  onClientRequestResource error:Intercept was already invoked, url = " + url);
            return null;
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ")  onClientRequestResource:url = " + url);
        }
        long startTime = System.currentTimeMillis();
        if (this.sessionState.get() == 1) {
            AtomicInteger atomicInteger = this.sessionState;
            synchronized (atomicInteger) {
                try {
                    if (this.sessionState.get() == 1) {
                        SonicUtils.log(TAG, 4, "session(" + this.sId + ") now wait for pendingWebResourceStream!");
                        this.sessionState.wait(30000L);
                    }
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") wait for pendingWebResourceStream failed" + e.getMessage());
                }
            }
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") is not in running state: " + this.sessionState);
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") have pending stream? -> " + (this.pendingWebResourceStream != null) + ", cost " + (System.currentTimeMillis() - startTime) + "ms.");
        if (null != this.pendingWebResourceStream) {
            Object webResourceResponse;
            if (!this.isDestroyedOrWaitingForDestroy()) {
                String mime = SonicUtils.getMime(this.srcUrl);
                webResourceResponse = SonicEngine.getInstance().getRuntime().createWebResourceResponse(mime, this.getCharsetFromHeaders(), this.pendingWebResourceStream, this.getHeaders());
            } else {
                webResourceResponse = null;
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClientRequestResource error: session is destroyed!");
            }
            this.pendingWebResourceStream = null;
            return webResourceResponse;
        }
        return null;
    }

    @Override
    protected void handleFlow_HttpError(int responseCode) {
        if (this.config.RELOAD_IN_BAD_NETWORK) {
            this.mainHandler.removeMessages(5);
            Message msg = this.mainHandler.obtainMessage(9);
            msg.arg1 = responseCode;
            this.mainHandler.sendMessage(msg);
        }
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionHttpError(responseCode);
        }
    }

    @Override
    protected void handleFlow_ServiceUnavailable() {
        this.mainHandler.removeMessages(5);
        Message msg = this.mainHandler.obtainMessage(10);
        this.mainHandler.sendMessage(msg);
    }

    @Override
    protected void handleFlow_TemplateChange(String newHtml) {
        try {
            Message msg;
            SonicUtils.log(TAG, 4, "handleFlow_TemplateChange.");
            String htmlString = newHtml;
            long startTime = System.currentTimeMillis();
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                this.pendingWebResourceStream = this.server.getResponseStream(this.wasOnPageFinishInvoked);
                if (this.pendingWebResourceStream == null) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:server.getResponseStream = null!");
                    return;
                }
                htmlString = this.server.getResponseData(this.clientIsReload.get());
            }
            String cacheOffline = this.server.getResponseHeaderField("cache-offline");
            if (!this.clientIsReload.get()) {
                this.mainHandler.removeMessages(5);
                msg = this.mainHandler.obtainMessage(8);
                msg.obj = htmlString;
                if (!"store".equals(cacheOffline)) {
                    msg.arg1 = 1;
                }
                this.mainHandler.sendMessage(msg);
            } else {
                msg = this.mainHandler.obtainMessage(1);
                msg.arg1 = 2000;
                msg.arg2 = 2000;
                this.mainHandler.sendMessage(msg);
            }
            for (WeakReference ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)ref.get();
                if (callback == null) continue;
                callback.onSessionTemplateChanged(htmlString);
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") read byte stream cost " + (System.currentTimeMillis() - startTime) + " ms, wasInterceptInvoked: " + this.wasInterceptInvoked.get());
            }
            if (SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
                this.switchState(1, 2, true);
                if (!TextUtils.isEmpty((CharSequence)htmlString)) {
                    this.postTaskToSaveSonicCache(htmlString);
                }
            } else if ("false".equals(cacheOffline)) {
                SonicUtils.removeSessionCache(this.id);
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:offline mode is 'false', so clean cache.");
            } else {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_TemplateChange:offline->" + cacheOffline + " , so do not need cache to file.");
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleFlow_TemplateChange error:" + e.getMessage());
        }
    }

    @Override
    protected void handleFlow_FirstLoad() {
        this.pendingWebResourceStream = this.server.getResponseStream(this.wasInterceptInvoked);
        if (null == this.pendingWebResourceStream) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:server.getResponseStream is null!");
            return;
        }
        String htmlString = this.server.getResponseData(false);
        boolean hasCompletionData = !TextUtils.isEmpty((CharSequence)htmlString);
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:hasCompletionData=" + hasCompletionData + ".");
        this.mainHandler.removeMessages(5);
        Message msg = this.mainHandler.obtainMessage(6);
        msg.obj = htmlString;
        msg.arg1 = hasCompletionData ? 2 : 1;
        this.mainHandler.sendMessage(msg);
        for (WeakReference ref : this.sessionCallbackList) {
            SonicSessionCallback callback = (SonicSessionCallback)ref.get();
            if (callback == null) continue;
            callback.onSessionFirstLoad(htmlString);
        }
        String cacheOffline = this.server.getResponseHeaderField("cache-offline");
        if (SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
            if (hasCompletionData && !this.wasLoadUrlInvoked.get() && !this.wasInterceptInvoked.get()) {
                this.switchState(1, 2, true);
                this.postTaskToSaveSonicCache(htmlString);
            }
        } else {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:offline->" + cacheOffline + " , so do not need cache to file.");
        }
    }

    @Override
    protected void handleFlow_DataUpdate(String serverRsp) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: start.");
        try {
            Object msg;
            String htmlString = null;
            if (TextUtils.isEmpty((CharSequence)serverRsp)) {
                serverRsp = this.server.getResponseData(true);
            } else {
                htmlString = this.server.getResponseData(false);
            }
            if (TextUtils.isEmpty((CharSequence)serverRsp)) {
                SonicUtils.log(TAG, 6, "handleFlow_DataUpdate:getResponseData error.");
                return;
            }
            String eTag = this.server.getResponseHeaderField(this.getCustomHeadFieldEtagKey());
            String templateTag = this.server.getResponseHeaderField("template-tag");
            String cacheOffline = this.server.getResponseHeaderField("cache-offline");
            long startTime = System.currentTimeMillis();
            JSONObject serverRspJson = new JSONObject(serverRsp);
            JSONObject serverDataJson = serverRspJson.optJSONObject("data");
            String htmlSha1 = serverRspJson.optString("html-sha1");
            JSONObject diffDataJson = SonicUtils.getDiffData(this.id, serverDataJson);
            Bundle diffDataBundle = new Bundle();
            if (null != diffDataJson) {
                diffDataBundle.putString("_diff_data_", diffDataJson.toString());
            } else {
                SonicUtils.log(TAG, 6, "handleFlow_DataUpdate:getDiffData error.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1006);
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:getDiffData cost " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            boolean hasSentDataUpdateMessage = false;
            if (this.wasLoadDataInvoked.get()) {
                if (SonicUtils.shouldLog(4)) {
                    SonicUtils.log(TAG, 4, "handleFlow_DataUpdate:loadData was invoked, quick notify web data update.");
                }
                msg = this.mainHandler.obtainMessage(7);
                if (!"store".equals(cacheOffline)) {
                    msg.setData(diffDataBundle);
                }
                this.mainHandler.sendMessage((Message)msg);
                hasSentDataUpdateMessage = true;
            }
            startTime = System.currentTimeMillis();
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                htmlString = SonicUtils.buildHtml(this.id, serverDataJson, htmlSha1, serverRsp.length());
            }
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:buildHtml cost " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            if (TextUtils.isEmpty((CharSequence)htmlString)) {
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1008);
            }
            if (!hasSentDataUpdateMessage) {
                this.mainHandler.removeMessages(5);
                msg = this.mainHandler.obtainMessage(7);
                ((Message)msg).obj = htmlString;
                this.mainHandler.sendMessage((Message)msg);
            }
            for (Object ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)((Reference)ref).get();
                if (callback == null) continue;
                callback.onSessionDataUpdated(serverRsp);
            }
            if (null == diffDataJson || null == htmlString || !SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, this.server.getResponseHeaderFields())) {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: clean session cache.");
                SonicUtils.removeSessionCache(this.id);
                return;
            }
            this.switchState(1, 2, true);
            Thread.yield();
            startTime = System.currentTimeMillis();
            Map<String, List<String>> headers = this.server.getResponseHeaderFields();
            for (WeakReference ref : this.sessionCallbackList) {
                SonicSessionCallback callback = (SonicSessionCallback)ref.get();
                if (callback == null) continue;
                callback.onSessionSaveCache(htmlString, null, serverDataJson.toString());
            }
            if (SonicUtils.saveSessionFiles(this.id, htmlString, null, serverDataJson.toString(), headers)) {
                long htmlSize = new File(SonicFileUtils.getSonicHtmlPath(this.id)).length();
                SonicUtils.saveSonicData(this.id, eTag, templateTag, htmlSha1, htmlSize, headers);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: finish save session cache, cost " + (System.currentTimeMillis() - startTime) + " ms.");
            } else {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate: save session files fail.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1004);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate error:" + e.getMessage());
        }
    }

    @Override
    protected void clearSessionData() {
        if (null != this.pendingClientCoreMessage) {
            this.pendingClientCoreMessage = null;
        }
    }
}

