/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Intent;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionConnection;
import com.tencent.sonic.sdk.SonicSessionConnectionInterceptor;
import com.tencent.sonic.sdk.SonicSessionStream;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class SonicServer
implements SonicSessionStream.Callback {
    public static final String TAG = "SonicSdk_SonicServer";
    protected final SonicSessionConnection connectionImpl;
    protected String serverRsp;
    protected String templateString;
    protected String dataString;
    protected int responseCode;
    protected final SonicSession session;
    protected final Intent requestIntent;
    protected Map<String, List<String>> cachedResponseHeaders;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    public SonicServer(SonicSession session, Intent requestIntent) {
        this.session = session;
        this.requestIntent = requestIntent;
        this.connectionImpl = SonicSessionConnectionInterceptor.getSonicSessionConnection(session, requestIntent);
    }

    protected int connect() {
        String requestTemplateTag;
        String templateTag;
        long startTime = System.currentTimeMillis();
        int resultCode = this.connectionImpl.connect();
        this.session.statistics.connectionConnectTime = System.currentTimeMillis();
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.session.id + ") server connect cost = " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        if (0 != resultCode) {
            return resultCode;
        }
        startTime = System.currentTimeMillis();
        this.responseCode = this.connectionImpl.getResponseCode();
        this.session.statistics.connectionRespondTime = System.currentTimeMillis();
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.session.id + ") server response cost = " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        if (304 == this.responseCode) {
            return 0;
        }
        if (200 != this.responseCode) {
            return 0;
        }
        String eTag = this.getResponseHeaderField("eTag");
        if (!TextUtils.isEmpty((CharSequence)eTag) && eTag.toLowerCase().startsWith("w/")) {
            eTag = eTag.toLowerCase().replace("w/", "");
            eTag = eTag.replace("\"", "");
            this.addResponseHeaderFields("eTag", eTag);
        }
        String requestETag = this.requestIntent.getStringExtra("eTag");
        String responseETag = this.getResponseHeaderField("eTag");
        if (!TextUtils.isEmpty((CharSequence)requestETag) && requestETag.equals(responseETag)) {
            this.responseCode = 304;
            return 0;
        }
        if (this.isSonicResponse() || !this.session.config.SUPPORT_LOCAL_SERVER) {
            return 0;
        }
        String cacheOffline = this.getResponseHeaderField("cache-offline");
        if ("http".equalsIgnoreCase(cacheOffline)) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)cacheOffline)) {
            this.addResponseHeaderFields("cache-offline", "true");
        }
        if (this.isFirstLoadRequest()) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)eTag)) {
            this.readServerResponse(null);
            if (TextUtils.isEmpty((CharSequence)this.serverRsp)) {
                return -901;
            }
            eTag = SonicUtils.getSHA1(this.serverRsp);
            this.addResponseHeaderFields("eTag", eTag);
            this.addResponseHeaderFields("sonic-html-sha1", eTag);
            if (requestETag.equals(eTag)) {
                this.responseCode = 304;
                return 0;
            }
        }
        if (TextUtils.isEmpty((CharSequence)(templateTag = this.getResponseHeaderField("template-tag")))) {
            if (TextUtils.isEmpty((CharSequence)this.serverRsp)) {
                this.readServerResponse(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.serverRsp)) {
                this.separateTemplateAndData();
                templateTag = this.getResponseHeaderField("template-tag");
            } else {
                return -901;
            }
        }
        if ((requestTemplateTag = this.requestIntent.getStringExtra("template-tag")).equals(templateTag)) {
            this.addResponseHeaderFields("template-change", "false");
        } else {
            this.addResponseHeaderFields("template-change", "true");
        }
        return 0;
    }

    private boolean isSonicResponse() {
        Map<String, List<String>> headersFromServer = this.connectionImpl.getResponseHeaderFields();
        if (null != headersFromServer && !headersFromServer.isEmpty()) {
            Set<Map.Entry<String, List<String>>> entrySet = headersFromServer.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                String KeyInLowercase;
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || !(KeyInLowercase = entry.getKey().toLowerCase()).equals("cache-offline") && !KeyInLowercase.equals("template-change") && !KeyInLowercase.equals("template-tag")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFirstLoadRequest() {
        return TextUtils.isEmpty((CharSequence)this.requestIntent.getStringExtra("eTag")) || TextUtils.isEmpty((CharSequence)this.requestIntent.getStringExtra("template-tag"));
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void disconnect() {
        try {
            BufferedInputStream bufferedInputStream = this.connectionImpl.getResponseStream();
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "session(" + this.session.sId + ") server disconnect error:" + e.getMessage() + ".");
        }
        this.connectionImpl.disconnect();
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        if (null == this.cachedResponseHeaders) {
            Map<String, List<String>> headersFromServer;
            this.cachedResponseHeaders = new ConcurrentHashMap<String, List<String>>();
            if (this.session.config.customResponseHeaders != null && this.session.config.customResponseHeaders.size() > 0) {
                for (Map.Entry<String, String> entry : this.session.config.customResponseHeaders.entrySet()) {
                    String key = entry.getKey();
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    List<String> tmpHeaderList = this.cachedResponseHeaders.get(key.toLowerCase());
                    if (null == tmpHeaderList) {
                        tmpHeaderList = new ArrayList<String>(1);
                        this.cachedResponseHeaders.put(key.toLowerCase(), tmpHeaderList);
                    }
                    tmpHeaderList.add(entry.getValue());
                }
            }
            if (null != (headersFromServer = this.connectionImpl.getResponseHeaderFields()) && !headersFromServer.isEmpty()) {
                Set<Map.Entry<String, List<String>>> entrySet = headersFromServer.entrySet();
                for (Map.Entry<String, List<String>> entry : entrySet) {
                    String key = entry.getKey();
                    if (TextUtils.isEmpty((CharSequence)key)) continue;
                    this.cachedResponseHeaders.put(key.toLowerCase(), entry.getValue());
                }
            }
        }
        return this.cachedResponseHeaders;
    }

    public String getResponseHeaderField(String key) {
        List<String> responseHeaderValues;
        Map<String, List<String>> responseHeaderFields = this.getResponseHeaderFields();
        if (null != responseHeaderFields && 0 != responseHeaderFields.size() && null != (responseHeaderValues = responseHeaderFields.get(key.toLowerCase())) && 0 != responseHeaderValues.size()) {
            StringBuilder stringBuilder = new StringBuilder(responseHeaderValues.get(0));
            int size = responseHeaderValues.size();
            for (int index = 1; index < size; ++index) {
                stringBuilder.append(',');
                stringBuilder.append(responseHeaderValues.get(index));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public synchronized InputStream getResponseStream(AtomicBoolean breakConditions) {
        if (this.readServerResponse(breakConditions)) {
            BufferedInputStream netStream = !TextUtils.isEmpty((CharSequence)this.serverRsp) ? null : this.connectionImpl.getResponseStream();
            return new SonicSessionStream(this, this.outputStream, netStream);
        }
        return null;
    }

    private void addResponseHeaderFields(String key, String ... args) {
        ArrayList field = new ArrayList(args.length);
        Collections.addAll(field, args);
        this.getResponseHeaderFields().put(key.toLowerCase(), field);
    }

    public synchronized String getResponseData(boolean readUntilEnd) {
        if (readUntilEnd && TextUtils.isEmpty((CharSequence)this.serverRsp)) {
            this.readServerResponse(null);
        }
        return this.serverRsp;
    }

    public synchronized String getTemplate() {
        if (TextUtils.isEmpty((CharSequence)this.templateString) && !TextUtils.isEmpty((CharSequence)this.serverRsp)) {
            this.separateTemplateAndData();
        }
        return this.templateString;
    }

    public synchronized String getUpdatedData() {
        if (TextUtils.isEmpty((CharSequence)this.dataString) && !TextUtils.isEmpty((CharSequence)this.serverRsp)) {
            this.separateTemplateAndData();
        }
        return this.dataString;
    }

    private boolean readServerResponse(AtomicBoolean breakCondition) {
        if (TextUtils.isEmpty((CharSequence)this.serverRsp)) {
            BufferedInputStream bufferedInputStream = this.connectionImpl.getResponseStream();
            if (null == bufferedInputStream) {
                SonicUtils.log(TAG, 6, "session(" + this.session.sId + ") readServerResponse error: bufferedInputStream is null!");
                return false;
            }
            try {
                byte[] buffer = new byte[this.session.config.READ_BUF_SIZE];
                int n = 0;
                while (!(breakCondition != null && breakCondition.get() || -1 == (n = bufferedInputStream.read(buffer)))) {
                    this.outputStream.write(buffer, 0, n);
                }
                if (n == -1) {
                    this.serverRsp = this.outputStream.toString(this.session.getCharsetFromHeaders());
                }
            }
            catch (Exception e) {
                SonicUtils.log(TAG, 6, "session(" + this.session.sId + ") readServerResponse error:" + e.getMessage() + ".");
                return false;
            }
        }
        return true;
    }

    protected void separateTemplateAndData() {
        if (!TextUtils.isEmpty((CharSequence)this.serverRsp)) {
            StringBuilder templateStringBuilder = new StringBuilder();
            StringBuilder dataStringBuilder = new StringBuilder();
            String data = null;
            if (SonicUtils.separateTemplateAndData(this.session.id, this.serverRsp, templateStringBuilder, dataStringBuilder)) {
                this.templateString = templateStringBuilder.toString();
                data = dataStringBuilder.toString();
            }
            String eTag = this.getResponseHeaderField("eTag");
            String templateTag = this.getResponseHeaderField("template-tag");
            String newHtmlSha1 = null;
            if (TextUtils.isEmpty((CharSequence)eTag)) {
                newHtmlSha1 = eTag = SonicUtils.getSHA1(this.serverRsp);
                this.addResponseHeaderFields("eTag", eTag);
                this.addResponseHeaderFields("sonic-html-sha1", newHtmlSha1);
            }
            if (TextUtils.isEmpty((CharSequence)this.templateString)) {
                this.templateString = this.serverRsp;
                this.addResponseHeaderFields("template-tag", eTag);
            } else if (TextUtils.isEmpty((CharSequence)templateTag)) {
                this.addResponseHeaderFields("template-tag", SonicUtils.getSHA1(this.templateString));
            }
            if (!TextUtils.isEmpty((CharSequence)data)) {
                try {
                    JSONObject object = new JSONObject();
                    object.put("data", (Object)new JSONObject(data));
                    if (TextUtils.isEmpty((CharSequence)newHtmlSha1)) {
                        newHtmlSha1 = SonicUtils.getSHA1(this.serverRsp);
                        this.addResponseHeaderFields("sonic-html-sha1", newHtmlSha1);
                    }
                    object.put("html-sha1", (Object)this.getResponseHeaderField("sonic-html-sha1"));
                    object.put("template-tag", (Object)this.getResponseHeaderField("template-tag"));
                    this.dataString = object.toString();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "session(" + this.session.sId + ") parse server response data error:" + e.getMessage() + ".");
                }
            }
        }
    }

    @Override
    public void onClose(boolean readComplete, ByteArrayOutputStream outputStream) {
        if (TextUtils.isEmpty((CharSequence)this.serverRsp) && readComplete && outputStream != null) {
            try {
                this.serverRsp = outputStream.toString(this.session.getCharsetFromHeaders());
                outputStream.close();
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "session(" + this.session.sId + "), onClose error:" + e.getMessage() + ".");
            }
        }
        this.session.onServerClosed(this, readComplete);
    }
}

