/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import com.tencent.sonic.sdk.SonicDBHelper;
import java.util.ArrayList;
import java.util.List;

public class SonicResourceDataHelper {
    private static final String TAG = "SonicSdk_SonicResourceDataHelper";
    private static final String Sonic_RESOURCE_TABLE_NAME = "ResourceData";
    private static final String RESOURCE_DATA_COLUMN_RESOURCE_ID = "resourceID";
    private static final String RESOURCE_DATA_COLUMN_RESOURCE_SHA1 = "resourceSha1";
    private static final String RESOURCE_DATA_COLUMN_RESOURCE_SIZE = "resourceSize";
    private static final String RESOURCE_DATA_COLUMN_LAST_UPDATE_TIME = "resourceUpdateTime";
    private static final String RESOURCE_DATA_COLUMN_CACHE_EXPIRED_TIME = "cacheExpiredTime";
    public static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS ResourceData ( id  integer PRIMARY KEY autoincrement , resourceID text not null , resourceSha1 text not null , resourceSize integer default 0 , resourceUpdateTime integer default 0 , cacheExpiredTime integer default 0 ); ";

    @NonNull
    public static ResourceData getResourceData(String resourceId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        ResourceData resourceData = SonicResourceDataHelper.getResourceData(db, resourceId);
        if (null == resourceData) {
            resourceData = new ResourceData();
        }
        return resourceData;
    }

    private static ResourceData getResourceData(SQLiteDatabase db, String resourceId) {
        Cursor cursor = db.query(Sonic_RESOURCE_TABLE_NAME, SonicResourceDataHelper.getAllResourceDataColumn(), "resourceID=?", new String[]{resourceId}, null, null, null);
        ResourceData resourceData = null;
        if (cursor != null && cursor.moveToFirst()) {
            resourceData = SonicResourceDataHelper.queryResourceData(cursor);
        }
        if (cursor != null) {
            cursor.close();
        }
        return resourceData;
    }

    public static String[] getAllResourceDataColumn() {
        return new String[]{RESOURCE_DATA_COLUMN_RESOURCE_ID, RESOURCE_DATA_COLUMN_RESOURCE_SHA1, RESOURCE_DATA_COLUMN_RESOURCE_SIZE, RESOURCE_DATA_COLUMN_LAST_UPDATE_TIME, RESOURCE_DATA_COLUMN_CACHE_EXPIRED_TIME};
    }

    private static ResourceData queryResourceData(Cursor cursor) {
        ResourceData resourceData = new ResourceData();
        resourceData.resourceId = cursor.getString(cursor.getColumnIndex(RESOURCE_DATA_COLUMN_RESOURCE_ID));
        resourceData.resourceSha1 = cursor.getString(cursor.getColumnIndex(RESOURCE_DATA_COLUMN_RESOURCE_SHA1));
        resourceData.resourceSize = cursor.getLong(cursor.getColumnIndex(RESOURCE_DATA_COLUMN_RESOURCE_SIZE));
        resourceData.lastUpdateTime = cursor.getLong(cursor.getColumnIndex(RESOURCE_DATA_COLUMN_LAST_UPDATE_TIME));
        resourceData.expiredTime = cursor.getLong(cursor.getColumnIndex(RESOURCE_DATA_COLUMN_CACHE_EXPIRED_TIME));
        return resourceData;
    }

    static void saveResourceData(String resourceId, ResourceData resourceData) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SonicResourceDataHelper.saveResourceData(db, resourceId, resourceData);
    }

    private static void saveResourceData(SQLiteDatabase db, String resourceId, ResourceData resourceData) {
        resourceData.resourceId = resourceId;
        ResourceData storedResourceData = SonicResourceDataHelper.getResourceData(db, resourceId);
        if (storedResourceData != null) {
            SonicResourceDataHelper.updateResourceData(db, resourceId, resourceData);
        } else {
            SonicResourceDataHelper.insertResourceData(db, resourceId, resourceData);
        }
    }

    private static void insertResourceData(SQLiteDatabase db, String resourceId, ResourceData resourceData) {
        ContentValues contentValues = SonicResourceDataHelper.getContentValues(resourceId, resourceData);
        db.insert(Sonic_RESOURCE_TABLE_NAME, null, contentValues);
    }

    private static void updateResourceData(SQLiteDatabase db, String resourceId, ResourceData resourceData) {
        ContentValues contentValues = SonicResourceDataHelper.getContentValues(resourceId, resourceData);
        db.update(Sonic_RESOURCE_TABLE_NAME, contentValues, "resourceID=?", new String[]{resourceId});
    }

    static List<ResourceData> getAllResourceData() {
        ArrayList<ResourceData> resourceDataList = new ArrayList<ResourceData>();
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        Cursor cursor = db.query(Sonic_RESOURCE_TABLE_NAME, SonicResourceDataHelper.getAllResourceDataColumn(), null, null, null, null, "");
        while (cursor != null && cursor.moveToNext()) {
            resourceDataList.add(SonicResourceDataHelper.queryResourceData(cursor));
        }
        return resourceDataList;
    }

    @NonNull
    private static ContentValues getContentValues(String resourceId, ResourceData resourceData) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(RESOURCE_DATA_COLUMN_RESOURCE_ID, resourceId);
        contentValues.put(RESOURCE_DATA_COLUMN_RESOURCE_SHA1, resourceData.resourceSha1);
        contentValues.put(RESOURCE_DATA_COLUMN_RESOURCE_SIZE, Long.valueOf(resourceData.resourceSize));
        contentValues.put(RESOURCE_DATA_COLUMN_LAST_UPDATE_TIME, Long.valueOf(resourceData.lastUpdateTime));
        contentValues.put(RESOURCE_DATA_COLUMN_CACHE_EXPIRED_TIME, Long.valueOf(resourceData.expiredTime));
        return contentValues;
    }

    static void removeResourceData(String resourceId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete(Sonic_RESOURCE_TABLE_NAME, "resourceID=?", new String[]{resourceId});
    }

    static synchronized void clear() {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete(Sonic_RESOURCE_TABLE_NAME, null, null);
    }

    public static class ResourceData {
        String resourceId;
        public String resourceSha1;
        public long resourceSize;
        long lastUpdateTime;
        public long expiredTime;

        public void reset() {
            this.resourceSha1 = "";
            this.resourceSize = 0L;
            this.lastUpdateTime = 0L;
            this.expiredTime = 0L;
        }
    }
}

