/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicResourceDataHelper;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SonicFileUtils {
    private static final String TAG = "SonicSdk_SonicFileUtils";
    private static final String TEMPLATE_EXT = ".tpl";
    private static final String DATA_EXT = ".data";
    private static final String HTML_EXT = ".html";
    private static final String HEADER_EXT = ".header";
    private static final double THRESHOLD_OF_CACHE_MAX_PERCENT = 0.8;
    private static final double THRESHOLD_OF_CACHE_MIN_PERCENT = 0.25;

    static String getSonicCacheDirPath() {
        String dirPath = SonicEngine.getInstance().getRuntime().getSonicCacheDir().getAbsolutePath();
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        return dirPath;
    }

    static String getSonicResourceCachePath() {
        String dirPath = SonicEngine.getInstance().getRuntime().getSonicResourceCacheDir().getAbsolutePath();
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        return dirPath;
    }

    static String getSonicTemplatePath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + TEMPLATE_EXT;
    }

    static String getSonicDataPath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + DATA_EXT;
    }

    static String getSonicHeaderPath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + HEADER_EXT;
    }

    static String getSonicHtmlPath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + HTML_EXT;
    }

    public static String getSonicResourcePath(String resourceName) {
        return SonicFileUtils.getSonicResourceCachePath() + resourceName;
    }

    public static String getSonicResourceHeaderPath(String resourceName) {
        return SonicFileUtils.getSonicResourceCachePath() + resourceName + HEADER_EXT;
    }

    static boolean deleteSonicFiles(String sessionId) {
        File headerFile;
        File dataFile;
        File templateFile;
        boolean deleteSuccess = true;
        File htmlFile = new File(SonicFileUtils.getSonicHtmlPath(sessionId));
        if (htmlFile.exists()) {
            deleteSuccess = htmlFile.delete();
        }
        if ((templateFile = new File(SonicFileUtils.getSonicTemplatePath(sessionId))).exists()) {
            deleteSuccess &= templateFile.delete();
        }
        if ((dataFile = new File(SonicFileUtils.getSonicDataPath(sessionId))).exists()) {
            deleteSuccess &= dataFile.delete();
        }
        if ((headerFile = new File(SonicFileUtils.getSonicHeaderPath(sessionId))).exists()) {
            deleteSuccess &= headerFile.delete();
        }
        return deleteSuccess;
    }

    static boolean deleteResourceFiles(String resourceId) {
        File headerFile;
        boolean deleteSuccess = true;
        File resourceFile = new File(SonicFileUtils.getSonicResourcePath(resourceId));
        if (resourceFile.exists()) {
            deleteSuccess = resourceFile.delete();
        }
        if ((headerFile = new File(SonicFileUtils.getSonicHeaderPath(resourceId))).exists()) {
            deleteSuccess &= headerFile.delete();
        }
        return deleteSuccess;
    }

    static boolean verifyData(String content, String targetSha1) {
        return !TextUtils.isEmpty((CharSequence)content) && !TextUtils.isEmpty((CharSequence)targetSha1) && targetSha1.equals(SonicUtils.getSHA1(content));
    }

    public static boolean verifyData(byte[] content, String targetSha1) {
        return content != null && !TextUtils.isEmpty((CharSequence)targetSha1) && targetSha1.equals(SonicUtils.getSHA1(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        BufferedInputStream bis = null;
        InputStreamReader reader = null;
        String rtn = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            reader = new InputStreamReader(bis);
            int size = (int)file.length();
            if (size > 12288) {
                int n;
                char[] buffer = new char[4096];
                StringBuilder result = new StringBuilder(12288);
                while (-1 != (n = reader.read(buffer))) {
                    result.append(buffer, 0, n);
                }
                rtn = result.toString();
            } else {
                char[] buffer = new char[size];
                int n = reader.read(buffer);
                rtn = new String(buffer, 0, n);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "readFile error:(" + file.getName() + ") " + e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "readFile close error:(" + file.getName() + ") " + e.getMessage());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "readFile close error:(" + file.getName() + ") " + e.getMessage());
                }
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToBytes(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        BufferedInputStream bis = null;
        ByteArrayOutputStream out = null;
        byte[] rtn = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            int size = (int)file.length();
            if (size > 12288) {
                int n;
                out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((n = bis.read(buffer)) != -1) {
                    out.write(buffer, 0, n);
                }
                rtn = out.toByteArray();
            } else {
                rtn = new byte[size];
                int n = bis.read(rtn);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "readFile error:(" + file.getName() + ") " + e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "readFile close error:(" + file.getName() + ") " + e.getMessage());
                }
            }
        }
        return rtn;
    }

    static boolean writeFile(String str, String filePath) {
        return SonicFileUtils.writeFile(str.getBytes(), filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeFile(byte[] content, String filePath) {
        File file = new File(filePath);
        FileOutputStream fos = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            fos = new FileOutputStream(file);
            fos.write(content);
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "writeFile error:(" + filePath + ") " + e.getMessage());
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "writeFile close error:(" + filePath + ") " + e.getMessage());
                }
            }
        }
        return false;
    }

    static boolean deleteAllChildFiles(File file) {
        boolean deleteSuccess = true;
        if (null != file && file.exists()) {
            File[] childFiles;
            if (file.isFile()) {
                deleteSuccess = file.delete();
            } else if (file.isDirectory() && null != (childFiles = file.listFiles())) {
                for (File childFile : childFiles) {
                    deleteSuccess &= SonicFileUtils.deleteAllChildFiles(childFile);
                }
            }
        }
        return deleteSuccess;
    }

    static void checkAndTrimCache() {
        long MAX_CACHE_SIZE;
        HashMap<String, List<String>> currentCacheFileMap = new HashMap<String, List<String>>();
        long startTime = System.currentTimeMillis();
        long cacheFileSize = SonicFileUtils.calcCacheSize(SonicFileUtils.getSonicCacheDirPath(), currentCacheFileMap);
        if ((double)cacheFileSize > (double)(MAX_CACHE_SIZE = SonicEngine.getInstance().getConfig().SONIC_CACHE_MAX_SIZE) * 0.8) {
            SonicUtils.log(TAG, 4, "now try clear cache, current cache size: " + cacheFileSize / 1024L / 1024L + "m");
            List<SonicDataHelper.SessionData> allSessions = SonicDataHelper.getAllSessionByHitCount();
            for (int i = 0; i < allSessions.size(); ++i) {
                SonicDataHelper.SessionData sessionData = allSessions.get(i);
                List<String> files = currentCacheFileMap.get(sessionData.sessionId);
                if (files != null && files.size() > 0) {
                    for (String filePath : files) {
                        File file = new File(filePath);
                        if (!file.isFile() || !file.exists()) continue;
                        String fileName = file.getName();
                        long fileSize = file.length();
                        if (!file.delete()) continue;
                        cacheFileSize -= fileSize;
                        SonicDataHelper.removeSessionData(fileName);
                        SonicUtils.log(TAG, 4, "delete " + file.getAbsolutePath());
                    }
                }
                if ((double)cacheFileSize <= (double)MAX_CACHE_SIZE * 0.25) break;
            }
            SonicUtils.log(TAG, 4, "checkAndTrimCache: finish , cost " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    static void checkAndTrimResourceCache() {
        long MAX_CACHE_SIZE;
        HashMap<String, List<String>> currentCacheFileMap = new HashMap<String, List<String>>();
        long startTime = System.currentTimeMillis();
        long cacheFileSize = SonicFileUtils.calcCacheSize(SonicFileUtils.getSonicCacheDirPath(), currentCacheFileMap);
        if ((double)cacheFileSize > (double)(MAX_CACHE_SIZE = SonicEngine.getInstance().getConfig().SONIC_RESOURCE_CACHE_MAX_SIZE) * 0.8) {
            SonicUtils.log(TAG, 4, "now try clear cache, current cache size: " + cacheFileSize / 1024L / 1024L + "m");
            List<SonicResourceDataHelper.ResourceData> allSessions = SonicResourceDataHelper.getAllResourceData();
            for (int i = 0; i < allSessions.size(); ++i) {
                SonicResourceDataHelper.ResourceData sessionData = allSessions.get(i);
                List<String> files = currentCacheFileMap.get(sessionData.resourceId);
                if (files != null && files.size() > 0) {
                    for (String filePath : files) {
                        File file = new File(filePath);
                        if (!file.isFile() || !file.exists()) continue;
                        String fileName = file.getName();
                        long fileSize = file.length();
                        if (!file.delete()) continue;
                        cacheFileSize -= fileSize;
                        SonicResourceDataHelper.removeResourceData(fileName);
                        SonicUtils.log(TAG, 4, "delete " + file.getAbsolutePath());
                    }
                }
                if ((double)cacheFileSize <= (double)MAX_CACHE_SIZE * 0.25) break;
            }
            SonicUtils.log(TAG, 4, "checkAndTrimCache: finish , cost " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    private static long calcCacheSize(String cacheDirPath, Map<String, List<String>> currentCacheFileMap) {
        File[] childFiles;
        File cacheRootDir = new File(cacheDirPath);
        if (cacheRootDir.exists() && cacheRootDir.isDirectory() && (childFiles = cacheRootDir.listFiles()) != null && childFiles.length > 0) {
            long cacheFileSize = 0L;
            File[] fileArray = childFiles;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File childFile;
                File file = childFile = fileArray[i];
                cacheFileSize += file.length();
                String fileName = file.getName();
                List<String> files = currentCacheFileMap.get(fileName);
                if (files == null) {
                    files = new ArrayList<String>();
                }
                files.add(file.getAbsolutePath());
                currentCacheFileMap.put(fileName, files);
            }
            return cacheFileSize;
        }
        return 0L;
    }

    static String convertHeadersToString(Map<String, List<String>> headers) {
        if (headers != null && headers.size() > 0) {
            StringBuilder headerString = new StringBuilder();
            Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entries) {
                String key = entry.getKey();
                if (TextUtils.isEmpty((CharSequence)key)) continue;
                List<String> values = entry.getValue();
                for (String value : values) {
                    if (TextUtils.isEmpty((CharSequence)value)) continue;
                    headerString.append(key).append(" : ");
                    headerString.append(value).append("\r\n");
                }
            }
            return headerString.toString();
        }
        return "";
    }

    public static Map<String, List<String>> getHeaderFromLocalCache(String headerPath) {
        String[] headerArray;
        String headerString;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        File headerFile = new File(headerPath);
        if (headerFile.exists() && !TextUtils.isEmpty((CharSequence)(headerString = SonicFileUtils.readFile(headerFile))) && (headerArray = headerString.split("\r\n")).length > 0) {
            for (String header : headerArray) {
                String[] keyValues = header.split(" : ");
                if (keyValues.length != 2) continue;
                String key = keyValues[0].trim();
                ArrayList<String> tmpHeaderList = (ArrayList<String>)headers.get(key.toLowerCase());
                if (null == tmpHeaderList) {
                    tmpHeaderList = new ArrayList<String>(1);
                    headers.put(key.toLowerCase(), tmpHeaderList);
                }
                tmpHeaderList.add(keyValues[1].trim());
            }
        }
        return headers;
    }
}

