/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

public class SonicConfig {
    int MAX_PRELOAD_SESSION_COUNT = 5;
    long SONIC_UNAVAILABLE_TIME = 21600000L;
    long SONIC_CACHE_MAX_SIZE = 0x1E00000L;
    long SONIC_RESOURCE_CACHE_MAX_SIZE = 0x3C00000L;
    long SONIC_CACHE_CHECK_TIME_INTERVAL = 86400000L;
    public int SONIC_MAX_NUM_OF_DOWNLOADING_TASK = 3;
    int SONIC_CACHE_MAX_AGE = 300000;
    public boolean VERIFY_CACHE_FILE_WITH_SHA1 = true;
    boolean AUTO_INIT_DB_WHEN_CREATE = true;
    boolean GET_COOKIE_WHEN_SESSION_CREATE = true;

    private SonicConfig() {
    }

    public static class Builder {
        private final SonicConfig target = new SonicConfig();

        public Builder setMaxPreloadSessionCount(int maxPreloadSessionCount) {
            this.target.MAX_PRELOAD_SESSION_COUNT = maxPreloadSessionCount;
            return this;
        }

        public Builder setUnavailableTime(long unavailableTime) {
            this.target.SONIC_UNAVAILABLE_TIME = unavailableTime;
            return this;
        }

        public Builder setCacheVerifyWithSha1(boolean enable) {
            this.target.VERIFY_CACHE_FILE_WITH_SHA1 = enable;
            return this;
        }

        public Builder setCacheMaxSize(long maxSize) {
            this.target.SONIC_CACHE_MAX_SIZE = maxSize;
            return this;
        }

        public Builder setResourceCacheMaxSize(long maxSize) {
            this.target.SONIC_RESOURCE_CACHE_MAX_SIZE = maxSize;
            return this;
        }

        public Builder setCacheCheckTimeInterval(long time) {
            this.target.SONIC_CACHE_CHECK_TIME_INTERVAL = time;
            return this;
        }

        public Builder setMaxNumOfDownloadingTasks(int num) {
            this.target.SONIC_MAX_NUM_OF_DOWNLOADING_TASK = num;
            return this;
        }

        public Builder setAutoInitDBWhenCreate(boolean autoInitDBWhenCreate) {
            this.target.AUTO_INIT_DB_WHEN_CREATE = autoInitDBWhenCreate;
            return this;
        }

        public Builder setGetCookieWhenSessionCreate(boolean value) {
            this.target.GET_COOKIE_WHEN_SESSION_CREATE = value;
            return this;
        }

        public Builder setSonicCacheMaxAge(int maxAge) {
            this.target.SONIC_CACHE_MAX_AGE = maxAge;
            return this;
        }

        public SonicConfig build() {
            return this.target;
        }
    }
}

