/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicCacheInterceptor;
import com.tencent.sonic.sdk.SonicConfig;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicServer;
import com.tencent.sonic.sdk.SonicSessionClient;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicSessionStatistics;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public abstract class SonicSession
implements Handler.Callback {
    public static final String TAG = "SonicSdk_SonicSession";
    public static final String WEB_RESPONSE_SRC_CODE = "srcCode";
    public static final String WEB_RESPONSE_CODE = "code";
    public static final String WEB_RESPONSE_DATA = "result";
    public static final String DATA_UPDATE_BUNDLE_PARAMS_DIFF = "_diff_data_";
    public static final String WEB_RESPONSE_LOCAL_REFRESH_TIME = "local_refresh_time";
    public static final String CHROME_FILE_THREAD = "Chrome_FileThread";
    public static final int STATE_NONE = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROY = 3;
    public static final String OFFLINE_MODE_HTTP = "http";
    public static final String OFFLINE_MODE_STORE = "store";
    public static final String OFFLINE_MODE_TRUE = "true";
    public static final String OFFLINE_MODE_FALSE = "false";
    public static final int SONIC_RESULT_CODE_UNKNOWN = -1;
    public static final int SONIC_RESULT_CODE_FIRST_LOAD = 1000;
    public static final int SONIC_RESULT_CODE_TEMPLATE_CHANGE = 2000;
    public static final int SONIC_RESULT_CODE_DATA_UPDATE = 200;
    public static final int SONIC_RESULT_CODE_HIT_CACHE = 304;
    protected int srcResultCode = -1;
    protected int finalResultCode = -1;
    protected static final int COMMON_MSG_BEGIN = 0;
    protected static final int CLIENT_MSG_NOTIFY_RESULT = 1;
    protected static final int CLIENT_MSG_ON_WEB_READY = 2;
    protected static final int SESSION_MSG_FORCE_DESTROY = 3;
    protected static final int COMMON_MSG_END = 4;
    protected static final int RESOURCE_INTERCEPT_STATE_NONE = 0;
    protected static final int RESOURCE_INTERCEPT_STATE_IN_FILE_THREAD = 1;
    protected static final int RESOURCE_INTERCEPT_STATE_IN_OTHER_THREAD = 2;
    protected final AtomicInteger sessionState = new AtomicInteger(0);
    protected final AtomicBoolean wasInterceptInvoked = new AtomicBoolean(false);
    protected final AtomicBoolean clientIsReady = new AtomicBoolean(false);
    private final AtomicBoolean wasNotified = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForSaveFile = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForDestroy = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForSessionThread = new AtomicBoolean(false);
    protected final AtomicBoolean wasOnPageFinishInvoked = new AtomicBoolean(false);
    protected final AtomicInteger resourceInterceptState = new AtomicInteger(0);
    protected final SonicSessionStatistics statistics = new SonicSessionStatistics();
    protected volatile SonicServer server;
    protected volatile InputStream pendingWebResourceStream;
    protected String pendingDiffData = "";
    protected static long sNextSessionLogId = new Random().nextInt(263167);
    public final SonicSessionConfig config;
    public final String id;
    protected boolean isPreload;
    public long createdTime;
    public final long sId;
    public String srcUrl;
    protected volatile SonicSessionClient sessionClient;
    protected final Handler mainHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    protected final CopyOnWriteArrayList<WeakReference<Callback>> callbackWeakRefList = new CopyOnWriteArrayList();
    protected SonicDiffDataCallback diffDataCallback;
    protected final Intent intent = new Intent();

    public boolean handleMessage(Message msg) {
        if (3 == msg.what) {
            this.destroy(true);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleMessage:force destroy.");
            return true;
        }
        if (this.isDestroyedOrWaitingForDestroy()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleMessage error: is destroyed or waiting for destroy.");
            return true;
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleMessage: msg what = " + msg.what + ".");
        }
        return false;
    }

    SonicSession(String id, String url, SonicSessionConfig config) {
        SonicRuntime runtime;
        String cookie;
        this.id = id;
        this.config = config;
        this.sId = sNextSessionLogId++;
        this.srcUrl = this.statistics.srcUrl = url.trim();
        this.createdTime = System.currentTimeMillis();
        SonicConfig sonicConfig = SonicEngine.getInstance().getConfig();
        if (sonicConfig.GET_COOKIE_WHEN_SESSION_CREATE && !TextUtils.isEmpty((CharSequence)(cookie = (runtime = SonicEngine.getInstance().getRuntime()).getCookie(this.srcUrl)))) {
            this.intent.putExtra("Cookie", cookie);
        }
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") create:id=" + id + ", url = " + url + ".");
        }
    }

    public void start() {
        if (!this.sessionState.compareAndSet(0, 1)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") start error:sessionState=" + this.sessionState.get() + ".");
            return;
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") now post sonic flow task.");
        this.statistics.sonicStartTime = System.currentTimeMillis();
        this.isWaitingForSessionThread.set(true);
        SonicEngine.getInstance().getRuntime().postTaskToSessionThread(new Runnable(){

            @Override
            public void run() {
                SonicSession.this.runSonicFlow();
            }
        });
        this.notifyStateChange(0, 1, null);
    }

    private void runSonicFlow() {
        if (1 != this.sessionState.get()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") runSonicFlow error:sessionState=" + this.sessionState.get() + ".");
            return;
        }
        this.statistics.sonicFlowStartTime = System.currentTimeMillis();
        String cacheHtml = SonicCacheInterceptor.getSonicCacheData(this);
        boolean hasHtmlCache = !TextUtils.isEmpty((CharSequence)cacheHtml);
        this.statistics.cacheVerifyTime = System.currentTimeMillis();
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") runSonicFlow verify cache cost " + (this.statistics.cacheVerifyTime - this.statistics.sonicFlowStartTime) + " ms");
        this.handleFlow_LoadLocalCache(cacheHtml);
        final SonicRuntime runtime = SonicEngine.getInstance().getRuntime();
        if (!runtime.isNetworkValid()) {
            if (hasHtmlCache && !TextUtils.isEmpty((CharSequence)this.config.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST)) {
                runtime.postTaskToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SonicSession.this.clientIsReady.get() && !SonicSession.this.isDestroyedOrWaitingForDestroy()) {
                            runtime.showToast(SonicSession.this.config.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST, 1);
                        }
                    }
                }, 1500L);
            }
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") runSonicFlow error:network is not valid!");
        } else {
            this.handleFlow_Connection(cacheHtml);
            this.statistics.connectionFlowFinishTime = System.currentTimeMillis();
        }
        this.switchState(1, 2, true);
        this.isWaitingForSessionThread.set(false);
        if (this.postForceDestroyIfNeed()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") runSonicFlow:send force destroy message.");
        }
    }

    protected Intent createConnectionIntent(SonicDataHelper.SessionData sessionData) {
        Intent connectionIntent = new Intent();
        connectionIntent.putExtra("eTag", sessionData.eTag);
        connectionIntent.putExtra("template-tag", sessionData.templateTag);
        String hostDirectAddress = SonicEngine.getInstance().getRuntime().getHostDirectAddress(this.srcUrl);
        if (!TextUtils.isEmpty((CharSequence)hostDirectAddress)) {
            connectionIntent.putExtra("dns-prefetch-address", hostDirectAddress);
            this.statistics.isDirectAddress = true;
        }
        SonicRuntime runtime = SonicEngine.getInstance().getRuntime();
        SonicConfig sonicConfig = SonicEngine.getInstance().getConfig();
        if (!sonicConfig.GET_COOKIE_WHEN_SESSION_CREATE) {
            String cookie = runtime.getCookie(this.srcUrl);
            if (!TextUtils.isEmpty((CharSequence)cookie)) {
                connectionIntent.putExtra("Cookie", cookie);
            }
        } else {
            connectionIntent.putExtra("Cookie", this.intent.getStringExtra("Cookie"));
        }
        String userAgent = runtime.getUserAgent();
        userAgent = !TextUtils.isEmpty((CharSequence)userAgent) ? userAgent + " Sonic/2.0.0" : "Sonic/2.0.0";
        connectionIntent.putExtra("User-Agent", userAgent);
        return connectionIntent;
    }

    protected void handleFlow_Connection(String cacheHtml) {
        this.statistics.connectionFlowStartTime = System.currentTimeMillis();
        SonicDataHelper.SessionData sessionData = TextUtils.isEmpty((CharSequence)cacheHtml) ? new SonicDataHelper.SessionData() : SonicDataHelper.getSessionData(this.id);
        if (this.config.SUPPORT_CACHE_CONTROL && this.statistics.connectionFlowStartTime < sessionData.expiredTime) {
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") won't send any request in " + (sessionData.expiredTime - this.statistics.connectionFlowStartTime) + ".ms");
            }
            return;
        }
        this.server = new SonicServer(this, this.createConnectionIntent(sessionData));
        int responseCode = this.server.connect();
        if (0 == responseCode) {
            responseCode = this.server.getResponseCode();
            long startTime = System.currentTimeMillis();
            Map<String, List<String>> headerFieldsMap = this.server.getResponseHeaderFields();
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") connection get header fields cost = " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            startTime = System.currentTimeMillis();
            this.setCookiesFromHeaders(headerFieldsMap, this.shouldSetCookieAsynchronous());
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") connection set cookies cost = " + (System.currentTimeMillis() - startTime) + " ms.");
            }
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection: respCode = " + responseCode + ", cost " + (System.currentTimeMillis() - this.statistics.connectionFlowStartTime) + " ms.");
        if (this.isDestroyedOrWaitingForDestroy()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection error: destroy before server response!");
            return;
        }
        if (304 == responseCode) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection: Server response is not modified.");
            this.handleFlow_NotModified();
            return;
        }
        if (200 != responseCode) {
            this.handleFlow_HttpError(responseCode);
            SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, responseCode);
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection error: response code(" + responseCode + ") is not OK!");
            return;
        }
        String cacheOffline = this.server.getResponseHeaderField("cache-offline");
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection: cacheOffline is " + cacheOffline + ".");
        if (OFFLINE_MODE_HTTP.equalsIgnoreCase(cacheOffline)) {
            if (!TextUtils.isEmpty((CharSequence)cacheHtml)) {
                this.handleFlow_ServiceUnavailable();
            }
            long unavailableTime = System.currentTimeMillis() + SonicEngine.getInstance().getConfig().SONIC_UNAVAILABLE_TIME;
            SonicDataHelper.setSonicUnavailableTime(this.id, unavailableTime);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)cacheHtml)) {
            this.handleFlow_FirstLoad();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)cacheOffline) || OFFLINE_MODE_FALSE.equalsIgnoreCase(cacheOffline)) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection error: Cache-Offline is empty or false!");
            SonicUtils.removeSessionCache(this.id);
            return;
        }
        String eTag = this.server.getResponseHeaderField("eTag");
        String templateChange = this.server.getResponseHeaderField("template-change");
        if (TextUtils.isEmpty((CharSequence)eTag) || TextUtils.isEmpty((CharSequence)templateChange)) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection error: eTag is ( " + eTag + " ) , templateChange is ( " + templateChange + " )!");
            SonicUtils.removeSessionCache(this.id);
            return;
        }
        if (OFFLINE_MODE_FALSE.equals(templateChange) || "0".equals(templateChange)) {
            this.handleFlow_DataUpdate(this.server.getUpdatedData());
        } else {
            this.handleFlow_TemplateChange(this.server.getResponseData(false));
        }
    }

    protected abstract void handleFlow_LoadLocalCache(String var1);

    protected abstract void handleFlow_FirstLoad();

    protected abstract void handleFlow_NotModified();

    protected abstract void handleFlow_DataUpdate(String var1);

    protected abstract void handleFlow_TemplateChange(String var1);

    protected abstract void handleFlow_HttpError(int var1);

    protected abstract void handleFlow_ServiceUnavailable();

    void setIsPreload(String url) {
        this.isPreload = true;
        this.srcUrl = this.statistics.srcUrl = url.trim();
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") is preload, new url=" + url + ".");
        }
    }

    public boolean isPreload() {
        return this.isPreload;
    }

    public SonicSessionStatistics getStatistics() {
        return this.statistics;
    }

    public boolean addCallback(Callback callback) {
        return this.callbackWeakRefList.add(new WeakReference<Callback>(callback));
    }

    public boolean removeCallback(Callback callback) {
        return this.callbackWeakRefList.remove(new WeakReference<Callback>(callback));
    }

    public String getCurrentUrl() {
        return this.srcUrl;
    }

    public int getFinalResultCode() {
        return this.finalResultCode;
    }

    public int getSrcResultCode() {
        return this.srcResultCode;
    }

    protected boolean isDestroyedOrWaitingForDestroy() {
        return 3 == this.sessionState.get() || this.isWaitingForDestroy.get();
    }

    protected boolean postForceDestroyIfNeed() {
        if (this.isWaitingForDestroy.get() && this.canDestroy()) {
            this.mainHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    protected boolean canDestroy() {
        if (this.isWaitingForSessionThread.get() || this.isWaitingForSaveFile.get()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") canDestroy:false, isWaitingForSessionThread=" + this.isWaitingForDestroy.get() + ", isWaitingForSaveFile=" + this.isWaitingForSaveFile.get());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean switchState(int fromState, int toState, boolean notify) {
        if (this.sessionState.compareAndSet(fromState, toState)) {
            if (notify) {
                AtomicInteger atomicInteger = this.sessionState;
                synchronized (atomicInteger) {
                    this.sessionState.notify();
                }
            }
            this.notifyStateChange(fromState, toState, null);
            return true;
        }
        return false;
    }

    public void onServerClosed(final SonicServer sonicServer, boolean readComplete) {
        if (this.isDestroyedOrWaitingForDestroy()) {
            return;
        }
        if (null != this.pendingWebResourceStream) {
            this.pendingWebResourceStream = null;
        }
        this.isWaitingForSaveFile.set(true);
        long onCloseStartTime = System.currentTimeMillis();
        if (readComplete) {
            String cacheOffline = sonicServer.getResponseHeaderField("cache-offline");
            if (SonicUtils.needSaveData(this.config.SUPPORT_CACHE_CONTROL, cacheOffline, sonicServer.getResponseHeaderFields())) {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose:offline->" + cacheOffline + " , post separateAndSaveCache task.");
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SonicSession.this.isDestroyedOrWaitingForDestroy()) {
                            return;
                        }
                        String htmlString = sonicServer.getResponseData(false);
                        if (SonicUtils.shouldLog(3)) {
                            SonicUtils.log(SonicSession.TAG, 3, "session(" + SonicSession.this.sId + ") onClose:htmlString size:" + (!TextUtils.isEmpty((CharSequence)htmlString) ? htmlString.length() : 0));
                        }
                        if (!TextUtils.isEmpty((CharSequence)htmlString)) {
                            long startTime = System.currentTimeMillis();
                            SonicSession.this.saveSonicCache(htmlString);
                            SonicUtils.log(SonicSession.TAG, 4, "session(" + SonicSession.this.sId + ") onClose:separate And save ache finish, cost " + (System.currentTimeMillis() - startTime) + " ms.");
                        }
                        SonicSession.this.isWaitingForSaveFile.set(false);
                        if (SonicSession.this.postForceDestroyIfNeed()) {
                            SonicUtils.log(SonicSession.TAG, 4, "session(" + SonicSession.this.sId + ") onClose: postForceDestroyIfNeed send destroy message.");
                        }
                    }
                }, 3000L);
                return;
            }
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose:offline->" + cacheOffline + " , so do not need cache to file.");
        } else {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClose error:readComplete = false!");
        }
        this.isWaitingForSaveFile.set(false);
        if (this.postForceDestroyIfNeed()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose: postForceDestroyIfNeed send destroy message in chromium_io thread.");
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClose cost " + (System.currentTimeMillis() - onCloseStartTime) + " ms.");
        }
    }

    protected void saveSonicCache(String htmlString) {
        long startTime = System.currentTimeMillis();
        String template = this.server.getTemplate();
        String updatedData = this.server.getUpdatedData();
        if (!TextUtils.isEmpty((CharSequence)htmlString) && !TextUtils.isEmpty((CharSequence)template)) {
            String newHtmlSha1 = this.server.getResponseHeaderField("sonic-html-sha1");
            if (TextUtils.isEmpty((CharSequence)newHtmlSha1)) {
                newHtmlSha1 = SonicUtils.getSHA1(htmlString);
            }
            String eTag = this.server.getResponseHeaderField("eTag");
            String templateTag = this.server.getResponseHeaderField("template-tag");
            Map<String, List<String>> headers = this.server.getResponseHeaderFields();
            if (SonicUtils.saveSessionFiles(this.id, htmlString, template, updatedData, headers)) {
                long htmlSize = new File(SonicFileUtils.getSonicHtmlPath(this.id)).length();
                SonicUtils.saveSonicData(this.id, eTag, templateTag, newHtmlSha1, htmlSize, headers);
            } else {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") saveSonicCache: save session files fail.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1004);
            }
        } else {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") saveSonicCache: save separate template and data files fail.");
            SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1005);
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") saveSonicCache: finish, cost " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    protected void notifyStateChange(int oldState, int newState, Bundle extraData) {
        for (WeakReference<Callback> callbackWeakRef : this.callbackWeakRefList) {
            Callback callback = (Callback)callbackWeakRef.get();
            if (null == callback) continue;
            callback.onSessionStateChange(this, oldState, newState, extraData);
        }
    }

    protected void setResult(int srcCode, int finalCode, boolean notify) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: srcCode=" + srcCode + ", finalCode=" + finalCode + ".");
        this.statistics.originalMode = this.srcResultCode = srcCode;
        this.statistics.finalMode = this.finalResultCode = finalCode;
        if (!notify) {
            return;
        }
        if (this.wasNotified.get()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ")  setResult: notify error -> already has notified!");
        }
        if (null == this.diffDataCallback) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: notify fail as webCallback is not set, please wait!");
            return;
        }
        if (this.finalResultCode == -1) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: notify fail finalResultCode is not set, please wait!");
            return;
        }
        this.wasNotified.compareAndSet(false, true);
        JSONObject json = new JSONObject();
        try {
            if (this.finalResultCode == 200) {
                JSONObject pendingObject = new JSONObject(this.pendingDiffData);
                if (!pendingObject.has(WEB_RESPONSE_LOCAL_REFRESH_TIME)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") setResult: no any updated data. " + this.pendingDiffData);
                    this.pendingDiffData = "";
                    return;
                }
                long timeDelta = System.currentTimeMillis() - pendingObject.optLong(WEB_RESPONSE_LOCAL_REFRESH_TIME, 0L);
                if (timeDelta > 30000L) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") setResult: notify fail as receive js call too late, " + (double)timeDelta / 1000.0 + " s.");
                    this.pendingDiffData = "";
                    return;
                }
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") setResult: notify receive js call in time: " + (double)timeDelta / 1000.0 + " s.");
                }
                if (timeDelta > 0L) {
                    json.put(WEB_RESPONSE_LOCAL_REFRESH_TIME, timeDelta);
                }
                pendingObject.remove(WEB_RESPONSE_LOCAL_REFRESH_TIME);
                json.put(WEB_RESPONSE_DATA, (Object)pendingObject.toString());
            }
            json.put(WEB_RESPONSE_CODE, this.finalResultCode);
            json.put(WEB_RESPONSE_SRC_CODE, this.srcResultCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") setResult: notify error -> " + e.getMessage());
        }
        if (SonicUtils.shouldLog(3)) {
            String logStr = json.toString();
            if (logStr.length() > 512) {
                logStr = logStr.substring(0, 512);
            }
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") setResult: notify now call jsCallback, jsonStr = " + logStr);
        }
        this.pendingDiffData = null;
        this.diffDataCallback.callback(json.toString());
    }

    public boolean bindClient(SonicSessionClient client) {
        if (null == this.sessionClient) {
            this.sessionClient = client;
            client.bindSession(this);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") bind client.");
            return true;
        }
        return false;
    }

    public boolean onClientReady() {
        return false;
    }

    public final Object onClientRequestResource(String url) {
        String currentThreadName = Thread.currentThread().getName();
        if (CHROME_FILE_THREAD.equals(currentThreadName)) {
            this.resourceInterceptState.set(1);
        } else {
            this.resourceInterceptState.set(2);
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "onClientRequestResource called in " + currentThreadName + ".");
            }
        }
        Object object = this.onRequestResource(url);
        this.resourceInterceptState.set(0);
        return object;
    }

    protected boolean shouldSetCookieAsynchronous() {
        return 2 == this.resourceInterceptState.get();
    }

    protected boolean setCookiesFromHeaders(Map<String, List<String>> headers, boolean executeInNewThread) {
        List<String> cookies;
        if (null != headers && null != (cookies = headers.get("Set-Cookie".toLowerCase())) && 0 != cookies.size()) {
            if (!executeInNewThread) {
                return SonicEngine.getInstance().getRuntime().setCookie(this.getCurrentUrl(), cookies);
            }
            SonicUtils.log(TAG, 4, "setCookiesFromHeaders asynchronous in new thread.");
            SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                @Override
                public void run() {
                    SonicEngine.getInstance().getRuntime().setCookie(SonicSession.this.getCurrentUrl(), cookies);
                }
            }, 0L);
            return true;
        }
        return false;
    }

    protected Object onRequestResource(String url) {
        return null;
    }

    public boolean onWebReady(SonicDiffDataCallback diffDataCallback) {
        return false;
    }

    public boolean onClientPageFinished(String url) {
        if (this.isMatchCurrentUrl(url)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClientPageFinished:url=" + url + ".");
            this.wasOnPageFinishInvoked.set(true);
            return true;
        }
        return false;
    }

    public boolean isMatchCurrentUrl(String url) {
        try {
            Uri currentUri = Uri.parse((String)this.srcUrl);
            Uri uri = Uri.parse((String)url);
            String currentPath = currentUri.getHost() + currentUri.getPath();
            String pendingPath = uri.getHost() + uri.getPath();
            if (currentUri.getHost().equalsIgnoreCase(uri.getHost())) {
                if (!currentPath.endsWith("/")) {
                    currentPath = currentPath + "/";
                }
                if (!pendingPath.endsWith("/")) {
                    pendingPath = pendingPath + "/";
                }
                return currentPath.equalsIgnoreCase(pendingPath);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "isMatchCurrentUrl error:" + e.getMessage());
        }
        return false;
    }

    protected HashMap<String, String> getHeaders() {
        if (null != this.server) {
            return SonicUtils.getFilteredHeaders(this.server.getResponseHeaderFields());
        }
        return null;
    }

    protected String getCharsetFromHeaders() {
        String headerValue;
        HashMap<String, String> headers = this.getHeaders();
        String charset = SonicUtils.DEFAULT_CHARSET;
        String key = "Content-Type".toLowerCase();
        if (headers != null && headers.containsKey(key) && !TextUtils.isEmpty((CharSequence)(headerValue = headers.get(key)))) {
            charset = SonicUtils.getCharset(headerValue);
        }
        return charset;
    }

    protected HashMap<String, String> getCacheHeaders() {
        return SonicUtils.getFilteredHeaders(SonicFileUtils.getHeaderFromLocalCache(this.id));
    }

    public SonicSessionClient getSessionClient() {
        return this.sessionClient;
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(boolean force) {
        int curState = this.sessionState.get();
        if (3 != curState) {
            if (null != this.sessionClient) {
                this.sessionClient = null;
            }
            if (null != this.pendingWebResourceStream) {
                try {
                    this.pendingWebResourceStream.close();
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "pendingWebResourceStream.close error:" + e.getMessage());
                }
                this.pendingWebResourceStream = null;
            }
            if (null != this.pendingDiffData) {
                this.pendingDiffData = null;
            }
            this.clearSessionData();
            if (force || this.canDestroy()) {
                this.sessionState.set(3);
                AtomicInteger atomicInteger = this.sessionState;
                synchronized (atomicInteger) {
                    this.sessionState.notify();
                }
                if (null != this.server && !force) {
                    this.server.disconnect();
                    this.server = null;
                }
                this.notifyStateChange(curState, 3, null);
                this.mainHandler.removeMessages(3);
                this.callbackWeakRefList.clear();
                this.isWaitingForDestroy.set(false);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") final destroy, force=" + force + ".");
                return;
            }
            if (this.isWaitingForDestroy.compareAndSet(false, true)) {
                this.mainHandler.sendEmptyMessageDelayed(3, 6000L);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") waiting for destroy, current state =" + curState + ".");
            }
        }
    }

    protected void clearSessionData() {
    }

    public static interface Callback {
        public void onSessionStateChange(SonicSession var1, int var2, int var3, Bundle var4);
    }
}

