/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Intent;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicSniSSLSocketFactory;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public abstract class SonicSessionConnection {
    private static final String TAG = "SonicSdk_SonicSessionConnection";
    public static final String CUSTOM_HEAD_FILED_ETAG = "eTag";
    public static final String CUSTOM_HEAD_FILED_ACCEPT_DIFF = "accept-diff";
    public static final String CUSTOM_HEAD_FILED_TEMPLATE_TAG = "template-tag";
    public static final String CUSTOM_HEAD_FILED_TEMPLATE_CHANGE = "template-change";
    public static final String CUSTOM_HEAD_FILED_CACHE_OFFLINE = "cache-offline";
    public static final String DNS_PREFETCH_ADDRESS = "dns-prefetch-address";
    public static final String CUSTOM_HEAD_FILED_SDK_VERSION = "sonic-sdk-version";
    public static final String CUSTOM_HEAD_FILED_DNS_PREFETCH = "sonic-dns-prefetch";
    public static final String CUSTOM_HEAD_FILED_HTML_SHA1 = "sonic-html-sha1";
    public static final String HTTP_HEAD_CSP = "Content-Security-Policy";
    public static final String HTTP_HEAD_CSP_REPORT_ONLY = "Content-Security-Policy-Report-Only";
    public static final String HTTP_HEAD_FILED_SET_COOKIE = "Set-Cookie";
    public static final String HTTP_HEAD_FIELD_CACHE_CONTROL = "Cache-Control";
    public static final String HTTP_HEAD_FIELD_EXPIRES = "Expires";
    public static final String HTTP_HEAD_FIELD_PRAGMA = "Pragma";
    public static final String HTTP_HEAD_FIELD_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_HEAD_FIELD_COOKIE = "Cookie";
    public static final String HTTP_HEAD_FILED_USER_AGENT = "User-Agent";
    protected final SonicSession session;
    protected final Intent intent;
    protected BufferedInputStream responseStream;

    public SonicSessionConnection(SonicSession session, Intent intent) {
        this.session = session;
        this.intent = intent != null ? intent : new Intent();
    }

    public synchronized int connect() {
        return this.internalConnect();
    }

    public abstract void disconnect();

    public abstract int getResponseCode();

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public abstract String getResponseHeaderField(String var1);

    public synchronized BufferedInputStream getResponseStream() {
        if (this.responseStream == null) {
            this.responseStream = this.internalGetResponseStream();
        }
        return this.responseStream;
    }

    protected abstract int internalConnect();

    protected abstract BufferedInputStream internalGetResponseStream();

    public static class SessionConnectionDefaultImpl
    extends SonicSessionConnection {
        protected final URLConnection connectionImpl = this.createConnection();

        public SessionConnectionDefaultImpl(SonicSession session, Intent intent) {
            super(session, intent);
            this.initConnection(this.connectionImpl);
        }

        protected URLConnection createConnection() {
            String currentUrl = this.session.srcUrl;
            if (TextUtils.isEmpty((CharSequence)currentUrl)) {
                return null;
            }
            URLConnection connection = null;
            try {
                URL url = new URL(currentUrl);
                String dnsPrefetchAddress = this.intent.getStringExtra(SonicSessionConnection.DNS_PREFETCH_ADDRESS);
                String originHost = null;
                if (!TextUtils.isEmpty((CharSequence)dnsPrefetchAddress)) {
                    originHost = url.getHost();
                    url = new URL(currentUrl.replace(originHost, dnsPrefetchAddress));
                    SonicUtils.log(SonicSessionConnection.TAG, 4, "create UrlConnection with DNS-Prefetch(" + originHost + " -> " + dnsPrefetchAddress + ").");
                }
                if ((connection = url.openConnection()) != null) {
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                    }
                    if (!TextUtils.isEmpty((CharSequence)originHost)) {
                        connection.setRequestProperty("Host", originHost);
                        connection.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_DNS_PREFETCH, url.getHost());
                        if (connection instanceof HttpsURLConnection) {
                            final String finalOriginHost = originHost;
                            final URL finalUrl = url;
                            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                            httpsConnection.setSSLSocketFactory(new SonicSniSSLSocketFactory(SonicEngine.getInstance().getRuntime().getContext(), originHost));
                            httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    boolean verifySuccess = false;
                                    long startTime = System.currentTimeMillis();
                                    if (finalUrl.getHost().equals(hostname)) {
                                        verifySuccess = HttpsURLConnection.getDefaultHostnameVerifier().verify(finalOriginHost, session);
                                        SonicUtils.log(SonicSessionConnection.TAG, 3, "verify hostname cost " + (System.currentTimeMillis() - startTime) + " ms.");
                                    }
                                    return verifySuccess;
                                }
                            });
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (connection != null) {
                    connection = null;
                }
                SonicUtils.log(SonicSessionConnection.TAG, 6, "create UrlConnection fail, error:" + e.getMessage() + ".");
            }
            return connection;
        }

        protected boolean initConnection(URLConnection connection) {
            if (null != connection) {
                String cookie;
                SonicSessionConfig config = this.session.config;
                connection.setConnectTimeout(config.CONNECT_TIMEOUT_MILLIS);
                connection.setReadTimeout(config.READ_TIMEOUT_MILLIS);
                connection.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_ACCEPT_DIFF, config.ACCEPT_DIFF_DATA ? "true" : "false");
                String eTag = this.intent.getStringExtra(SonicSessionConnection.CUSTOM_HEAD_FILED_ETAG);
                if (null == eTag) {
                    eTag = "";
                }
                connection.setRequestProperty("If-None-Match", eTag);
                String templateTag = this.intent.getStringExtra(SonicSessionConnection.CUSTOM_HEAD_FILED_TEMPLATE_TAG);
                if (null == templateTag) {
                    templateTag = "";
                }
                connection.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_TEMPLATE_TAG, templateTag);
                connection.setRequestProperty("method", "GET");
                connection.setRequestProperty("Accept-Encoding", "gzip");
                connection.setRequestProperty("Accept-Language", "zh-CN,zh;");
                connection.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_SDK_VERSION, "Sonic/2.0.0");
                if (null != config.customRequestHeaders && 0 != config.customRequestHeaders.size()) {
                    for (Map.Entry<String, String> entry : config.customRequestHeaders.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(cookie = this.intent.getStringExtra(SonicSessionConnection.HTTP_HEAD_FIELD_COOKIE)))) {
                    connection.setRequestProperty(SonicSessionConnection.HTTP_HEAD_FIELD_COOKIE, cookie);
                } else {
                    SonicUtils.log(SonicSessionConnection.TAG, 6, "create UrlConnection cookie is empty");
                }
                connection.setRequestProperty(SonicSessionConnection.HTTP_HEAD_FILED_USER_AGENT, this.intent.getStringExtra(SonicSessionConnection.HTTP_HEAD_FILED_USER_AGENT));
                return true;
            }
            return false;
        }

        @Override
        protected synchronized int internalConnect() {
            block6: {
                if (this.connectionImpl instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionImpl;
                    try {
                        httpURLConnection.connect();
                        return 0;
                    }
                    catch (Throwable e) {
                        String errMsg = e.getMessage();
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "connect error:" + errMsg);
                        if (e instanceof IOException) {
                            if (e instanceof SocketTimeoutException) {
                                return -902;
                            }
                            if (!TextUtils.isEmpty((CharSequence)errMsg) && errMsg.contains("timeoutexception")) {
                                return -902;
                            }
                            return -901;
                        }
                        if (!(e instanceof NullPointerException)) break block6;
                        return -903;
                    }
                }
            }
            return -1;
        }

        @Override
        public void disconnect() {
            if (this.connectionImpl instanceof HttpURLConnection) {
                final HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionImpl;
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                httpURLConnection.disconnect();
                            }
                            catch (Throwable e) {
                                SonicUtils.log(SonicSessionConnection.TAG, 6, "disconnect error:" + e.getMessage());
                            }
                        }
                    }, 0L);
                } else {
                    try {
                        httpURLConnection.disconnect();
                    }
                    catch (Exception e) {
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "disconnect error:" + e.getMessage());
                    }
                }
            }
        }

        @Override
        protected BufferedInputStream internalGetResponseStream() {
            if (null == this.responseStream && null != this.connectionImpl) {
                try {
                    InputStream inputStream = this.connectionImpl.getInputStream();
                    this.responseStream = "gzip".equalsIgnoreCase(this.connectionImpl.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(inputStream)) : new BufferedInputStream(inputStream);
                }
                catch (Throwable e) {
                    SonicUtils.log(SonicSessionConnection.TAG, 6, "getResponseStream error:" + e.getMessage() + ".");
                }
            }
            return this.responseStream;
        }

        @Override
        public int getResponseCode() {
            block6: {
                if (this.connectionImpl instanceof HttpURLConnection) {
                    try {
                        return ((HttpURLConnection)this.connectionImpl).getResponseCode();
                    }
                    catch (Throwable e) {
                        String errMsg = e.getMessage();
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "getResponseCode error:" + errMsg);
                        if (e instanceof IOException) {
                            if (e instanceof SocketTimeoutException) {
                                return -902;
                            }
                            if (!TextUtils.isEmpty((CharSequence)errMsg) && errMsg.contains("timeoutexception")) {
                                return -902;
                            }
                            return -901;
                        }
                        if (!(e instanceof NullPointerException)) break block6;
                        return -903;
                    }
                }
            }
            return -1;
        }

        @Override
        public Map<String, List<String>> getResponseHeaderFields() {
            if (null == this.connectionImpl) {
                return null;
            }
            return this.connectionImpl.getHeaderFields();
        }

        @Override
        public String getResponseHeaderField(String key) {
            List<String> responseHeaderValues;
            Map<String, List<String>> responseHeaderFields = this.getResponseHeaderFields();
            if (null != responseHeaderFields && 0 != responseHeaderFields.size() && null != (responseHeaderValues = responseHeaderFields.get(key.toLowerCase())) && 0 != responseHeaderValues.size()) {
                StringBuilder stringBuilder = new StringBuilder(responseHeaderValues.get(0));
                int size = responseHeaderValues.size();
                for (int index = 1; index < size; ++index) {
                    stringBuilder.append(',');
                    stringBuilder.append(responseHeaderValues.get(index));
                }
                return stringBuilder.toString();
            }
            return null;
        }
    }
}

