/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import com.tencent.sonic.sdk.SonicDBHelper;
import java.util.ArrayList;
import java.util.List;

class SonicDataHelper {
    private static final String TAG = "SonicSdk_SonicDataHelper";

    SonicDataHelper() {
    }

    @NonNull
    static SessionData getSessionData(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (null == sessionData) {
            sessionData = new SessionData();
        }
        return sessionData;
    }

    private static SessionData getSessionData(SQLiteDatabase db, String sessionId) {
        Cursor cursor = db.query("SessionData", SonicDBHelper.getAllSessionDataColumn(), "sessionID=?", new String[]{sessionId}, null, null, null);
        SessionData sessionData = null;
        if (cursor != null && cursor.moveToFirst()) {
            sessionData = SonicDataHelper.querySessionData(cursor);
        }
        if (cursor != null) {
            cursor.close();
        }
        return sessionData;
    }

    private static SessionData querySessionData(Cursor cursor) {
        SessionData sessionData = new SessionData();
        sessionData.sessionId = cursor.getString(cursor.getColumnIndex("sessionID"));
        sessionData.eTag = cursor.getString(cursor.getColumnIndex("eTag"));
        sessionData.htmlSha1 = cursor.getString(cursor.getColumnIndex("htmlSha1"));
        sessionData.htmlSize = cursor.getLong(cursor.getColumnIndex("htmlSize"));
        sessionData.templateTag = cursor.getString(cursor.getColumnIndex("templateTag"));
        sessionData.templateUpdateTime = cursor.getLong(cursor.getColumnIndex("templateUpdateTime"));
        sessionData.expiredTime = cursor.getLong(cursor.getColumnIndex("cacheExpiredTime"));
        sessionData.unAvailableTime = cursor.getLong(cursor.getColumnIndex("UnavailableTime"));
        sessionData.cacheHitCount = cursor.getInt(cursor.getColumnIndex("cacheHitCount"));
        return sessionData;
    }

    static List<SessionData> getAllSessionByHitCount() {
        ArrayList<SessionData> sessionDatas = new ArrayList<SessionData>();
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        Cursor cursor = db.query("SessionData", SonicDBHelper.getAllSessionDataColumn(), null, null, null, null, "cacheHitCount ASC");
        while (cursor != null && cursor.moveToNext()) {
            sessionDatas.add(SonicDataHelper.querySessionData(cursor));
        }
        return sessionDatas;
    }

    static void saveSessionData(String sessionId, SessionData sessionData) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SonicDataHelper.saveSessionData(db, sessionId, sessionData);
    }

    private static void saveSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        sessionData.sessionId = sessionId;
        SessionData storedSessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (storedSessionData != null) {
            sessionData.cacheHitCount = storedSessionData.cacheHitCount;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
        } else {
            SonicDataHelper.insertSessionData(db, sessionId, sessionData);
        }
    }

    private static void insertSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        ContentValues contentValues = SonicDataHelper.getContentValues(sessionId, sessionData);
        db.insert("SessionData", null, contentValues);
    }

    private static void updateSessionData(SQLiteDatabase db, String sessionId, SessionData sessionData) {
        ContentValues contentValues = SonicDataHelper.getContentValues(sessionId, sessionData);
        db.update("SessionData", contentValues, "sessionID=?", new String[]{sessionId});
    }

    @NonNull
    private static ContentValues getContentValues(String sessionId, SessionData sessionData) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("sessionID", sessionId);
        contentValues.put("eTag", sessionData.eTag);
        contentValues.put("htmlSha1", sessionData.htmlSha1);
        contentValues.put("htmlSize", Long.valueOf(sessionData.htmlSize));
        contentValues.put("templateTag", sessionData.templateTag);
        contentValues.put("templateUpdateTime", Long.valueOf(sessionData.templateUpdateTime));
        contentValues.put("cacheExpiredTime", Long.valueOf(sessionData.expiredTime));
        contentValues.put("UnavailableTime", Long.valueOf(sessionData.unAvailableTime));
        contentValues.put("cacheHitCount", Integer.valueOf(sessionData.cacheHitCount));
        return contentValues;
    }

    static void removeSessionData(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete("SessionData", "sessionID=?", new String[]{sessionId});
    }

    static boolean setSonicUnavailableTime(String sessionId, long unavailableTime) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (sessionData != null) {
            sessionData.unAvailableTime = unavailableTime;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
            return true;
        }
        sessionData = new SessionData();
        sessionData.sessionId = sessionId;
        sessionData.eTag = "Unknown";
        sessionData.htmlSha1 = "Unknown";
        sessionData.unAvailableTime = unavailableTime;
        SonicDataHelper.insertSessionData(db, sessionId, sessionData);
        return true;
    }

    static long getLastSonicUnavailableTime(String sessionId) {
        SessionData sessionData = SonicDataHelper.getSessionData(sessionId);
        return sessionData.unAvailableTime;
    }

    static void updateSonicCacheHitCount(String sessionId) {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        SonicDataHelper.updateSonicCacheHitCount(db, sessionId);
    }

    private static void updateSonicCacheHitCount(SQLiteDatabase db, String sessionId) {
        SessionData sessionData = SonicDataHelper.getSessionData(db, sessionId);
        if (sessionData != null) {
            ++sessionData.cacheHitCount;
            SonicDataHelper.updateSessionData(db, sessionId, sessionData);
        }
    }

    static synchronized void clear() {
        SQLiteDatabase db = SonicDBHelper.getInstance().getWritableDatabase();
        db.delete("SessionData", null, null);
    }

    static class SessionData {
        String sessionId;
        String eTag;
        String templateTag;
        String htmlSha1;
        long htmlSize;
        long templateUpdateTime;
        long expiredTime;
        long unAvailableTime;
        int cacheHitCount;

        SessionData() {
        }

        public void reset() {
            this.eTag = "";
            this.templateTag = "";
            this.htmlSha1 = "";
            this.htmlSize = 0L;
            this.templateUpdateTime = 0L;
            this.expiredTime = 0L;
            this.cacheHitCount = 0;
            this.unAvailableTime = 0L;
        }
    }
}

