/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicSessionClient;
import com.tencent.sonic.sdk.SonicSessionThreadPool;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class SonicRuntime {
    private static final String TAG = "SonicSdk_SonicRuntime";
    protected final Context context;

    public SonicRuntime(Context context) {
        if (null == context) {
            throw new NullPointerException("SonicRuntime context con not be null!");
        }
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public String makeSessionId(String url, boolean isAccountRelated) {
        if (this.isSonicUrl(url)) {
            StringBuilder sessionIdBuilder = new StringBuilder();
            try {
                Uri uri = Uri.parse((String)url);
                sessionIdBuilder.append(uri.getAuthority()).append(uri.getPath());
                if (uri.isHierarchical()) {
                    String sonicRemainParams = uri.getQueryParameter("sonic_remain_params");
                    TreeSet remainParamTreeSet = new TreeSet();
                    if (!TextUtils.isEmpty((CharSequence)sonicRemainParams)) {
                        Collections.addAll(remainParamTreeSet, sonicRemainParams.split(";"));
                    }
                    TreeSet<String> parameterNamesTreeSet = new TreeSet<String>(this.getQueryParameterNames(uri));
                    if (!remainParamTreeSet.isEmpty()) {
                        parameterNamesTreeSet.remove("sonic_remain_params");
                    }
                    for (String parameterName : parameterNamesTreeSet) {
                        if (TextUtils.isEmpty((CharSequence)parameterName) || !parameterName.startsWith("sonic_") && !remainParamTreeSet.contains(parameterName)) continue;
                        sessionIdBuilder.append(parameterName).append(uri.getQueryParameter(parameterName));
                    }
                }
            }
            catch (Throwable e) {
                this.log(TAG, 6, "makeSessionId error:" + e.getMessage() + ", url=" + url);
                sessionIdBuilder.setLength(0);
                sessionIdBuilder.append(url);
            }
            String sessionId = isAccountRelated ? this.getCurrentUserAccount() + "_" + SonicUtils.getMD5(sessionIdBuilder.toString()) : SonicUtils.getMD5(sessionIdBuilder.toString());
            return sessionId;
        }
        return null;
    }

    public Set<String> getQueryParameterNames(Uri uri) {
        int end;
        if (uri == null) {
            return Collections.emptySet();
        }
        if (uri.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        String query = uri.getEncodedQuery();
        if (query == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            names.add(Uri.decode((String)name));
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableSet(names);
    }

    public boolean shouldLog(int level) {
        return true;
    }

    public abstract void log(String var1, int var2, String var3);

    public abstract String getCookie(String var1);

    public abstract boolean setCookie(String var1, List<String> var2);

    public abstract String getUserAgent();

    public File getSonicCacheDir() {
        String path = this.context.getFilesDir() + "/Sonic/";
        File file = new File(path.trim());
        if (!file.exists() && !file.mkdir()) {
            this.log(TAG, 6, "getSonicCacheDir error:make dir(" + file.getAbsolutePath() + ") fail!");
            this.notifyError(null, path, -1003);
        }
        return file;
    }

    public abstract String getCurrentUserAccount();

    public abstract boolean isSonicUrl(String var1);

    public abstract Object createWebResourceResponse(String var1, String var2, InputStream var3, Map<String, String> var4);

    public abstract boolean isNetworkValid();

    public String getHostDirectAddress(String url) {
        return null;
    }

    public abstract void showToast(CharSequence var1, int var2);

    public abstract void postTaskToThread(Runnable var1, long var2);

    public void postTaskToSessionThread(Runnable task) {
        SonicSessionThreadPool.postTask(task);
    }

    public void postTaskToMainThread(Runnable task, long delayMillis) {
        new Handler(Looper.getMainLooper()).postDelayed(task, delayMillis);
    }

    public abstract void notifyError(SonicSessionClient var1, String var2, int var3);
}

