/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tencent.sonic.sdk.QuickSonicSession;
import com.tencent.sonic.sdk.SonicConfig;
import com.tencent.sonic.sdk.SonicDBHelper;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicUtils;
import com.tencent.sonic.sdk.StandardSonicSession;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class SonicEngine {
    private static final String TAG = "SonicSdk_SonicEngine";
    private final SonicRuntime runtime;
    private final SonicConfig config;
    private static SonicEngine sInstance;
    private final ConcurrentHashMap<String, SonicSession> preloadSessionPool = new ConcurrentHashMap(5);
    private final ConcurrentHashMap<String, SonicSession> runningSessionHashMap = new ConcurrentHashMap(5);
    private final SonicSession.Callback sessionCallback = new SonicSession.Callback(){

        @Override
        public void onSessionStateChange(SonicSession session, int oldState, int newState, Bundle extraData) {
            SonicUtils.log(SonicEngine.TAG, 3, "onSessionStateChange:session(" + session.sId + ") from state " + oldState + " -> " + newState);
            switch (newState) {
                case 1: {
                    SonicEngine.this.runningSessionHashMap.put(session.id, session);
                    break;
                }
                case 3: {
                    SonicEngine.this.runningSessionHashMap.remove(session.id);
                }
            }
        }
    };

    private SonicEngine(SonicRuntime runtime, SonicConfig config) {
        this.runtime = runtime;
        this.config = config;
    }

    public static synchronized SonicEngine getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("SonicEngine::createInstance() needs to be called before SonicEngine::getInstance()");
        }
        return sInstance;
    }

    public static synchronized boolean isGetInstanceAllowed() {
        return null != sInstance;
    }

    public static synchronized SonicEngine createInstance(@NonNull SonicRuntime runtime, @NonNull SonicConfig config) {
        if (null == sInstance) {
            sInstance = new SonicEngine(runtime, config);
            if (config.AUTO_INIT_DB_WHEN_CREATE) {
                sInstance.initSonicDB();
            }
        }
        return sInstance;
    }

    public void initSonicDB() {
        SonicDBHelper.createInstance(this.getRuntime().getContext()).getWritableDatabase();
    }

    public SonicRuntime getRuntime() {
        return this.runtime;
    }

    public SonicConfig getConfig() {
        return this.config;
    }

    public boolean isSonicAvailable() {
        return !SonicDBHelper.getInstance().isUpgrading();
    }

    public static String makeSessionId(String url, boolean isAccountRelated) {
        return SonicEngine.getInstance().getRuntime().makeSessionId(url, isAccountRelated);
    }

    public synchronized boolean preCreateSession(@NonNull String url, @NonNull SonicSessionConfig sessionConfig) {
        if (this.isSonicAvailable()) {
            String sessionId = SonicEngine.makeSessionId(url, sessionConfig.IS_ACCOUNT_RELATED);
            if (!TextUtils.isEmpty((CharSequence)sessionId)) {
                SonicSession sonicSession = this.lookupSession(sessionConfig, sessionId, false);
                if (null != sonicSession) {
                    this.runtime.log(TAG, 6, "preCreateSession\uff1asessionId(" + sessionId + ") is already in preload pool.");
                    return false;
                }
                if (this.preloadSessionPool.size() < this.config.MAX_PRELOAD_SESSION_COUNT) {
                    if (this.isSessionAvailable(sessionId) && this.runtime.isNetworkValid() && null != (sonicSession = this.internalCreateSession(sessionId, url, sessionConfig))) {
                        this.preloadSessionPool.put(sessionId, sonicSession);
                        return true;
                    }
                } else {
                    this.runtime.log(TAG, 6, "create id(" + sessionId + ") fail for preload size is bigger than " + this.config.MAX_PRELOAD_SESSION_COUNT + ".");
                }
            }
        } else {
            this.runtime.log(TAG, 6, "preCreateSession fail for sonic service is unavailable!");
        }
        return false;
    }

    public synchronized SonicSession createSession(@NonNull String url, @NonNull SonicSessionConfig sessionConfig) {
        if (this.isSonicAvailable()) {
            String sessionId = SonicEngine.makeSessionId(url, sessionConfig.IS_ACCOUNT_RELATED);
            if (!TextUtils.isEmpty((CharSequence)sessionId)) {
                SonicSession sonicSession = this.lookupSession(sessionConfig, sessionId, true);
                if (null != sonicSession) {
                    sonicSession.setIsPreload(url);
                } else if (this.isSessionAvailable(sessionId)) {
                    sonicSession = this.internalCreateSession(sessionId, url, sessionConfig);
                }
                return sonicSession;
            }
        } else {
            this.runtime.log(TAG, 6, "createSession fail for sonic service is unavailable!");
        }
        return null;
    }

    private SonicSession lookupSession(SonicSessionConfig config, String sessionId, boolean pick) {
        if (!TextUtils.isEmpty((CharSequence)sessionId) && config != null) {
            SonicSession sonicSession = this.preloadSessionPool.get(sessionId);
            if (sonicSession != null) {
                if (!config.equals(sonicSession.config) || sonicSession.config.PRELOAD_SESSION_EXPIRED_TIME > 0L && System.currentTimeMillis() - sonicSession.createdTime > sonicSession.config.PRELOAD_SESSION_EXPIRED_TIME) {
                    if (this.runtime.shouldLog(6)) {
                        this.runtime.log(TAG, 6, "lookupSession error:sessionId(" + sessionId + ") is expired.");
                    }
                    this.preloadSessionPool.remove(sessionId);
                    sonicSession.destroy();
                    return null;
                }
                if (pick) {
                    this.preloadSessionPool.remove(sessionId);
                }
            }
            return sonicSession;
        }
        return null;
    }

    private SonicSession internalCreateSession(String sessionId, String url, SonicSessionConfig sessionConfig) {
        if (!this.runningSessionHashMap.containsKey(sessionId)) {
            SonicSession sonicSession = sessionConfig.sessionMode == 1 ? new QuickSonicSession(sessionId, url, sessionConfig) : new StandardSonicSession(sessionId, url, sessionConfig);
            sonicSession.addCallback(this.sessionCallback);
            if (sessionConfig.AUTO_START_WHEN_CREATE) {
                sonicSession.start();
            }
            return sonicSession;
        }
        if (this.runtime.shouldLog(6)) {
            this.runtime.log(TAG, 6, "internalCreateSession error:sessionId(" + sessionId + ") is running now.");
        }
        return null;
    }

    private boolean isSessionAvailable(String sessionId) {
        long unavailableTime = SonicDataHelper.getLastSonicUnavailableTime(sessionId);
        if (System.currentTimeMillis() > unavailableTime) {
            return true;
        }
        if (this.runtime.shouldLog(6)) {
            this.runtime.log(TAG, 6, "sessionId(" + sessionId + ") is unavailable and unavailable time until " + unavailableTime + ".");
        }
        return false;
    }

    public synchronized boolean cleanCache() {
        if (!this.preloadSessionPool.isEmpty()) {
            this.runtime.log(TAG, 4, "cleanCache: remove all preload sessions, size=" + this.preloadSessionPool.size() + ".");
            Collection<SonicSession> sonicSessions = this.preloadSessionPool.values();
            for (SonicSession session : sonicSessions) {
                session.destroy();
            }
            this.preloadSessionPool.clear();
        }
        if (!this.runningSessionHashMap.isEmpty()) {
            this.runtime.log(TAG, 6, "cleanCache fail, running session map's size is " + this.runningSessionHashMap.size() + ".");
            return false;
        }
        this.runtime.log(TAG, 4, "cleanCache: remove all sessions cache.");
        return SonicUtils.removeAllSessionCache();
    }

    public synchronized boolean removeSessionCache(@NonNull String sessionId) {
        SonicSession sonicSession = this.preloadSessionPool.get(sessionId);
        if (null != sonicSession) {
            sonicSession.destroy();
            this.preloadSessionPool.remove(sessionId);
            this.runtime.log(TAG, 4, "sessionId(" + sessionId + ") removeSessionCache: remove preload session.");
        }
        if (!this.runningSessionHashMap.containsKey(sessionId)) {
            this.runtime.log(TAG, 4, "sessionId(" + sessionId + ") removeSessionCache success.");
            SonicUtils.removeSessionCache(sessionId);
            return true;
        }
        this.runtime.log(TAG, 6, "sessionId(" + sessionId + ") removeSessionCache fail: session is running.");
        return false;
    }

    public void trimSonicCache() {
        SonicFileUtils.checkAndTrimCache();
    }
}

