/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import com.tencent.sonic.sdk.SonicUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class SonicSessionThreadPool {
    private static final String TAG = "SonicSdk_SonicSessionThreadPool";
    private static final SonicSessionThreadPool sInstance = new SonicSessionThreadPool();
    private final ExecutorService executorServiceImpl = new ThreadPoolExecutor(1, 6, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SessionThreadFactory());

    private SonicSessionThreadPool() {
    }

    private boolean execute(Runnable task) {
        try {
            this.executorServiceImpl.execute(task);
            return true;
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "execute task error:" + e.getMessage());
            return false;
        }
    }

    static boolean postTask(Runnable task) {
        return sInstance.execute(task);
    }

    private static class SessionThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String NAME_PREFIX = "pool-sonic-session-thread-";

        SessionThreadFactory() {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, NAME_PREFIX + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

