/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import com.tencent.sonic.sdk.SonicCacheInterceptor;
import com.tencent.sonic.sdk.SonicSessionConnectionInterceptor;

public class SonicSessionConfig {
    int CONNECT_TIMEOUT_MILLIS = 5000;
    int READ_TIMEOUT_MILLIS = 15000;
    int READ_BUF_SIZE = 10240;
    long PRELOAD_SESSION_EXPIRED_TIME = 180000L;
    boolean ACCEPT_DIFF_DATA = true;
    boolean IS_ACCOUNT_RELATED = true;
    boolean RELOAD_IN_BAD_NETWORK = false;
    boolean AUTO_START_WHEN_CREATE = true;
    String USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST = "Bad Network!";
    int sessionMode = 1;
    SonicCacheInterceptor cacheInterceptor = null;
    SonicSessionConnectionInterceptor connectionInterceptor = null;

    public boolean equals(Object other) {
        return other instanceof SonicSessionConfig && this.sessionMode == ((SonicSessionConfig)other).sessionMode;
    }

    private SonicSessionConfig() {
    }

    public static class Builder {
        private final SonicSessionConfig target = new SonicSessionConfig();

        public Builder setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.target.CONNECT_TIMEOUT_MILLIS = connectTimeoutMillis;
            return this;
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            this.target.READ_TIMEOUT_MILLIS = readTimeoutMillis;
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            this.target.READ_BUF_SIZE = readBufferSize;
            return this;
        }

        public Builder setPreloadSessionExpiredTimeMillis(long preloadSessionExpiredTimeMillis) {
            this.target.PRELOAD_SESSION_EXPIRED_TIME = preloadSessionExpiredTimeMillis;
            return this;
        }

        public Builder setAcceptDiff(boolean enable) {
            this.target.ACCEPT_DIFF_DATA = enable;
            return this;
        }

        public Builder setIsAccountRelated(boolean value) {
            this.target.IS_ACCOUNT_RELATED = value;
            return this;
        }

        public Builder setReloadInBadNetwork(boolean reloadInBadNetwork) {
            this.target.RELOAD_IN_BAD_NETWORK = reloadInBadNetwork;
            return this;
        }

        public Builder setAutoStartWhenCreate(boolean autoStartWhenCreate) {
            this.target.AUTO_START_WHEN_CREATE = autoStartWhenCreate;
            return this;
        }

        public Builder setUseSonicCacheInBadNetworkToastMessage(String toastMessage) {
            this.target.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST = toastMessage;
            return this;
        }

        public Builder setSessionMode(int sessionMode) {
            this.target.sessionMode = sessionMode;
            return this;
        }

        public Builder setCacheInterceptor(SonicCacheInterceptor interceptor) {
            this.target.cacheInterceptor = interceptor;
            return this;
        }

        public Builder setConnectionIntercepter(SonicSessionConnectionInterceptor intercepter) {
            this.target.connectionInterceptor = intercepter;
            return this;
        }

        public SonicSessionConfig build() {
            return this.target;
        }
    }
}

