/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

public class SonicConfig {
    int MAX_PRELOAD_SESSION_COUNT = 5;
    long SONIC_UNAVAILABLE_TIME = 21600000L;
    boolean VERIFY_CACHE_FILE_WITH_SHA1 = true;
    boolean GET_COOKIE_WHEN_SESSION_CREATE = true;

    private SonicConfig() {
    }

    public static class Builder {
        private final SonicConfig target = new SonicConfig();

        public Builder setMaxPreloadSessionCount(int maxPreloadSessionCount) {
            this.target.MAX_PRELOAD_SESSION_COUNT = maxPreloadSessionCount;
            return this;
        }

        public Builder setUnavailableTime(long unavailableTime) {
            this.target.SONIC_UNAVAILABLE_TIME = unavailableTime;
            return this;
        }

        public Builder setCacheVerifyWithSha1(boolean enable) {
            this.target.VERIFY_CACHE_FILE_WITH_SHA1 = enable;
            return this;
        }

        public Builder setGetCookieWhenSessionCreate(boolean value) {
            this.target.GET_COOKIE_WHEN_SESSION_CREATE = value;
            return this;
        }

        public SonicConfig build() {
            return this.target;
        }
    }
}

