/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicSessionConnection;
import com.tencent.sonic.sdk.SonicSessionStream;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import org.json.JSONObject;

public class StandardSonicSession
extends SonicSession
implements Handler.Callback {
    private static final String TAG = "SonicSdk_StandardSonicSession";
    private static final String TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH = "refresh";
    private static final int CLIENT_CORE_MSG_BEGIN = 4;
    private static final int CLIENT_MSG_CLIENT_READY = 5;
    private final Object webResponseLock = new Object();

    StandardSonicSession(String id, String url, SonicSessionConfig config) {
        super(id, url, config);
    }

    @Override
    public int getSrcResultCode() {
        return this.srcResultCode;
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (super.handleMessage(msg)) {
            return true;
        }
        switch (msg.what) {
            case 5: {
                this.sessionClient.loadUrl(this.srcUrl, new Bundle());
                break;
            }
            case 1: {
                Bundle data;
                if (msg.arg2 == 200) {
                    Bundle data2 = msg.getData();
                    this.pendingDiffData = data2.getString("_diff_data_");
                } else if (msg.arg2 == 2000 && (data = msg.getData()).getBoolean(TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH, false)) {
                    SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:load url with preload=2, webCallback is null? ->" + (null != this.diffDataCallback));
                    this.sessionClient.loadUrl(this.srcUrl, null);
                }
                this.setResult(msg.arg1, msg.arg2, true);
                break;
            }
            case 2: {
                this.diffDataCallback = (SonicDiffDataCallback)msg.obj;
                this.setResult(this.srcResultCode, this.finalResultCode, true);
                break;
            }
            default: {
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") can not  recognize refresh type: " + msg.what);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onClientReady() {
        if (0 == this.sessionState.get()) {
            this.start();
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            this.sessionClient.loadUrl(this.srcUrl, new Bundle());
        } else {
            Message msg = this.mainHandler.obtainMessage(5);
            this.mainHandler.sendMessage(msg);
        }
        return true;
    }

    @Override
    public boolean onWebReady(SonicDiffDataCallback callback) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") onWebReady: webCallback has set ? ->" + (null != this.diffDataCallback));
        if (null != this.diffDataCallback) {
            this.diffDataCallback = null;
            SonicUtils.log(TAG, 5, "session(" + this.sId + ") onWebReady: call more than once.");
        }
        Message msg = Message.obtain();
        msg.what = 2;
        msg.obj = callback;
        this.mainHandler.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object onRequestResource(String url) {
        Object object;
        if (!this.isMatchCurrentUrl(url)) {
            return null;
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ")  onClientRequestResource:url = " + url);
        }
        this.wasInterceptInvoked.set(true);
        long startTime = System.currentTimeMillis();
        if (this.sessionState.get() == 1) {
            object = this.sessionState;
            synchronized (object) {
                try {
                    if (this.sessionState.get() == 1) {
                        SonicUtils.log(TAG, 4, "session(" + this.sId + ") now wait for pendingWebResourceStream!");
                        this.sessionState.wait(30000L);
                    }
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") wait for pendingWebResourceStream failed" + e.getMessage());
                }
            }
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") is not in running state: " + this.sessionState);
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") have pending stream? -> " + (this.pendingWebResourceStream != null) + ", cost " + (System.currentTimeMillis() - startTime) + "ms.");
        object = this.webResponseLock;
        synchronized (object) {
            if (null != this.pendingWebResourceStream) {
                Object webResourceResponse;
                if (!this.isDestroyedOrWaitingForDestroy()) {
                    String mime = SonicUtils.getMime(this.currUrl);
                    webResourceResponse = SonicEngine.getInstance().getRuntime().createWebResourceResponse(mime, "utf-8", this.pendingWebResourceStream, this.getHeaders());
                } else {
                    webResourceResponse = null;
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClientRequestResource error: session is destroyed!");
                }
                this.pendingWebResourceStream = null;
                return webResourceResponse;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleLocalHtml(String localHtml) {
        if (!TextUtils.isEmpty((CharSequence)localHtml)) {
            Object object = this.webResponseLock;
            synchronized (object) {
                this.pendingWebResourceStream = new ByteArrayInputStream(localHtml.getBytes());
            }
            this.switchState(1, 2, true);
        }
    }

    @Override
    protected void handleFlow_304() {
        Message msg = this.mainHandler.obtainMessage(1);
        msg.arg1 = 304;
        msg.arg2 = 304;
        this.mainHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void handleFlow_TemplateChange() {
        try {
            SonicUtils.log(TAG, 4, "handleFlow_TemplateChange :");
            long startTime = System.currentTimeMillis();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            SonicSessionConnection.ResponseDataTuple responseDataTuple = this.sessionConnection.getResponseData(this.wasOnPageFinishInvoked, output);
            if (responseDataTuple == null) {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:responseDataTuple = null!");
                return;
            }
            String cacheOffline = this.sessionConnection.getResponseHeaderField("cache-offline");
            String htmlString = "";
            if (responseDataTuple.isComplete) {
                htmlString = responseDataTuple.outputStream.toString("UTF-8");
            }
            Message msg = this.mainHandler.obtainMessage(1);
            msg.arg2 = 2000;
            msg.arg1 = 2000;
            if (!this.wasInterceptInvoked.get()) {
                if (TextUtils.isEmpty((CharSequence)htmlString)) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:responseDataTuple not complete!");
                    return;
                }
                Object object = this.webResponseLock;
                synchronized (object) {
                    this.pendingWebResourceStream = new ByteArrayInputStream(htmlString.getBytes());
                }
                msg.arg2 = 304;
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_TemplateChange:oh yeah, templateChange load hit 304.");
            } else if (SonicUtils.needRefreshWebView(cacheOffline)) {
                Bundle data = new Bundle();
                data.putBoolean(TEMPLATE_CHANGE_BUNDLE_PARAMS_REFRESH, true);
                if (responseDataTuple.isComplete) {
                    Object object = this.webResponseLock;
                    synchronized (object) {
                        this.pendingWebResourceStream = new ByteArrayInputStream(htmlString.getBytes());
                    }
                } else {
                    this.pendingWebResourceStream = new SonicSessionStream(this, responseDataTuple.outputStream, responseDataTuple.responseStream);
                }
            }
            this.mainHandler.sendMessage(msg);
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") read byte stream cost " + (System.currentTimeMillis() - startTime) + " ms, wasInterceptInvoked: " + this.wasInterceptInvoked.get());
            }
            if (SonicUtils.needSaveData(cacheOffline)) {
                this.switchState(1, 2, true);
                if (TextUtils.isEmpty((CharSequence)htmlString)) return;
                try {
                    Thread.sleep(1500L);
                    startTime = System.currentTimeMillis();
                    this.separateAndSaveCache(htmlString);
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleFlow_TemplateChange: read complete and finish separate and save cache cost " + (System.currentTimeMillis() - startTime) + " ms.");
                    return;
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_TemplateChange error:" + e.getMessage());
                    return;
                }
            }
            if ("false".equals(cacheOffline)) {
                SonicUtils.removeSessionCache(this.id);
                SonicUtils.log(TAG, 4, "handleClientCoreMessage_TemplateChange:offline mode is 'false', so clean cache.");
                return;
            }
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_TemplateChange:offline->" + cacheOffline + " , so do not need cache to file.");
            return;
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleFlow_TemplateChange error:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFlow_FirstLoad() {
        SonicSessionConnection.ResponseDataTuple responseDataTuple = this.sessionConnection.getResponseData(this.wasInterceptInvoked, null);
        if (null == responseDataTuple) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:responseDataTuple is null!");
            return;
        }
        Message msg = this.mainHandler.obtainMessage(1);
        msg.arg2 = 1000;
        msg.arg1 = 1000;
        String htmlString = null;
        if (responseDataTuple.isComplete) {
            try {
                htmlString = responseDataTuple.outputStream.toString("UTF-8");
                Object object = this.webResponseLock;
                synchronized (object) {
                    this.pendingWebResourceStream = new ByteArrayInputStream(htmlString.getBytes());
                }
                msg.arg2 = 304;
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:oh yeah, first load hit 304.");
            }
            catch (Throwable e) {
                Object object = this.webResponseLock;
                synchronized (object) {
                    this.pendingWebResourceStream = null;
                }
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:" + e.getMessage() + ".");
            }
        } else {
            Object e = this.webResponseLock;
            synchronized (e) {
                this.pendingWebResourceStream = new SonicSessionStream(this, responseDataTuple.outputStream, responseDataTuple.responseStream);
            }
        }
        this.mainHandler.sendMessage(msg);
        boolean hasCacheData = !TextUtils.isEmpty((CharSequence)htmlString);
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:hasCacheData=" + hasCacheData + ".");
        String cacheOffline = this.sessionConnection.getResponseHeaderField("cache-offline");
        if (SonicUtils.needSaveData(cacheOffline)) {
            try {
                if (hasCacheData) {
                    this.switchState(1, 2, true);
                    Thread.sleep(1500L);
                    this.separateAndSaveCache(htmlString);
                }
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_FirstLoad error:  " + e.getMessage());
            }
        } else {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_FirstLoad:offline->" + cacheOffline + " , so do not need cache to file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleFlow_DataUpdate() {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: start.");
        ByteArrayOutputStream output = this.sessionConnection.getResponseData();
        if (output != null) {
            try {
                String eTag = this.sessionConnection.getResponseHeaderField("etag");
                String templateTag = this.sessionConnection.getResponseHeaderField("template-tag");
                String cspContent = this.sessionConnection.getResponseHeaderField("Content-Security-Policy");
                String cspReportOnlyContent = this.sessionConnection.getResponseHeaderField("Content-Security-Policy-Report-Only");
                String cacheOffline = this.sessionConnection.getResponseHeaderField("cache-offline");
                String serverRsp = output.toString("UTF-8");
                long startTime = System.currentTimeMillis();
                JSONObject serverRspJson = new JSONObject(serverRsp);
                JSONObject serverDataJson = serverRspJson.optJSONObject("data");
                JSONObject diffDataJson = SonicUtils.getDiffData(this.id, serverDataJson);
                Bundle diffDataBundle = new Bundle();
                if (null != diffDataJson) {
                    diffDataBundle.putString("_diff_data_", diffDataJson.toString());
                } else {
                    SonicUtils.log(TAG, 6, "handleFlow_DataUpdate:getDiffData error.");
                    SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1006);
                }
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:getDiffData cost " + (System.currentTimeMillis() - startTime) + " ms.");
                }
                if (SonicUtils.needRefreshWebView(cacheOffline)) {
                    if (SonicUtils.shouldLog(4)) {
                        SonicUtils.log(TAG, 4, "handleFlow_DataUpdate:loadData was invoked, quick notify web data update.");
                    }
                    Message msg = this.mainHandler.obtainMessage(1);
                    msg.arg2 = 200;
                    msg.arg1 = 200;
                    msg.setData(diffDataBundle);
                    this.mainHandler.sendMessage(msg);
                }
                startTime = System.currentTimeMillis();
                String htmlSha1 = serverRspJson.optString("html-sha1");
                String htmlString = SonicUtils.buildHtml(this.id, serverDataJson, htmlSha1, serverRsp.length());
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "handleFlow_DataUpdate:buildHtml cost " + (System.currentTimeMillis() - startTime) + " ms.");
                }
                if (!TextUtils.isEmpty((CharSequence)htmlString) && !this.wasInterceptInvoked.get() && SonicUtils.needRefreshWebView(cacheOffline)) {
                    Object object = this.webResponseLock;
                    synchronized (object) {
                        this.pendingWebResourceStream = new ByteArrayInputStream(htmlString.getBytes());
                    }
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate:oh yeah, dataUpdate load hit 304.");
                    this.mainHandler.removeMessages(1);
                    Message msg = this.mainHandler.obtainMessage(1);
                    msg.arg1 = 200;
                    msg.arg2 = 304;
                    this.mainHandler.sendMessage(msg);
                }
                if (TextUtils.isEmpty((CharSequence)htmlString)) {
                    SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1008);
                }
                if (null == diffDataJson || null == htmlString || !SonicUtils.needSaveData(cacheOffline)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: clean session cache.");
                    SonicUtils.removeSessionCache(this.id);
                }
                this.switchState(1, 2, true);
                Thread.yield();
                startTime = System.currentTimeMillis();
                if (SonicUtils.saveSessionFiles(this.id, htmlString, null, serverDataJson.toString())) {
                    long htmlSize = new File(SonicFileUtils.getSonicHtmlPath(this.id)).length();
                    SonicUtils.saveSonicData(this.id, eTag, templateTag, htmlSha1, htmlSize, cspContent, cspReportOnlyContent);
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_DataUpdate: finish save session cache, cost " + (System.currentTimeMillis() - startTime) + " ms.");
                } else {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate: save session files fail.");
                    SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1004);
                }
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate error:" + e.getMessage());
            }
            finally {
                try {
                    output.close();
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_DataUpdate close output stream error:" + e.getMessage());
                }
            }
        }
    }
}

