/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.annotation.TargetApi;
import android.net.Uri;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import java.io.File;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class SonicUtils {
    private static final String TAG = "SonicSdk_SonicUtils";
    private static final String SONIC_TAG_TITLE_OPEN = "<title>";
    private static final String SONIC_TAG_TITLE_CLOSE = "</title>";
    private static final String SONIC_TAG_TITLE_KEY = "{title}";
    private static final String SONIC_TAG_PATTERN = "<!--sonicdiff-?(\\w*)-->([\\s\\S]+?)<!--sonicdiff-?(\\w*)-end-->";
    private static final String SONIC_TAG_DIFF_BEGIN = "<!--sonicdiff-";
    private static final String SONIC_TAG_DIFF_END = "-->";
    private static final String SONIC_TAG_KEY_BEGIN = "{";
    private static final String SONIC_TAG_KEY_END = "}";
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    SonicUtils() {
    }

    static boolean shouldLog(int level) {
        return SonicEngine.getInstance().getRuntime().shouldLog(level);
    }

    static void log(String tag, int level, String message) {
        SonicEngine.getInstance().getRuntime().log(tag, level, message);
    }

    @TargetApi(value=9)
    static void saveSonicData(String sessionId, String eTag, String templateTag, String htmlSha1, long htmlSize, String cspContent, String cspReportOnlyContent) {
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "saveSonicData sessionId = " + sessionId + ", eTag = " + eTag + ", templateTag = " + templateTag + ",htmlSha1 = " + htmlSha1 + ", htmlSize = " + htmlSize);
        }
        SonicDataHelper.SessionData sessionData = new SonicDataHelper.SessionData();
        sessionData.etag = eTag;
        sessionData.templateTag = templateTag;
        sessionData.htmlSha1 = htmlSha1;
        sessionData.htmlSize = htmlSize;
        sessionData.templateUpdateTime = System.currentTimeMillis();
        sessionData.cspContent = cspContent;
        sessionData.cspReportOnlyContent = cspReportOnlyContent;
        SonicDataHelper.saveSessionData(sessionId, sessionData);
    }

    static JSONObject getDiffData(String sessionId, JSONObject serverDataJson) {
        JSONObject diffData;
        try {
            String localDataString = SonicFileUtils.readFile(new File(SonicFileUtils.getSonicDataPath(sessionId)));
            if (!TextUtils.isEmpty((CharSequence)localDataString)) {
                JSONObject localDataJson = new JSONObject(localDataString);
                diffData = SonicUtils.getDiffData(localDataJson, serverDataJson);
            } else {
                diffData = serverDataJson;
            }
            if (diffData != null && diffData.length() > 0) {
                diffData.put("local_refresh_time", System.currentTimeMillis());
            }
        }
        catch (Throwable e) {
            diffData = null;
            SonicUtils.log(TAG, 6, "getDiffData error1:" + e.getMessage());
        }
        return diffData;
    }

    static JSONObject getDiffData(JSONObject localDataJson, JSONObject serverDataJson) {
        if (localDataJson == null || serverDataJson == null) {
            return null;
        }
        JSONObject diffData = new JSONObject();
        try {
            Iterator iterator = serverDataJson.keys();
            while (iterator.hasNext()) {
                String localData;
                String key = iterator.next().toString();
                String serverData = serverDataJson.optString(key);
                if (serverData.equals(localData = localDataJson.optString(key))) continue;
                diffData.put(key, (Object)serverData);
                if (!SonicUtils.shouldLog(3)) continue;
                SonicUtils.log(TAG, 3, "getDiffData:find diff data, key ->" + key + ", length=" + serverData.length() + ".");
            }
        }
        catch (Throwable e) {
            diffData = null;
            SonicUtils.log(TAG, 6, "getDiffData error2:" + e.getMessage());
        }
        return diffData;
    }

    static String buildHtml(final String sessionId, JSONObject dataJson, String sha1, int dataMaxSize) {
        File templateFile = new File(SonicFileUtils.getSonicTemplatePath(sessionId));
        if (templateFile.exists()) {
            String templateString = SonicFileUtils.readFile(templateFile);
            if (!TextUtils.isEmpty((CharSequence)templateString)) {
                final String htmlString = SonicUtils.buildHtml(templateString, dataJson, dataMaxSize);
                if (TextUtils.isEmpty((CharSequence)sha1) || sha1.equalsIgnoreCase(SonicUtils.getSHA1(htmlString))) {
                    return htmlString;
                }
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        String path = SonicFileUtils.getSonicHtmlPath(sessionId) + ".tmp";
                        SonicFileUtils.writeFile(htmlString, path);
                    }
                }, 0L);
                SonicUtils.log(TAG, 6, "buildHtml error: verify sha1 error.");
                return null;
            }
            SonicUtils.log(TAG, 6, "buildHtml error: template string is empty.");
        } else {
            SonicUtils.log(TAG, 6, "buildHtml error: template file is not exists.");
        }
        return null;
    }

    static String buildHtml(String templateString, JSONObject dataJson, int dataMaxSize) {
        if (TextUtils.isEmpty((CharSequence)templateString) || dataJson == null) {
            return null;
        }
        StringBuilder htmlStringBuilder = new StringBuilder(templateString.length() + dataMaxSize);
        htmlStringBuilder.append(templateString);
        Iterator iterator = dataJson.keys();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            String data = dataJson.optString(key);
            int index = htmlStringBuilder.indexOf(key);
            if (-1 == index) continue;
            htmlStringBuilder.replace(index, index + key.length(), data);
        }
        return htmlStringBuilder.toString();
    }

    static boolean saveSessionFiles(String sessionId, String htmlString, String templateString, String dataString) {
        if (!TextUtils.isEmpty((CharSequence)htmlString) && !SonicFileUtils.writeFile(htmlString, SonicFileUtils.getSonicHtmlPath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write html file fail.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)templateString) && !SonicFileUtils.writeFile(templateString, SonicFileUtils.getSonicTemplatePath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write template file fail.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)dataString) && !SonicFileUtils.writeFile(dataString, SonicFileUtils.getSonicDataPath(sessionId))) {
            SonicUtils.log(TAG, 6, "saveSessionData error: write data file fail.");
            return false;
        }
        return true;
    }

    static boolean separateTemplateAndData(String sessionId, String htmlString, StringBuilder templateStringBuilder, StringBuilder dataStringBuilder) {
        long startTime = System.currentTimeMillis();
        SonicUtils.log(TAG, 4, "separateTemplateAndData:sessionId(" + sessionId + ") start, htmlString = " + (htmlString.length() > 128 ? htmlString.substring(0, 128) : htmlString));
        JSONObject info = new JSONObject();
        int lastEnd = 0;
        try {
            Pattern pattern = Pattern.compile(SONIC_TAG_PATTERN, 8);
            Matcher matcher = pattern.matcher(htmlString);
            while (matcher.find()) {
                String dataInfo = matcher.group();
                String dataMark = SONIC_TAG_DIFF_BEGIN;
                int markLen = dataMark.length();
                int keyStart = dataInfo.indexOf(dataMark);
                int keyEnd = dataInfo.indexOf(SONIC_TAG_DIFF_END);
                String key = null;
                if (keyStart != -1 && keyStart + markLen < keyEnd) {
                    key = dataInfo.substring(keyStart + markLen, keyEnd);
                }
                key = SONIC_TAG_KEY_BEGIN + key + SONIC_TAG_KEY_END;
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "separateTemplateAndData:sessionId(" + sessionId + "), key = " + key);
                }
                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)dataInfo)) continue;
                info.put(key, (Object)dataInfo);
                int start = matcher.start();
                templateStringBuilder.append(htmlString.substring(lastEnd, start));
                templateStringBuilder.append(key);
                lastEnd = matcher.end();
            }
            if (lastEnd < htmlString.length() && templateStringBuilder.length() > 0) {
                templateStringBuilder.append(htmlString.substring(lastEnd, htmlString.length()));
            }
            int titleStart = templateStringBuilder.indexOf(SONIC_TAG_TITLE_OPEN);
            int titleEnd = templateStringBuilder.indexOf(SONIC_TAG_TITLE_CLOSE, titleStart + SONIC_TAG_TITLE_OPEN.length()) + SONIC_TAG_TITLE_CLOSE.length();
            if (titleStart != -1 && titleStart < titleEnd) {
                String key = SONIC_TAG_TITLE_KEY;
                info.put(key, (Object)templateStringBuilder.substring(titleStart, titleEnd));
                templateStringBuilder.replace(titleStart, titleEnd, key);
            }
            dataStringBuilder.append(info.toString());
        }
        catch (Exception e) {
            SonicUtils.log(TAG, 6, "separateTemplateAndData:sessionId(" + sessionId + ") error:" + e.getMessage());
            return false;
        }
        SonicUtils.log(TAG, 4, "separateTemplateAndData:sessionId(" + sessionId + ") end, cost " + (System.currentTimeMillis() - startTime) + "ms.");
        return true;
    }

    static void removeSessionCache(String sessionId) {
        SonicDataHelper.removeSessionData(sessionId);
        SonicFileUtils.deleteSonicFiles(sessionId);
    }

    static boolean removeAllSessionCache() {
        File cacheRootDir = new File(SonicFileUtils.getSonicCacheDirPath());
        if (cacheRootDir.exists()) {
            SonicDataHelper.clear();
            return SonicFileUtils.deleteAllChildFiles(cacheRootDir);
        }
        return false;
    }

    static boolean needSaveData(String cacheOffline) {
        return !TextUtils.isEmpty((CharSequence)cacheOffline) && ("store".equals(cacheOffline) || "true".equals(cacheOffline));
    }

    static boolean needRefreshWebView(String cacheOffline) {
        return !TextUtils.isEmpty((CharSequence)cacheOffline) && ("false".equals(cacheOffline) || "true".equals(cacheOffline));
    }

    static String addSonicUrlParam(String url, String paramKey, String paramValue) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            StringBuilder stringBuilder = new StringBuilder(url);
            int paramStartIndex = stringBuilder.lastIndexOf("/");
            if (paramStartIndex < 0) {
                paramStartIndex = 0;
            }
            String paramKeyPattern1 = "&" + paramKey + "=";
            String paramKeyPattern2 = "?" + paramKey + "=";
            int paramKeyPattern = paramKeyPattern1.length();
            try {
                while (true) {
                    int paramKeyIndex;
                    if (-1 == (paramKeyIndex = stringBuilder.indexOf(paramKeyPattern1, paramStartIndex))) {
                        paramKeyIndex = stringBuilder.indexOf(paramKeyPattern2, paramStartIndex);
                    }
                    if (paramKeyIndex > 0) {
                        int nextParamStartIndex = stringBuilder.indexOf("&", paramKeyIndex + paramKeyPattern);
                        if (nextParamStartIndex > 0) {
                            stringBuilder.replace(paramKeyIndex + 1, nextParamStartIndex + 1, "");
                            continue;
                        }
                        stringBuilder.replace(paramKeyIndex, stringBuilder.length(), "");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "addSonicUrlParam error:" + e.getMessage());
                return url;
            }
            if (-1 != stringBuilder.indexOf("?")) {
                stringBuilder.append("&").append(paramKey).append("=").append(paramValue);
            } else {
                stringBuilder.append("?").append(paramKey).append("=").append(paramValue);
            }
            return stringBuilder.toString();
        }
        return url;
    }

    static String getMime(String url) {
        String mime = "text/html";
        Uri currentUri = Uri.parse((String)url);
        String path = currentUri.getPath();
        if (path.contains(".css")) {
            mime = "text/css";
        } else if (path.contains(".js")) {
            mime = "application/x-javascript";
        } else if (path.contains(".jpg") || path.contains(".gif") || path.contains(".png") || path.contains(".jpeg")) {
            mime = "image/*";
        }
        return mime;
    }

    static String getSHA1(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] bytes = content.getBytes();
            sha1.update(bytes, 0, bytes.length);
            return SonicUtils.toHexString(sha1.digest());
        }
        catch (Exception e) {
            return "";
        }
    }

    static String getMD5(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance("MD5");
            sha1.update(content.getBytes(), 0, content.getBytes().length);
            return SonicUtils.toHexString(sha1.digest());
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte aB : b) {
            sb.append(hexChar[(aB & 0xF0) >>> 4]);
            sb.append(hexChar[aB & 0xF]);
        }
        return sb.toString();
    }
}

