/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Intent;
import android.os.Looper;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicSniSSLSocketFactory;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public abstract class SonicSessionConnection {
    private static final String TAG = "SonicSdk_SonicSessionConnection";
    public static final String CUSTOM_HEAD_FILED_ETAG = "etag";
    private static final String CUSTOM_HEAD_FILED_ACCEPT_DIFF = "accept-diff";
    public static final String CUSTOM_HEAD_FILED_TEMPLATE_TAG = "template-tag";
    public static final String CUSTOM_HEAD_FILED_TEMPLATE_CHANGE = "template-change";
    public static final String CUSTOM_HEAD_FILED_CACHE_OFFLINE = "cache-offline";
    public static final String DNS_PREFETCH_ADDRESS = "dns-prefetch-address";
    private static final String CUSTOM_HEAD_FILED_SDK_VERSION = "sonic-sdk-version";
    public static final String CUSTOM_HEAD_FILED_DNS_PREFETCH = "sonic-dns-prefetch";
    public static final String HTTP_HEAD_CSP = "Content-Security-Policy";
    public static final String HTTP_HEAD_CSP_REPORT_ONLY = "Content-Security-Policy-Report-Only";
    public static final String HTTP_HEAD_FILED_SET_COOKIE = "Set-Cookie";
    protected final SonicSession session;
    protected final Intent intent;
    protected BufferedInputStream responseStream;

    public SonicSessionConnection(SonicSession session, Intent intent) {
        this.session = session;
        this.intent = intent != null ? intent : new Intent();
    }

    public synchronized int connect() {
        return this.internalConnect();
    }

    public abstract void disconnect();

    public abstract int getResponseCode();

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public abstract String getResponseHeaderField(String var1);

    public synchronized BufferedInputStream getResponseStream() {
        if (this.responseStream == null) {
            this.responseStream = this.internalGetResponseStream();
        }
        return this.responseStream;
    }

    public synchronized ByteArrayOutputStream getResponseData() {
        BufferedInputStream responseStream = this.getResponseStream();
        if (null != responseStream) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[this.session.config.READ_BUF_SIZE];
            try {
                int n;
                while (-1 != (n = responseStream.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                return outputStream;
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "getResponseData error:" + e.getMessage() + ".");
            }
        }
        return null;
    }

    public synchronized ResponseDataTuple getResponseData(AtomicBoolean breakCondition, ByteArrayOutputStream outputStream) {
        BufferedInputStream responseStream = this.getResponseStream();
        if (null != responseStream) {
            if (null == outputStream) {
                outputStream = new ByteArrayOutputStream();
            }
            byte[] buffer = new byte[this.session.config.READ_BUF_SIZE];
            try {
                int n = 0;
                while (!breakCondition.get() && -1 != (n = responseStream.read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
                ResponseDataTuple responseDataTuple = new ResponseDataTuple();
                responseDataTuple.responseStream = responseStream;
                responseDataTuple.outputStream = outputStream;
                responseDataTuple.isComplete = -1 == n;
                return responseDataTuple;
            }
            catch (Throwable e) {
                SonicUtils.log(TAG, 6, "getResponseData error:" + e.getMessage() + ".");
            }
        }
        return null;
    }

    protected abstract int internalConnect();

    protected abstract BufferedInputStream internalGetResponseStream();

    public static class SessionConnectionDefaultImpl
    extends SonicSessionConnection {
        private URLConnection connectionImpl;

        public SessionConnectionDefaultImpl(SonicSession session, Intent intent) {
            super(session, intent);
        }

        private URLConnection createConnection() {
            String currentUrl = this.session.currUrl;
            if (TextUtils.isEmpty((CharSequence)currentUrl)) {
                return null;
            }
            URLConnection connection = null;
            try {
                URL url = new URL(currentUrl);
                String dnsPrefetchAddress = this.intent.getStringExtra(SonicSessionConnection.DNS_PREFETCH_ADDRESS);
                String originHost = null;
                if (!TextUtils.isEmpty((CharSequence)dnsPrefetchAddress)) {
                    originHost = url.getHost();
                    url = new URL(currentUrl.replace(originHost, dnsPrefetchAddress));
                    SonicUtils.log(SonicSessionConnection.TAG, 4, "create UrlConnection with DNS-Prefetch(" + originHost + " -> " + dnsPrefetchAddress + ").");
                }
                if ((connection = url.openConnection()) != null) {
                    if (connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                    }
                    if (!TextUtils.isEmpty((CharSequence)originHost)) {
                        connection.setRequestProperty("Host", originHost);
                        connection.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_DNS_PREFETCH, url.getHost());
                        if (connection instanceof HttpsURLConnection) {
                            final String finalOriginHost = originHost;
                            final URL finalUrl = url;
                            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                            httpsConnection.setSSLSocketFactory(new SonicSniSSLSocketFactory(SonicEngine.getInstance().getRuntime().getContext(), originHost));
                            httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    boolean verifySuccess = false;
                                    long startTime = System.currentTimeMillis();
                                    if (finalUrl.getHost().equals(hostname)) {
                                        verifySuccess = HttpsURLConnection.getDefaultHostnameVerifier().verify(finalOriginHost, session);
                                        SonicUtils.log(SonicSessionConnection.TAG, 3, "verify hostname cost " + (System.currentTimeMillis() - startTime) + " ms.");
                                    }
                                    return verifySuccess;
                                }
                            });
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (connection != null) {
                    connection = null;
                }
                SonicUtils.log(SonicSessionConnection.TAG, 6, "create UrlConnection fail, error:" + e.getMessage() + ".");
            }
            return connection;
        }

        private URLConnection getConnection() {
            if (null == this.connectionImpl) {
                this.connectionImpl = this.createConnection();
                if (null != this.connectionImpl) {
                    String currentUrl = this.session.srcUrl;
                    SonicSessionConfig config = this.session.config;
                    this.connectionImpl.setConnectTimeout(config.CONNECT_TIMEOUT_MILLIS);
                    this.connectionImpl.setReadTimeout(config.READ_TIMEOUT_MILLIS);
                    this.connectionImpl.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_ACCEPT_DIFF, config.ACCEPT_DIFF_DATA ? "true" : "false");
                    String eTag = this.intent.getStringExtra(SonicSessionConnection.CUSTOM_HEAD_FILED_ETAG);
                    if (null == eTag) {
                        eTag = "";
                    }
                    this.connectionImpl.setRequestProperty("If-None-Match", eTag);
                    String templateTag = this.intent.getStringExtra(SonicSessionConnection.CUSTOM_HEAD_FILED_TEMPLATE_TAG);
                    if (null == templateTag) {
                        templateTag = "";
                    }
                    this.connectionImpl.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_TEMPLATE_TAG, templateTag);
                    this.connectionImpl.setRequestProperty("method", "GET");
                    this.connectionImpl.setRequestProperty("accept-Charset", "utf-8");
                    this.connectionImpl.setRequestProperty("accept-Encoding", "gzip");
                    this.connectionImpl.setRequestProperty("accept-Language", "zh-CN,zh;");
                    this.connectionImpl.setRequestProperty(SonicSessionConnection.CUSTOM_HEAD_FILED_SDK_VERSION, "Sonic/1.0.1");
                    SonicRuntime runtime = SonicEngine.getInstance().getRuntime();
                    String cookie = runtime.getCookie(currentUrl);
                    if (!TextUtils.isEmpty((CharSequence)cookie)) {
                        this.connectionImpl.setRequestProperty("cookie", cookie);
                    } else {
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "create UrlConnection cookie is empty");
                    }
                    String userAgent = runtime.getUserAgent();
                    userAgent = !TextUtils.isEmpty((CharSequence)userAgent) ? userAgent + " Sonic/1.0.1" : "Sonic/1.0.1";
                    this.connectionImpl.setRequestProperty("User-Agent", userAgent);
                }
            }
            return this.connectionImpl;
        }

        @Override
        protected synchronized int internalConnect() {
            block6: {
                URLConnection urlConnection = this.getConnection();
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    try {
                        httpURLConnection.connect();
                        return 0;
                    }
                    catch (Throwable e) {
                        String errMsg = e.getMessage();
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "connect error:" + errMsg);
                        if (e instanceof IOException) {
                            if (e instanceof SocketTimeoutException) {
                                return -902;
                            }
                            if (!TextUtils.isEmpty((CharSequence)errMsg) && errMsg.contains("timeoutexception")) {
                                return -902;
                            }
                            return -901;
                        }
                        if (!(e instanceof NullPointerException)) break block6;
                        return -903;
                    }
                }
            }
            return -1;
        }

        @Override
        public void disconnect() {
            if (this.connectionImpl instanceof HttpURLConnection) {
                final HttpURLConnection httpURLConnection = (HttpURLConnection)this.connectionImpl;
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                httpURLConnection.disconnect();
                            }
                            catch (Throwable e) {
                                SonicUtils.log(SonicSessionConnection.TAG, 6, "disconnect error:" + e.getMessage());
                            }
                        }
                    }, 0L);
                } else {
                    try {
                        httpURLConnection.disconnect();
                    }
                    catch (Exception e) {
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "disconnect error:" + e.getMessage());
                    }
                }
            }
        }

        @Override
        protected BufferedInputStream internalGetResponseStream() {
            if (null == this.responseStream && null != this.connectionImpl) {
                try {
                    InputStream inputStream = this.connectionImpl.getInputStream();
                    this.responseStream = "gzip".equalsIgnoreCase(this.connectionImpl.getContentEncoding()) ? new BufferedInputStream(new GZIPInputStream(inputStream)) : new BufferedInputStream(inputStream);
                }
                catch (Throwable e) {
                    SonicUtils.log(SonicSessionConnection.TAG, 6, "getResponseStream error:" + e.getMessage() + ".");
                }
            }
            return this.responseStream;
        }

        @Override
        public int getResponseCode() {
            block6: {
                if (this.connectionImpl instanceof HttpURLConnection) {
                    try {
                        return ((HttpURLConnection)this.connectionImpl).getResponseCode();
                    }
                    catch (Throwable e) {
                        String errMsg = e.getMessage();
                        SonicUtils.log(SonicSessionConnection.TAG, 6, "getResponseCode error:" + errMsg);
                        if (e instanceof IOException) {
                            if (e instanceof SocketTimeoutException) {
                                return -902;
                            }
                            if (!TextUtils.isEmpty((CharSequence)errMsg) && errMsg.contains("timeoutexception")) {
                                return -902;
                            }
                            return -901;
                        }
                        if (!(e instanceof NullPointerException)) break block6;
                        return -903;
                    }
                }
            }
            return -1;
        }

        @Override
        public Map<String, List<String>> getResponseHeaderFields() {
            if (null != this.connectionImpl) {
                return this.connectionImpl.getHeaderFields();
            }
            return null;
        }

        @Override
        public String getResponseHeaderField(String key) {
            if (null != this.connectionImpl) {
                return this.connectionImpl.getHeaderField(key);
            }
            return null;
        }
    }

    public class ResponseDataTuple {
        boolean isComplete;
        BufferedInputStream responseStream;
        ByteArrayOutputStream outputStream;
    }
}

