/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicCacheInterceptor;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicDiffDataCallback;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicHeadersProvider;
import com.tencent.sonic.sdk.SonicRuntime;
import com.tencent.sonic.sdk.SonicSessionClient;
import com.tencent.sonic.sdk.SonicSessionConfig;
import com.tencent.sonic.sdk.SonicSessionConnection;
import com.tencent.sonic.sdk.SonicSessionConnectionInterceptor;
import com.tencent.sonic.sdk.SonicSessionStatistics;
import com.tencent.sonic.sdk.SonicSessionStream;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class SonicSession
implements SonicSessionStream.Callback,
Handler.Callback {
    public static final String TAG = "SonicSdk_SonicSession";
    public static final String WEB_RESPONSE_SRC_CODE = "srcCode";
    public static final String WEB_RESPONSE_CODE = "code";
    public static final String WEB_RESPONSE_DATA = "result";
    public static final String SONIC_URL_PARAM_SESSION_ID = "_sonic_id";
    public static final String DATA_UPDATE_BUNDLE_PARAMS_DIFF = "_diff_data_";
    public static final String WEB_RESPONSE_LOCAL_REFRESH_TIME = "local_refresh_time";
    public static final String CHROME_FILE_THREAD = "Chrome_FileThread";
    public static final int STATE_NONE = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROY = 3;
    public static final String OFFLINE_MODE_HTTP = "http";
    public static final String OFFLINE_MODE_STORE = "store";
    public static final String OFFLINE_MODE_TRUE = "true";
    public static final String OFFLINE_MODE_FALSE = "false";
    public static final int SONIC_RESULT_CODE_UNKNOWN = -1;
    public static final int SONIC_RESULT_CODE_FIRST_LOAD = 1000;
    public static final int SONIC_RESULT_CODE_TEMPLATE_CHANGE = 2000;
    public static final int SONIC_RESULT_CODE_DATA_UPDATE = 200;
    public static final int SONIC_RESULT_CODE_HIT_CACHE = 304;
    protected int srcResultCode = -1;
    protected int finalResultCode = -1;
    protected static final int COMMON_MSG_BEGIN = 0;
    protected static final int CLIENT_MSG_NOTIFY_RESULT = 1;
    protected static final int CLIENT_MSG_ON_WEB_READY = 2;
    protected static final int SESSION_MSG_FORCE_DESTROY = 3;
    protected static final int COMMON_MSG_END = 4;
    protected static final int RESOURCE_INTERCEPT_STATE_NONE = 0;
    protected static final int RESOURCE_INTERCEPT_STATE_IN_FILE_THREAD = 1;
    protected static final int RESOURCE_INTERCEPT_STATE_IN_OTHER_THREAD = 2;
    protected final AtomicInteger sessionState = new AtomicInteger(0);
    protected final AtomicBoolean wasInterceptInvoked = new AtomicBoolean(false);
    protected final AtomicBoolean clientIsReady = new AtomicBoolean(false);
    private final AtomicBoolean wasNotified = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForSaveFile = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForDestroy = new AtomicBoolean(false);
    protected final AtomicBoolean isWaitingForSessionThread = new AtomicBoolean(false);
    protected final AtomicBoolean wasOnPageFinishInvoked = new AtomicBoolean(false);
    protected final AtomicInteger resourceInterceptState = new AtomicInteger(0);
    protected final SonicSessionStatistics statistics = new SonicSessionStatistics();
    protected volatile SonicSessionConnection sessionConnection;
    protected volatile InputStream pendingWebResourceStream;
    protected String pendingDiffData = "";
    protected static long sNextSessionLogId = new Random().nextInt(263167);
    public final SonicSessionConfig config;
    public final String id;
    protected boolean isPreload;
    public long createdTime;
    public final long sId;
    public String srcUrl;
    protected volatile SonicSessionClient sessionClient;
    protected String currUrl;
    protected final Handler mainHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    protected final CopyOnWriteArrayList<WeakReference<Callback>> callbackWeakRefList = new CopyOnWriteArrayList();
    protected SonicDiffDataCallback diffDataCallback;

    public boolean handleMessage(Message msg) {
        if (3 == msg.what) {
            this.destroy(true);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleMessage:force destroy.");
            return true;
        }
        if (this.isDestroyedOrWaitingForDestroy()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleMessage error: is destroyed or waiting for destroy.");
            return true;
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") handleMessage: msg what = " + msg.what + ".");
        }
        return false;
    }

    SonicSession(String id, String url, SonicSessionConfig config) {
        this.id = id;
        this.config = config;
        this.sId = sNextSessionLogId++;
        this.statistics.srcUrl = url.trim();
        this.currUrl = this.srcUrl = SonicUtils.addSonicUrlParam(this.statistics.srcUrl, SONIC_URL_PARAM_SESSION_ID, String.valueOf(this.sId));
        this.createdTime = System.currentTimeMillis();
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") create:id=" + id + ", url = " + url + ".");
        }
    }

    public void start() {
        if (!this.sessionState.compareAndSet(0, 1)) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") start error:sessionState=" + this.sessionState.get() + ".");
            return;
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") now post sonic flow task.");
        this.statistics.sonicStartTime = System.currentTimeMillis();
        this.isWaitingForSessionThread.set(true);
        SonicEngine.getInstance().getRuntime().postTaskToSessionThread(new Runnable(){

            @Override
            public void run() {
                SonicSession.this.runSonicFlow();
            }
        });
        this.notifyStateChange(0, 1, null);
    }

    private void runSonicFlow() {
        if (1 != this.sessionState.get()) {
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") runSonicFlow error:sessionState=" + this.sessionState.get() + ".");
            return;
        }
        this.statistics.sonicFlowStartTime = System.currentTimeMillis();
        String htmlString = SonicCacheInterceptor.getSonicCacheData(this);
        boolean hasHtmlCache = !TextUtils.isEmpty((CharSequence)htmlString);
        this.statistics.cacheVerifyTime = System.currentTimeMillis();
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") runSonicFlow verify cache cost " + (this.statistics.cacheVerifyTime - this.statistics.sonicFlowStartTime) + " ms");
        this.handleLocalHtml(htmlString);
        final SonicRuntime runtime = SonicEngine.getInstance().getRuntime();
        if (!runtime.isNetworkValid()) {
            if (hasHtmlCache && !TextUtils.isEmpty((CharSequence)this.config.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST)) {
                runtime.postTaskToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (SonicSession.this.clientIsReady.get() && !SonicSession.this.isDestroyedOrWaitingForDestroy()) {
                            runtime.showToast(SonicSession.this.config.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST, 1);
                        }
                    }
                }, 1500L);
            }
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") runSonicFlow error:network is not valid!");
        } else {
            this.handleFlow_Connection(htmlString);
            this.statistics.connectionFlowFinishTime = System.currentTimeMillis();
        }
        this.switchState(1, 2, true);
        this.isWaitingForSessionThread.set(false);
        if (this.postForceDestroyIfNeed()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") runSonicFlow:send force destroy message.");
        }
    }

    protected void handleFlow_Connection(String htmlString) {
        this.statistics.connectionFlowStartTime = System.currentTimeMillis();
        SonicDataHelper.SessionData sessionData = SonicDataHelper.getSessionData(this.id);
        Intent intent = new Intent();
        intent.putExtra("etag", sessionData.etag);
        intent.putExtra("template-tag", sessionData.templateTag);
        String hostDirectAddress = SonicEngine.getInstance().getRuntime().getHostDirectAddress(this.srcUrl);
        if (!TextUtils.isEmpty((CharSequence)hostDirectAddress)) {
            this.statistics.isDirectAddress = true;
        }
        intent.putExtra("dns-prefetch-address", hostDirectAddress);
        this.sessionConnection = SonicSessionConnectionInterceptor.getSonicSessionConnection(this, intent);
        long startTime = System.currentTimeMillis();
        int responseCode = this.sessionConnection.connect();
        if (0 == responseCode) {
            this.statistics.connectionConnectTime = System.currentTimeMillis();
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") connection connect cost = " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            startTime = System.currentTimeMillis();
            responseCode = this.sessionConnection.getResponseCode();
            this.statistics.connectionRespondTime = System.currentTimeMillis();
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") connection response cost = " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            startTime = System.currentTimeMillis();
            Map<String, List<String>> headerFieldsMap = this.sessionConnection.getResponseHeaderFields();
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "session(" + this.sId + ") connection get header fields cost = " + (System.currentTimeMillis() - startTime) + " ms.");
            }
            this.setCookiesFromHeaders(headerFieldsMap, this.shouldSetCookieAsynchronous());
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection: respCode = " + responseCode + ", cost " + (System.currentTimeMillis() - this.statistics.connectionFlowStartTime) + " ms.");
        if (this.isDestroyedOrWaitingForDestroy()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection: destroy before server response.");
            return;
        }
        if (304 == responseCode) {
            this.handleFlow_304();
            return;
        }
        if (200 != responseCode) {
            this.handleFlow_HttpError(responseCode);
            SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, responseCode);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection: response code not 200, response code = " + responseCode);
            return;
        }
        String cacheOffline = this.sessionConnection.getResponseHeaderField("cache-offline");
        if (OFFLINE_MODE_HTTP.equals(cacheOffline)) {
            if (!TextUtils.isEmpty((CharSequence)htmlString)) {
                SonicUtils.removeSessionCache(this.id);
            }
            long unavailableTime = System.currentTimeMillis() + SonicEngine.getInstance().getConfig().SONIC_UNAVAILABLE_TIME;
            SonicDataHelper.setSonicUnavailableTime(this.id, unavailableTime);
            this.handleFlow_ServiceUnavailable();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)htmlString)) {
            this.handleFlow_FirstLoad();
        } else {
            String templateChange = this.sessionConnection.getResponseHeaderField("template-change");
            if (SonicUtils.shouldLog(4)) {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection:templateChange = " + templateChange);
            }
            if (!TextUtils.isEmpty((CharSequence)templateChange)) {
                if (OFFLINE_MODE_FALSE.equals(templateChange) || "0".equals(templateChange)) {
                    this.handleFlow_DataUpdate();
                } else {
                    this.handleFlow_TemplateChange();
                }
            } else {
                String templateTag = this.sessionConnection.getResponseHeaderField("template-tag");
                if (!TextUtils.isEmpty((CharSequence)templateTag) && !templateTag.equals(sessionData.templateTag)) {
                    SonicUtils.log(TAG, 4, "session(" + this.sId + ") handleFlow_Connection:no templateChange field but template-tag has changed.");
                    this.handleFlow_TemplateChange();
                } else {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") handleFlow_Connection:no templateChange field and template-tag is " + templateTag + ".");
                    SonicUtils.removeSessionCache(this.id);
                    SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1007);
                }
            }
        }
        this.saveHeaders(this.sessionConnection);
    }

    protected void handleLocalHtml(String localHtml) {
    }

    protected void handleFlow_304() {
    }

    protected void handleFlow_HttpError(int responseCode) {
    }

    protected void handleFlow_ServiceUnavailable() {
    }

    protected void handleFlow_FirstLoad() {
    }

    protected void handleFlow_DataUpdate() {
    }

    protected void handleFlow_TemplateChange() {
    }

    void setIsPreload(String url) {
        this.isPreload = true;
        this.statistics.srcUrl = url.trim();
        this.currUrl = this.srcUrl = SonicUtils.addSonicUrlParam(this.statistics.srcUrl, SONIC_URL_PARAM_SESSION_ID, String.valueOf(this.sId));
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") is preload, new url=" + url + ".");
        }
    }

    public boolean isPreload() {
        return this.isPreload;
    }

    public SonicSessionStatistics getStatistics() {
        return this.statistics;
    }

    public boolean addCallback(Callback callback) {
        return this.callbackWeakRefList.add(new WeakReference<Callback>(callback));
    }

    public boolean removeCallback(Callback callback) {
        return this.callbackWeakRefList.remove(new WeakReference<Callback>(callback));
    }

    public String getCurrentUrl() {
        return this.currUrl;
    }

    public int getFinalResultCode() {
        return this.finalResultCode;
    }

    public int getSrcResultCode() {
        return this.srcResultCode;
    }

    protected boolean isDestroyedOrWaitingForDestroy() {
        return 3 == this.sessionState.get() || this.isWaitingForDestroy.get();
    }

    protected boolean postForceDestroyIfNeed() {
        if (this.isWaitingForDestroy.get() && this.canDestroy()) {
            this.mainHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    protected boolean canDestroy() {
        if (this.isWaitingForSessionThread.get() || this.isWaitingForSaveFile.get()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") canDestroy:false, isWaitingForSessionThread=" + this.isWaitingForDestroy.get() + ", isWaitingForSaveFile=" + this.isWaitingForSaveFile.get());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean switchState(int fromState, int toState, boolean notify) {
        if (this.sessionState.compareAndSet(fromState, toState)) {
            if (notify) {
                AtomicInteger atomicInteger = this.sessionState;
                synchronized (atomicInteger) {
                    this.sessionState.notify();
                }
            }
            this.notifyStateChange(fromState, toState, null);
            return true;
        }
        return false;
    }

    @Override
    public void onClose(boolean readComplete, final ByteArrayOutputStream outputStream) {
        if (null != this.pendingWebResourceStream) {
            this.pendingWebResourceStream = null;
        }
        this.isWaitingForSaveFile.set(true);
        long onCloseStartTime = System.currentTimeMillis();
        if (readComplete && null != outputStream) {
            String cacheOffline = this.sessionConnection.getResponseHeaderField("cache-offline");
            if (SonicUtils.needSaveData(cacheOffline)) {
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose:offline->" + cacheOffline + " , post separateAndSaveCache task.");
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        String htmlString;
                        if (SonicUtils.shouldLog(3)) {
                            SonicUtils.log(SonicSession.TAG, 3, "session(" + SonicSession.this.sId + ") onClose:cachedStream size:" + outputStream.size());
                        }
                        try {
                            htmlString = outputStream.toString("UTF-8");
                            outputStream.close();
                        }
                        catch (Throwable e) {
                            htmlString = null;
                            SonicUtils.log(SonicSession.TAG, 6, "session(" + SonicSession.this.sId + ") onClose error:" + e.getMessage());
                        }
                        if (!TextUtils.isEmpty((CharSequence)htmlString)) {
                            long startTime = System.currentTimeMillis();
                            SonicSession.this.separateAndSaveCache(htmlString);
                            SonicUtils.log(SonicSession.TAG, 4, "session(" + SonicSession.this.sId + ") onClose:separate And save ache finish, cost " + (System.currentTimeMillis() - startTime) + " ms.");
                        }
                        SonicSession.this.isWaitingForSaveFile.set(false);
                        if (SonicSession.this.postForceDestroyIfNeed()) {
                            SonicUtils.log(SonicSession.TAG, 4, "session(" + SonicSession.this.sId + ") onClose: postForceDestroyIfNeed send destroy message.");
                        }
                    }
                }, 3000L);
                return;
            }
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose:offline->" + cacheOffline + " , so do not need cache to file.");
        } else {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClose error:readComplete =" + readComplete + ", outputStream is null -> " + (outputStream == null));
        }
        this.isWaitingForSaveFile.set(false);
        if (this.postForceDestroyIfNeed()) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClose: postForceDestroyIfNeed send destroy message in chromium_io thread.");
        }
        if (SonicUtils.shouldLog(3)) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") onClose cost " + (System.currentTimeMillis() - onCloseStartTime) + " ms.");
        }
    }

    protected void separateAndSaveCache(String htmlString) {
        if (TextUtils.isEmpty((CharSequence)htmlString) || null == this.sessionConnection) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") separateAndSaveCache error:htmlString is null or sessionConnection is null.");
            return;
        }
        String eTag = this.sessionConnection.getResponseHeaderField("etag");
        String templateTag = this.sessionConnection.getResponseHeaderField("template-tag");
        String cspContent = this.sessionConnection.getResponseHeaderField("Content-Security-Policy");
        String cspReportOnlyContent = this.sessionConnection.getResponseHeaderField("Content-Security-Policy-Report-Only");
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") separateAndSaveCache: start separate, eTag = " + eTag + ", templateTag = " + templateTag);
        long startTime = System.currentTimeMillis();
        StringBuilder templateStringBuilder = new StringBuilder();
        StringBuilder dataStringBuilder = new StringBuilder();
        if (SonicUtils.separateTemplateAndData(this.id, htmlString, templateStringBuilder, dataStringBuilder)) {
            if (SonicUtils.saveSessionFiles(this.id, htmlString, templateStringBuilder.toString(), dataStringBuilder.toString())) {
                long htmlSize = new File(SonicFileUtils.getSonicHtmlPath(this.id)).length();
                SonicUtils.saveSonicData(this.id, eTag, templateTag, SonicUtils.getSHA1(htmlString), htmlSize, cspContent, cspReportOnlyContent);
            } else {
                SonicUtils.log(TAG, 6, "session(" + this.sId + ") separateAndSaveCache: save session files fail.");
                SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1004);
            }
        } else {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") separateAndSaveCache: save separate template and data files fail.");
            SonicEngine.getInstance().getRuntime().notifyError(this.sessionClient, this.srcUrl, -1005);
        }
        SonicUtils.log(TAG, 4, "session(" + this.sId + ") separateAndSaveCache: finish separate, cost " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    protected void notifyStateChange(int oldState, int newState, Bundle extraData) {
        for (WeakReference<Callback> callbackWeakRef : this.callbackWeakRefList) {
            Callback callback = (Callback)callbackWeakRef.get();
            if (null == callback) continue;
            callback.onSessionStateChange(this, oldState, newState, extraData);
        }
    }

    protected void setResult(int srcCode, int finalCode, boolean notify) {
        SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: srcCode=" + srcCode + ", finalCode=" + finalCode + ".");
        this.statistics.originalMode = this.srcResultCode = srcCode;
        this.statistics.finalMode = this.finalResultCode = finalCode;
        if (!notify) {
            return;
        }
        if (this.wasNotified.get()) {
            SonicUtils.log(TAG, 6, "session(" + this.sId + ")  setResult: notify error -> already has notified!");
        }
        if (null == this.diffDataCallback) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: notify fail as webCallback is not set, please wait!");
            return;
        }
        if (this.finalResultCode == -1) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ")  setResult: notify fail finalResultCode is not set, please wait!");
            return;
        }
        this.wasNotified.compareAndSet(false, true);
        JSONObject json = new JSONObject();
        try {
            if (this.finalResultCode == 200) {
                JSONObject pendingObject = new JSONObject(this.pendingDiffData);
                long timeDelta = System.currentTimeMillis() - pendingObject.optLong(WEB_RESPONSE_LOCAL_REFRESH_TIME, 0L);
                if (timeDelta > 30000L) {
                    SonicUtils.log(TAG, 6, "session(" + this.sId + ") setResult: notify fail as receive js call too late, " + (double)timeDelta / 1000.0 + " s.");
                    this.pendingDiffData = "";
                    return;
                }
                if (SonicUtils.shouldLog(3)) {
                    SonicUtils.log(TAG, 3, "session(" + this.sId + ") setResult: notify receive js call in time: " + (double)timeDelta / 1000.0 + " s.");
                }
                if (timeDelta > 0L) {
                    json.put(WEB_RESPONSE_LOCAL_REFRESH_TIME, timeDelta);
                }
                pendingObject.remove(WEB_RESPONSE_LOCAL_REFRESH_TIME);
                json.put(WEB_RESPONSE_DATA, (Object)pendingObject.toString());
            }
            json.put(WEB_RESPONSE_CODE, this.finalResultCode);
            json.put(WEB_RESPONSE_SRC_CODE, this.srcResultCode);
        }
        catch (Throwable e) {
            e.printStackTrace();
            SonicUtils.log(TAG, 6, "session(" + this.sId + ") setResult: notify error -> " + e.getMessage());
        }
        if (SonicUtils.shouldLog(3)) {
            String logStr = json.toString();
            if (logStr.length() > 512) {
                logStr = logStr.substring(0, 512);
            }
            SonicUtils.log(TAG, 3, "session(" + this.sId + ") setResult: notify now call jsCallback, jsonStr = " + logStr);
        }
        this.pendingDiffData = null;
        this.diffDataCallback.callback(json.toString());
    }

    public boolean bindClient(SonicSessionClient client) {
        if (null == this.sessionClient) {
            this.sessionClient = client;
            client.bindSession(this);
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") bind client.");
            return true;
        }
        return false;
    }

    public boolean onClientReady() {
        return false;
    }

    public final Object onClientRequestResource(String url) {
        String currentThreadName = Thread.currentThread().getName();
        if (CHROME_FILE_THREAD.equals(currentThreadName)) {
            this.resourceInterceptState.set(1);
        } else {
            this.resourceInterceptState.set(2);
            if (SonicUtils.shouldLog(3)) {
                SonicUtils.log(TAG, 3, "onClientRequestResource called in " + currentThreadName + ".");
            }
        }
        Object object = this.onRequestResource(url);
        this.resourceInterceptState.set(0);
        return object;
    }

    protected boolean shouldSetCookieAsynchronous() {
        return 2 == this.resourceInterceptState.get();
    }

    protected boolean setCookiesFromHeaders(Map<String, List<String>> headers, boolean executeInNewThread) {
        List<String> cookies;
        if (null != headers && null != (cookies = headers.get("Set-Cookie")) && 0 != cookies.size()) {
            if (!executeInNewThread) {
                return SonicEngine.getInstance().getRuntime().setCookie(this.getCurrentUrl(), cookies);
            }
            SonicUtils.log(TAG, 4, "setCookiesFromHeaders asynchronous in new thread.");
            SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                @Override
                public void run() {
                    SonicEngine.getInstance().getRuntime().setCookie(SonicSession.this.getCurrentUrl(), cookies);
                }
            }, 0L);
            return true;
        }
        return false;
    }

    protected Object onRequestResource(String url) {
        return null;
    }

    public boolean onWebReady(SonicDiffDataCallback diffDataCallback) {
        return false;
    }

    public boolean onClientPageFinished(String url) {
        if (this.isMatchCurrentUrl(url)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") onClientPageFinished:url=" + url + ".");
            this.wasOnPageFinishInvoked.set(true);
            return true;
        }
        return false;
    }

    public boolean isMatchCurrentUrl(String url) {
        try {
            Uri currentUri = Uri.parse((String)this.currUrl);
            Uri uri = Uri.parse((String)url);
            String currentPath = currentUri.getHost() + currentUri.getPath();
            String pendingPath = uri.getHost() + uri.getPath();
            if (currentUri.getHost().equalsIgnoreCase(uri.getHost())) {
                if (!currentPath.endsWith("/")) {
                    currentPath = currentPath + "/";
                }
                if (!pendingPath.endsWith("/")) {
                    pendingPath = pendingPath + "/";
                }
                return currentPath.equalsIgnoreCase(pendingPath);
            }
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "isMatchCurrentUrl error:" + e.getMessage());
        }
        return false;
    }

    protected HashMap<String, String> getHeaders() {
        Map<String, String> headerData;
        HashMap<String, String> headers = new HashMap<String, String>();
        String cspContent = SonicDataHelper.getCSPContent(this.id);
        String cspReportOnlyContent = SonicDataHelper.getCSPReportOnlyContent(this.id);
        if (SonicUtils.shouldLog(4)) {
            SonicUtils.log(TAG, 4, "session(" + this.sId + ") cspContent = " + cspContent + ", cspReportOnlyContent = " + cspReportOnlyContent + ".");
        }
        headers.put("Content-Security-Policy", cspContent);
        headers.put("Content-Security-Policy-Report-Only", cspReportOnlyContent);
        SonicHeadersProvider headersProvider = SonicEngine.getInstance().getSonicHeadersProvider();
        if (headersProvider != null && (headerData = headersProvider.getHeaders(this.srcUrl)) != null && headerData.size() > 0) {
            for (Map.Entry<String, String> entry : headerData.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        return headers;
    }

    protected void saveHeaders(SonicSessionConnection sessionConnection) {
        if (sessionConnection != null) {
            Map<String, List<String>> headerFieldsMap = sessionConnection.getResponseHeaderFields();
            SonicHeadersProvider headersProvider = SonicEngine.getInstance().getSonicHeadersProvider();
            if (headersProvider != null) {
                headersProvider.saveHeaders(this.srcUrl, headerFieldsMap);
            }
        }
    }

    public SonicSessionClient getSessionClient() {
        return this.sessionClient;
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy(boolean force) {
        int curState = this.sessionState.get();
        if (3 != curState) {
            if (null != this.sessionClient) {
                this.sessionClient = null;
            }
            if (null != this.pendingWebResourceStream) {
                this.pendingWebResourceStream = null;
            }
            if (null != this.pendingDiffData) {
                this.pendingDiffData = null;
            }
            this.clearSessionData();
            if (force || this.canDestroy()) {
                if (null != this.sessionConnection && !force) {
                    this.sessionConnection.disconnect();
                    this.sessionConnection = null;
                }
                this.sessionState.set(3);
                AtomicInteger atomicInteger = this.sessionState;
                synchronized (atomicInteger) {
                    this.sessionState.notify();
                }
                this.notifyStateChange(curState, 3, null);
                this.mainHandler.removeMessages(3);
                this.callbackWeakRefList.clear();
                this.isWaitingForDestroy.set(false);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") final destroy, force=" + force + ".");
                return;
            }
            if (this.isWaitingForDestroy.compareAndSet(false, true)) {
                this.mainHandler.sendEmptyMessageDelayed(3, 6000L);
                SonicUtils.log(TAG, 4, "session(" + this.sId + ") waiting for destroy, current state =" + curState + ".");
            }
        }
    }

    protected void clearSessionData() {
    }

    public static interface Callback {
        public void onSessionStateChange(SonicSession var1, int var2, int var3, Bundle var4);
    }
}

