/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

class SonicFileUtils {
    private static final String TAG = "SonicSdk_SonicFileUtils";
    private static final String TEMPLATE_EXT = ".tpl";
    private static final String DATA_EXT = ".data";
    private static final String HTML_EXT = ".html";

    SonicFileUtils() {
    }

    static String getSonicCacheDirPath() {
        String dirPath = SonicEngine.getInstance().getRuntime().getSonicCacheDir().getAbsolutePath();
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        return dirPath;
    }

    static String getSonicTemplatePath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + TEMPLATE_EXT;
    }

    static String getSonicDataPath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + DATA_EXT;
    }

    static String getSonicHtmlPath(String sessionId) {
        return SonicFileUtils.getSonicCacheDirPath() + sessionId + HTML_EXT;
    }

    static boolean deleteSonicFiles(String sessionId) {
        File dataFile;
        File templateFile;
        boolean deleteSuccess = true;
        File htmlFile = new File(SonicFileUtils.getSonicHtmlPath(sessionId));
        if (htmlFile.exists()) {
            deleteSuccess = htmlFile.delete();
        }
        if ((templateFile = new File(SonicFileUtils.getSonicTemplatePath(sessionId))).exists()) {
            deleteSuccess &= templateFile.delete();
        }
        if ((dataFile = new File(SonicFileUtils.getSonicDataPath(sessionId))).exists()) {
            deleteSuccess &= dataFile.delete();
        }
        return deleteSuccess;
    }

    static boolean verifyData(String content, String targetSha1) {
        return !TextUtils.isEmpty((CharSequence)content) && !TextUtils.isEmpty((CharSequence)targetSha1) && targetSha1.equals(SonicUtils.getSHA1(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        BufferedInputStream bis = null;
        InputStreamReader reader = null;
        String rtn = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            reader = new InputStreamReader((InputStream)bis, "UTF-8");
            int size = (int)file.length();
            if (size > 12288) {
                int n;
                char[] buffer = new char[4096];
                StringBuilder result = new StringBuilder(12288);
                while (-1 != (n = reader.read(buffer))) {
                    result.append(buffer, 0, n);
                }
                rtn = result.toString();
            } else {
                char[] buffer = new char[size];
                int n = reader.read(buffer);
                rtn = new String(buffer, 0, n);
            }
        }
        catch (Exception e) {
            SonicUtils.log(TAG, 6, "readFile error:(" + file.getName() + ") " + e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "readFile close error:(" + file.getName() + ") " + e.getMessage());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    SonicUtils.log(TAG, 6, "readFile close error:(" + file.getName() + ") " + e.getMessage());
                }
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeFile(String str, String filePath) {
        File file = new File(filePath);
        FileOutputStream fos = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            fos = new FileOutputStream(file);
            fos.write(str.getBytes());
            fos.flush();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            SonicUtils.log(TAG, 6, "writeFile error:(" + filePath + ") " + e.getMessage());
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (Throwable e) {
                    SonicUtils.log(TAG, 6, "writeFile close error:(" + filePath + ") " + e.getMessage());
                }
            }
        }
        return false;
    }

    static boolean deleteAllChildFiles(File file) {
        boolean deleteSuccess = true;
        if (null != file && file.exists()) {
            File[] childFiles;
            if (file.isFile()) {
                deleteSuccess = file.delete();
            } else if (file.isDirectory() && null != (childFiles = file.listFiles())) {
                for (File childFile : childFiles) {
                    deleteSuccess &= SonicFileUtils.deleteAllChildFiles(childFile);
                }
            }
        }
        return deleteSuccess;
    }
}

