/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.SharedPreferences;
import android.os.Build;
import com.tencent.sonic.sdk.SonicEngine;

class SonicDataHelper {
    private static final String TAG = "SonicSdk_SonicDataHelper";
    private static final String SP_FILE_SONIC = "sp_sonic_db";
    private static final String SP_KEY_VERSION_NUM = "versionNum";
    private static final String SP_KEY_ETAG = "etag_";
    private static final String SP_KEY_TEMPLATE_TAG = "templateTag_";
    private static final String SP_KEY_HTML_SHA1 = "htmlSha1_";
    private static final String SP_KEY_HTML_SIZE = "htmlSize_";
    private static final String SP_KEY_TEMPLATE_UPDATE_TIME = "templateUpdateTime_";
    private static final String SP_KEY_UNAVAILABLE_TIME = "UnavailableTime_";
    private static final String SP_KEY_CSP = "csp_";
    private static final String SP_KEY_CSP_REPORT_ONLY = "cspReportOnly_";
    private static SharedPreferences sSharedPreferences;

    SonicDataHelper() {
    }

    private static synchronized SharedPreferences getSonicSharedPref() {
        String oldVersionNum;
        String newVersionNum;
        if (null == sSharedPreferences && !(newVersionNum = "1.0.1").equals(oldVersionNum = (sSharedPreferences = Build.VERSION.SDK_INT >= 11 ? SonicEngine.getInstance().getRuntime().getContext().getSharedPreferences(SP_FILE_SONIC, 4) : SonicEngine.getInstance().getRuntime().getContext().getSharedPreferences(SP_FILE_SONIC, 0)).getString(SP_KEY_VERSION_NUM, ""))) {
            sSharedPreferences.edit().putString(SP_KEY_VERSION_NUM, newVersionNum).apply();
        }
        return sSharedPreferences;
    }

    static SessionData getSessionData(String sessionId) {
        SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
        SessionData sessionData = new SessionData();
        sessionData.etag = sharedPreferences.getString(SP_KEY_ETAG + sessionId, "");
        sessionData.templateTag = sharedPreferences.getString(SP_KEY_TEMPLATE_TAG + sessionId, "");
        sessionData.htmlSha1 = sharedPreferences.getString(SP_KEY_HTML_SHA1 + sessionId, "");
        sessionData.templateUpdateTime = sharedPreferences.getLong(SP_KEY_TEMPLATE_UPDATE_TIME + sessionId, 0L);
        sessionData.htmlSize = sharedPreferences.getLong(SP_KEY_HTML_SIZE + sessionId, 0L);
        sessionData.cspContent = sharedPreferences.getString(SP_KEY_CSP + sessionId, "");
        sessionData.cspReportOnlyContent = sharedPreferences.getString(SP_KEY_CSP_REPORT_ONLY + sessionId, "");
        return sessionData;
    }

    static void saveSessionData(String sessionId, SessionData sessionData) {
        if (sessionData != null && sessionId != null) {
            SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(SP_KEY_ETAG + sessionId, sessionData.etag);
            editor.putString(SP_KEY_TEMPLATE_TAG + sessionId, sessionData.templateTag);
            editor.putString(SP_KEY_HTML_SHA1 + sessionId, sessionData.htmlSha1);
            editor.putLong(SP_KEY_TEMPLATE_UPDATE_TIME + sessionId, sessionData.templateUpdateTime);
            editor.putLong(SP_KEY_HTML_SIZE + sessionId, sessionData.htmlSize);
            editor.putString(SP_KEY_CSP + sessionId, sessionData.cspContent);
            editor.putString(SP_KEY_CSP_REPORT_ONLY + sessionId, sessionData.cspReportOnlyContent);
            editor.apply();
        }
    }

    static void removeSessionData(String sessionId) {
        SharedPreferences.Editor editor = SonicDataHelper.getSonicSharedPref().edit();
        editor.remove(SP_KEY_ETAG + sessionId).remove(SP_KEY_TEMPLATE_TAG + sessionId);
        editor.remove(SP_KEY_HTML_SHA1 + sessionId).remove(SP_KEY_TEMPLATE_UPDATE_TIME + sessionId);
        editor.remove(SP_KEY_HTML_SIZE + sessionId).apply();
    }

    static boolean setSonicUnavailableTime(String sessionId, long unavailableTime) {
        SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
        return sharedPreferences.edit().putLong(SP_KEY_UNAVAILABLE_TIME + sessionId, unavailableTime).commit();
    }

    static long getLastSonicUnavailableTime(String sessionId) {
        SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
        return sharedPreferences.getLong(SP_KEY_UNAVAILABLE_TIME + sessionId, 0L);
    }

    static synchronized void clear() {
        if (null != sSharedPreferences) {
            sSharedPreferences.edit().clear().apply();
            sSharedPreferences = null;
        }
    }

    static String getCSPContent(String sessionId) {
        SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
        return sharedPreferences.getString(SP_KEY_CSP + sessionId, "");
    }

    static String getCSPReportOnlyContent(String sessionId) {
        SharedPreferences sharedPreferences = SonicDataHelper.getSonicSharedPref();
        return sharedPreferences.getString(SP_KEY_CSP_REPORT_ONLY + sessionId, "");
    }

    static class SessionData {
        String etag;
        String templateTag;
        String htmlSha1;
        long htmlSize;
        long templateUpdateTime;
        String cspContent;
        String cspReportOnlyContent;

        SessionData() {
        }

        public void reset() {
            this.etag = "";
            this.templateTag = "";
            this.htmlSha1 = "";
            this.htmlSize = 0L;
            this.templateUpdateTime = 0L;
            this.cspContent = "";
            this.cspReportOnlyContent = "";
        }
    }
}

