package com.tencent.sonic.sdk;

import android.content.Intent;

/**
 * <code>SonicSessionConnectionInterceptor</code> provide a <code>SonicSessionConnection</code>.
 * If an {@link SonicSessionConfig}does not set <code>SonicSessionConnectionInterceptor</code>
 * sonic will use {@link com.tencent.sonic.sdk.SonicSessionConnection.SessionConnectionDefaultImpl}
 * as default.
 *
 */
public abstract class SonicSessionConnectionInterceptor {

    public abstract SonicSessionConnection getConnection(SonicSession session, Intent intent);

    public static SonicSessionConnection getSonicSessionConnection(SonicSession session, Intent intent) {
        SonicSessionConnectionInterceptor interceptor = session.config.connectionInterceptor;
        if (interceptor != null) {
            return interceptor.getConnection(session, intent);
        }
        return new SonicSessionConnection.SessionConnectionDefaultImpl(session, intent);
    }
}
