/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Context;
import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SonicSniSSLSocketFactory
extends SSLSocketFactory {
    private static final String TAG = "sonic_SonicSniSSLSocketFactory";
    private final String targetHostName;
    private final SSLCertificateSocketFactory sslSocketFactory;

    SonicSniSSLSocketFactory(Context context, String targetHostName) {
        this.targetHostName = targetHostName;
        this.sslSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0, (SSLSessionCache)new SSLSessionCache(context));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.sslSocketFactory.createSocket(s, this.targetHostName, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        SonicSniSSLSocketFactory.verifyHostname(socket, this.targetHostName);
        return socket;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sslSocketFactory.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHost, localPort));
        socket.connect(new InetSocketAddress(host, port));
        SonicSniSSLSocketFactory.verifyHostname(socket, this.targetHostName);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sslSocketFactory.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslSocketFactory.createSocket(address, port, localAddress, localPort);
    }

    public static void verifyHostname(Socket socket, String hostname) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Attempt to verify non-SSL socket");
        }
        SSLSocket ssl = (SSLSocket)socket;
        ssl.startHandshake();
        SSLSession session = ssl.getSession();
        if (session == null) {
            throw new SSLException("Cannot verify SSL socket without session");
        }
        if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session)) {
            SonicUtils.log(TAG, 6, "sonic SSL error:Cannot verify hostname" + hostname + ")!");
            throw new SSLPeerUnverifiedException("Cannot verify hostname: " + hostname);
        }
    }
}

