/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.text.TextUtils;
import com.tencent.sonic.sdk.SonicDataHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicFileUtils;
import com.tencent.sonic.sdk.SonicSession;
import com.tencent.sonic.sdk.SonicUtils;
import java.io.File;

public abstract class SonicCacheInterceptor {
    public static final String TAG = "SonicSdk_SonicCacheInterceptor";
    private final SonicCacheInterceptor nextInterceptor;

    public SonicCacheInterceptor(SonicCacheInterceptor next) {
        this.nextInterceptor = next;
    }

    public SonicCacheInterceptor next() {
        return this.nextInterceptor;
    }

    public abstract String getCacheData(SonicSession var1);

    static String getSonicCacheData(SonicSession session) {
        SonicCacheInterceptor interceptor = session.config.cacheInterceptor;
        if (null == interceptor) {
            return SonicCacheInterceptorDefaultImpl.getCacheData(session);
        }
        String htmlString = null;
        while (null != interceptor && null == (htmlString = interceptor.getCacheData(session))) {
            interceptor = interceptor.next();
        }
        return htmlString;
    }

    private static class SonicCacheInterceptorDefaultImpl {
        public static final String TAG = "SonicSdk_DefaultSonicCacheInterceptor";

        private SonicCacheInterceptorDefaultImpl() {
        }

        public static String getCacheData(SonicSession session) {
            boolean verifyError;
            if (session == null) {
                SonicUtils.log(TAG, 4, "getCache is null");
                return null;
            }
            SonicDataHelper.SessionData sessionData = SonicDataHelper.getSessionData(session.id);
            String htmlString = "";
            if (TextUtils.isEmpty((CharSequence)sessionData.etag) || TextUtils.isEmpty((CharSequence)sessionData.templateTag) || TextUtils.isEmpty((CharSequence)sessionData.htmlSha1)) {
                verifyError = true;
                SonicUtils.log(TAG, 4, "session(" + session.sId + ") runSonicFlow : session data is empty.");
            } else {
                File htmlCacheFile = new File(SonicFileUtils.getSonicHtmlPath(session.id));
                htmlString = SonicFileUtils.readFile(htmlCacheFile);
                verifyError = TextUtils.isEmpty((CharSequence)htmlString);
                if (verifyError) {
                    SonicUtils.log(TAG, 6, "session(" + session.sId + ") runSonicFlow error:cache data is null.");
                } else if (SonicEngine.getInstance().getConfig().VERIFY_CACHE_FILE_WITH_SHA1) {
                    if (!SonicFileUtils.verifyData(htmlString, sessionData.htmlSha1)) {
                        verifyError = true;
                        htmlString = "";
                        SonicEngine.getInstance().getRuntime().notifyError(session.sessionClient, session.srcUrl, -1001);
                        SonicUtils.log(TAG, 6, "session(" + session.sId + ") runSonicFlow error:verify html cache with sha1 fail.");
                    } else {
                        SonicUtils.log(TAG, 4, "session(" + session.sId + ") runSonicFlow verify html cache with sha1 success.");
                    }
                } else if (sessionData.htmlSize != htmlCacheFile.length()) {
                    verifyError = true;
                    htmlString = "";
                    SonicEngine.getInstance().getRuntime().notifyError(session.sessionClient, session.srcUrl, -1001);
                    SonicUtils.log(TAG, 6, "session(" + session.sId + ") runSonicFlow error:verify html cache with size fail.");
                }
            }
            if (verifyError) {
                long startTime = System.currentTimeMillis();
                SonicUtils.removeSessionCache(session.id);
                sessionData.reset();
                SonicUtils.log(TAG, 4, "session(" + session.sId + ") runSonicFlow:verify error so remove session cache, cost " + (System.currentTimeMillis() - startTime) + "ms.");
            }
            return htmlString;
        }
    }
}

