package com.tencent.sonic.sdk;

import java.net.HttpURLConnection;


/**
 * The Statistic model specifies the data models which are requried to be used to provide
 * the performance data described by the specific attributes in a SonicSession.
 */
public class SonicSessionStatistics {
    
    /**
     * Original url
     */
    public String srcUrl;

    /**
     * Sonic final mode{@link SonicSession#finalResultCode}
     */
    public int finalMode;

    /**
     * Sonic original mode{@link SonicSession#srcResultCode}
     */
    public int originalMode;

    /**
     * Sonic start {@link SonicSession#start()} time
     */
    public long sonicStartTime;

    /**
     * Sonic flow start{@link SonicSession#runSonicFlow()} time
     */
    public long sonicFlowStartTime;

    /**
     * The time that sonic begin verify local data
     */
    public long cacheVerifyTime;

    /**
     * The time sonic initiate the http(s) request
     */
    public long connectionFlowStartTime;

    /**
     * The http(s) connect{@link HttpURLConnection#connect()} response time
     */
    public long connectionConnectTime;

    /**
     * The http(s) getResponseCode{@link HttpURLConnection#getResponseCode()} response time
     */
    public long connectionRespondTime;

    /**
     * Sonic flow end time
     */
    public long connectionFlowFinishTime;

    /**
     * Is IP direct
     */
    public boolean isDirectAddress;
}
