package com.tencent.sonic.sdk;

/**
 * This interface is used to call the difference data between local and server data
 * to the client.
 *
 */
public interface SonicDiffDataCallback {
    /**
     * Called when sonic processes the local data and the server data.
     * When the page requests the latest data, sonic will send the latest
     * data to page by this method.
     *
     * @param resultData The result to page.
     */
    void callback(String resultData);
}
