package com.tencent.sonic.sdk;

/**
 * Sonic global config
 */
public class SonicConfig {

    /**
     * The max number of preload session , default is 5
     */
    int MAX_PRELOAD_SESSION_COUNT = 5;

    /**
     * When sonic server unavailable, sonic will not execute its flow and will execute
     * webview normal loading process. This time control sonic how log will not execute its flow.
     */
    long SONIC_UNAVAILABLE_TIME = 6 * 60 * 60 * 1000;

    /**
     * Whether verify file by compare SHA1. If this value is false, sonic will verify file by file's size.
     * Verify the file size is less time consuming than checking SHA1.
     */
    boolean VERIFY_CACHE_FILE_WITH_SHA1 = true;

    private SonicConfig() {

    }

    /**
     * Builder for SonicConfig
     */
    public static class Builder {

        private final SonicConfig target;

        public Builder() {
            target = new SonicConfig();
        }

        public Builder setMaxPreloadSessionCount(int maxPreloadSessionCount) {
            target.MAX_PRELOAD_SESSION_COUNT = maxPreloadSessionCount;
            return this;
        }

        public Builder setUnavailableTime(long unavailableTime) {
            target.SONIC_UNAVAILABLE_TIME = unavailableTime;
            return this;
        }

        public Builder setCacheVerifyWithSha1(boolean enable) {
            target.VERIFY_CACHE_FILE_WITH_SHA1 = enable;
            return this;
        }

        public SonicConfig build() {
            return target;
        }
    }
}
