/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.quic.ConnectPool;
import com.tencent.qcloud.quic.ProgressCallback;
import com.tencent.qcloud.quic.QLog;
import com.tencent.qcloud.quic.QuicException;
import com.tencent.qcloud.quic.QuicNative;
import com.tencent.qcloud.quic.QuicOutputStream;
import com.tencent.qcloud.quic.QuicRequest;
import com.tencent.qcloud.quic.QuicResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.ProtocolException;
import java.util.Map;
import java.util.concurrent.Callable;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class QuicImpl
implements QuicNative.NetworkCallback,
Callable<QuicResponse> {
    private QuicRequest quicRequest;
    private QuicResponse quicResponse;
    private QuicException exception;
    private ConnectPool connectPool;
    private QuicNative realQuicCall;
    private Looper looper;
    @Nullable
    private Handler handler;
    private boolean isHeader;
    private volatile boolean isOver = false;
    private boolean isCompleted = false;
    private boolean hasReceivedResponse = false;
    private boolean isClosed = false;
    private CallMetricsListener callMetricsListener;

    public QuicImpl(QuicRequest quicRequest, ConnectPool connectPool) {
        this.quicRequest = quicRequest;
        this.connectPool = connectPool;
        this.quicResponse = new QuicResponse();
    }

    public void setCallMetricsListener(CallMetricsListener callMetricsListener) {
        this.callMetricsListener = callMetricsListener;
    }

    public void setOutputDestination(OutputStream outputStream) {
        this.quicResponse.setOutputStream(outputStream);
    }

    public void setProgressCallback(ProgressCallback progress) {
        this.quicResponse.setProgressCallback(progress);
    }

    @Override
    public void onConnect(int handleId, int code) {
        this.handler.sendEmptyMessage(1);
    }

    @Override
    public void onDataReceive(int handleId, byte[] data, int len) {
        Message message = this.handler.obtainMessage();
        message.what = 2;
        Bundle bundle = new Bundle();
        bundle.putByteArray("DATA", data);
        bundle.putInt("LEN", len);
        message.obj = bundle;
        this.handler.sendMessage(message);
    }

    @Override
    public void onCompleted(int handleId) {
        this.handler.sendEmptyMessage(3);
    }

    @Override
    public void onClose(int handleId, int code, String desc) {
        QLog.d("has been completed : %s", this.isOver);
        if (this.isOver) {
            return;
        }
        Message message = this.handler.obtainMessage();
        message.what = 4;
        QuicException quicException = new QuicException(String.format("Closed(%d, %s)", code, desc));
        message.obj = quicException;
        this.handler.sendMessage(message);
    }

    private void startConnect() {
        this.callMetricsListener.connectStart(null, null, null);
        this.realQuicCall.connect(this.quicRequest.host, this.quicRequest.ip, this.quicRequest.port, this.quicRequest.tcpPort);
    }

    private void sendData() {
        this.callMetricsListener.connectEnd(null, null, null, null);
        try {
            this.callMetricsListener.requestHeadersStart(null);
            for (Map.Entry<String, String> header : this.quicRequest.headers.entrySet()) {
                this.realQuicCall.addHeader(header.getKey(), header.getValue());
            }
            this.callMetricsListener.requestHeadersEnd(null, null);
            this.callMetricsListener.requestBodyStart(null);
            if (this.quicRequest.requestBody != null) {
                QuicOutputStream quicOutputStream = new QuicOutputStream(this.realQuicCall);
                BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)quicOutputStream));
                this.quicRequest.requestBody.writeTo(bufferedSink);
                try {
                    bufferedSink.flush();
                    bufferedSink.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.realQuicCall.sendRequest(new byte[0], 0, true);
            } else {
                this.realQuicCall.sendRequest(new byte[0], 0, true);
            }
            this.callMetricsListener.requestBodyEnd(null, -1L);
        }
        catch (IOException e) {
            Message message = this.handler.obtainMessage();
            message.what = 5;
            message.obj = new QuicException(e);
            this.handler.sendMessage(message);
        }
    }

    private void receiveResponse(byte[] data, int len) {
        if (this.isHeader) {
            this.callMetricsListener.responseHeadersStart(null);
            this.parseResponseHeader(data, len);
            this.callMetricsListener.responseHeadersEnd(null, null);
            this.isHeader = false;
            this.callMetricsListener.responseBodyStart(null);
        } else {
            this.parseBody(data, len);
            this.callMetricsListener.responseBodyEnd(null, -1L);
        }
        this.hasReceivedResponse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponseHeader(byte[] data, int len) {
        try {
            QLog.d("headers==>%s", new String(data, "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.quicResponse != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(data, 0, len);
                bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (line.startsWith("HTTP/1.")) {
                        this.parseStateLine(line);
                    } else if (line.contains(":")) {
                        int index = line.indexOf(":");
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        this.quicResponse.headers.put(key, value);
                        if (key.equalsIgnoreCase("content-length")) {
                            this.quicResponse.setContentLength(Long.valueOf(value));
                        } else if (key.equalsIgnoreCase("content-type")) {
                            this.quicResponse.contentType = value;
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                Message message = this.handler.obtainMessage();
                message.what = 5;
                message.obj = new QuicException(e);
                this.handler.sendMessage(message);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseStateLine(String statusLine) throws ProtocolException {
        int code;
        int codeStart;
        if (statusLine.startsWith("HTTP/1.")) {
            if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            int httpMinorVersion = statusLine.charAt(7) - 48;
            codeStart = 9;
            if (httpMinorVersion == 0) {
                QLog.d("HTTP/1.0", new Object[0]);
            } else {
                if (httpMinorVersion != 1) throw new ProtocolException("Unexpected status line: " + statusLine);
                QLog.d("HTTP/1.1", new Object[0]);
            }
        } else {
            if (!statusLine.startsWith("ICY ")) throw new ProtocolException("Unexpected status line: " + statusLine);
            QLog.d("HTTP/1.0", new Object[0]);
            codeStart = 4;
        }
        if (statusLine.length() < codeStart + 3) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        try {
            code = Integer.parseInt(statusLine.substring(codeStart, codeStart + 3));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        String message = "";
        if (statusLine.length() > codeStart + 3) {
            if (statusLine.charAt(codeStart + 3) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            message = statusLine.substring(codeStart + 4);
        }
        this.quicResponse.code = code;
        this.quicResponse.message = message;
    }

    private void parseBody(byte[] data, int len) {
        try {
            if (this.quicResponse.code >= 200 && this.quicResponse.code < 300 && this.quicResponse.fileSink != null) {
                this.quicResponse.fileSink.write(data, 0, len);
                this.quicResponse.updateProgress(len);
            } else {
                this.quicResponse.buffer.write(data, 0, len);
                this.quicResponse.currentLength += (long)len;
            }
        }
        catch (Exception e) {
            Message message = this.handler.obtainMessage();
            message.what = 5;
            message.obj = new QuicException(e);
            this.handler.sendMessage(message);
        }
    }

    private void finish() {
        try {
            if (this.quicResponse.code >= 200 && this.quicResponse.code < 300) {
                if (this.quicResponse.fileSink != null) {
                    this.quicResponse.fileSink.flush();
                    this.quicResponse.fileSink.close();
                }
            } else {
                this.quicResponse.buffer.flush();
            }
        }
        catch (Exception e) {
            Message message = this.handler.obtainMessage();
            message.what = 5;
            message.obj = new QuicException(e);
            this.handler.sendMessage(message);
        }
    }

    public void cancelConnect() {
        this.realQuicCall.cancelRequest();
    }

    public void clear() {
        this.realQuicCall.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuicResponse call() throws QuicException {
        QLog.d("start get a connect: ", new Object[0]);
        this.realQuicCall = this.connectPool.getQuicNative(this.quicRequest.host, this.quicRequest.ip, this.quicRequest.port, this.quicRequest.tcpPort);
        this.realQuicCall.setCallback(this);
        this.connectPool.setComplete(this.realQuicCall, false);
        QLog.d("has get a connect: ", new Object[0]);
        QuicImpl quicImpl = this;
        synchronized (quicImpl) {
            this.looper = Looper.myLooper();
            if (this.looper != null) {
                this.notifyAll();
            }
        }
        if (this.looper == null) {
            Looper.prepare();
            QLog.d("looper prepare", new Object[0]);
            quicImpl = this;
            synchronized (quicImpl) {
                this.looper = Looper.myLooper();
                this.notifyAll();
            }
        }
        try {
            this.setMessageQueue();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.handler = new Handler(this.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        QuicImpl.this.startConnect();
                        break;
                    }
                    case 1: {
                        QuicImpl.this.isHeader = true;
                        QuicImpl.this.isOver = false;
                        QuicImpl.this.sendData();
                        break;
                    }
                    case 2: {
                        Bundle bundle = (Bundle)msg.obj;
                        QuicImpl.this.receiveResponse(bundle.getByteArray("DATA"), bundle.getInt("LEN"));
                        QuicImpl.this.quitSafely();
                        break;
                    }
                    case 3: {
                        QuicImpl.this.isCompleted = true;
                        QuicImpl.this.quitSafely();
                        break;
                    }
                    case 4: {
                        QuicImpl.this.isClosed = true;
                        QuicImpl.this.exception = (QuicException)msg.obj;
                        QuicImpl.this.quitSafely();
                        break;
                    }
                    case 5: {
                        QuicImpl.this.isClosed = true;
                        QuicImpl.this.exception = (QuicException)msg.obj;
                        QuicImpl.this.quitSafely();
                    }
                }
            }
        };
        QLog.d("looper loop start", new Object[0]);
        if (this.realQuicCall.currentState == 1) {
            this.handler.sendEmptyMessage(1);
        } else {
            this.handler.sendEmptyMessage(0);
        }
        Looper.loop();
        QLog.d("looper loop end", new Object[0]);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.quicResponse;
    }

    public QuicException getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Looper getLooper() {
        if (!Thread.currentThread().isAlive()) {
            return null;
        }
        QuicImpl quicImpl = this;
        synchronized (quicImpl) {
            while (Thread.currentThread().isAlive() && this.looper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.looper;
    }

    private void quitSafely() {
        QLog.d("isClose: %s; isCompleted: %s; hasReceiveResponse: %s", this.isClosed, this.isCompleted, this.hasReceivedResponse);
        if (!(this.isClosed || this.isCompleted && this.hasReceivedResponse)) {
            return;
        }
        this.isOver = true;
        if (this.isCompleted) {
            this.finish();
        }
        this.handler.removeCallbacksAndMessages(null);
        this.connectPool.setComplete(this.realQuicCall, true);
        Looper looper = this.getLooper();
        if (looper != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                looper.quitSafely();
            } else {
                looper.quit();
            }
        }
    }

    private void setMessageQueue() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException, InvocationTargetException, InstantiationException {
        Constructor<?>[] messageQueueConstructor;
        Field messageQueueField = Looper.class.getDeclaredField("mQueue");
        messageQueueField.setAccessible(true);
        Class<?> messageQueueClass = Class.forName("android.os.MessageQueue");
        block0: for (Constructor<?> constructor : messageQueueConstructor = messageQueueClass.getDeclaredConstructors()) {
            Class<?>[] types;
            constructor.setAccessible(true);
            for (Class<?> clazz : types = constructor.getParameterTypes()) {
                if (!clazz.getName().equalsIgnoreCase("boolean")) continue;
                messageQueueField.set(this.looper, constructor.newInstance(true));
                continue block0;
            }
        }
    }
}

