/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.HttpLogger;
import com.tencent.qcloud.core.http.HttpLoggingInterceptor;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.OkHttpLoggingUtils;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.http.ResponseFileConverter;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.quic.ProgressCallback;
import com.tencent.qcloud.quic.QuicImpl;
import com.tencent.qcloud.quic.QuicManager;
import com.tencent.qcloud.quic.QuicRequest;
import com.tencent.qcloud.quic.QuicResponse;
import java.io.Closeable;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;

public class QuicProxy<T>
extends NetworkProxy<T> {
    private QuicImpl quic;
    private QuicManager quicManager;
    private RetryStrategy retryStrategy;
    private Dns dns;
    private HttpLogger httpLogger;

    public QuicProxy(QuicManager quicManager, Dns dns, HttpLogger httpLogger, RetryStrategy retryStrategy) {
        this.quicManager = quicManager;
        this.retryStrategy = retryStrategy;
        this.dns = dns;
        this.httpLogger = httpLogger;
    }

    public void cancel() {
        if (this.quic != null) {
            this.quic.cancelConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpResult<T> executeHttpRequest(HttpRequest<T> httpRequest) throws QCloudClientException, QCloudServiceException {
        Response response = null;
        HttpResult<T> httpResult = null;
        QCloudClientException clientException = null;
        QCloudServiceException serviceException = null;
        int attempt = 0;
        long startTime = System.nanoTime();
        while (true) {
            try {
                httpRequest.setOkHttpRequestTag(this.identifier);
                Request okHttpRequest = httpRequest.buildRealRequest();
                HttpUrl httpUrl = okHttpRequest.url();
                String host = httpUrl.host();
                boolean isHttps = httpUrl.isHttps();
                String url = httpUrl.toString();
                int index = url.indexOf("/", isHttps ? 8 : 7);
                String path = "/";
                if (index > 0) {
                    path = url.substring(index);
                }
                String ip = null;
                CallMetricsListener callMetricsListener = new CallMetricsListener(null);
                callMetricsListener.dnsStart(null, host);
                List inetAddresses = this.dns.lookup(host);
                if (inetAddresses != null && inetAddresses.size() > 0) {
                    ip = ((InetAddress)inetAddresses.get(0)).getHostAddress();
                }
                callMetricsListener.dnsEnd(null, host, inetAddresses);
                int port = httpUrl.port();
                int tcpPort = 80;
                String method = okHttpRequest.method().toUpperCase();
                QuicRequest quicRequest = new QuicRequest(host, ip, port, tcpPort);
                quicRequest.addHeader(":scheme", isHttps ? "https" : "http");
                quicRequest.addHeader(":method", method);
                quicRequest.addHeader(":path", path);
                quicRequest.addHeader(":authority", host);
                Headers headers = okHttpRequest.headers();
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    String headerKey = headers.name(i);
                    if ("Host".equalsIgnoreCase(headerKey)) {
                        quicRequest.addHeader("Vod-Forward-Cos".toLowerCase(), headers.value(i));
                        continue;
                    }
                    quicRequest.addHeader(headers.name(i).toLowerCase(), headers.value(i));
                }
                RequestBody requestBody = httpRequest.getRequestBody();
                if (httpRequest.getRequestBody() != null) {
                    String contentType = requestBody.contentType() != null ? requestBody.contentType().toString() : "application/octet-stream";
                    quicRequest.addHeader("Content-Type".toLowerCase(), contentType);
                    quicRequest.addHeader("Content-Length".toLowerCase(), String.valueOf(requestBody.contentLength()));
                }
                String requestStartMessage = "--> " + okHttpRequest.method() + ' ' + okHttpRequest.url() + ' ' + Protocol.QUIC;
                OkHttpLoggingUtils.logMessage((String)requestStartMessage, (HttpLoggingInterceptor.Logger)this.httpLogger);
                OkHttpLoggingUtils.logQuicRequestHeaders(quicRequest.headers, (HttpLoggingInterceptor.Logger)this.httpLogger);
                quicRequest.setRequestBody(okHttpRequest.body());
                this.quic = this.quicManager.newQuicImpl(quicRequest);
                this.quic.setCallMetricsListener(callMetricsListener);
                ResponseBodyConverter converter = httpRequest.getResponseBodyConverter();
                if (converter instanceof ResponseFileConverter) {
                    ((ResponseFileConverter)converter).enableQuic(true);
                    ((ResponseFileConverter)converter).setProgressListener(this.mProgressListener);
                    final QCloudProgressListener progressListener = ((ResponseFileConverter)converter).getProgressListener();
                    this.quic.setProgressCallback(new ProgressCallback(){

                        @Override
                        public void onProgress(long current, long total) {
                            progressListener.onProgress(current, total);
                        }
                    });
                    this.quic.setOutputDestination(((ResponseFileConverter)converter).getOutputStream());
                }
                long startNs = System.nanoTime();
                QuicResponse quicResponse = this.quic.call();
                response = quicResponse.covertResponse(okHttpRequest);
                long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
                OkHttpLoggingUtils.logResponse((Response)response, (long)tookMs, (HttpLoggingInterceptor.Level)HttpLoggingInterceptor.Level.HEADERS, (HttpLoggingInterceptor.Logger)this.httpLogger);
                httpResult = this.convertResponse(httpRequest, response);
                callMetricsListener.dumpMetrics(this.metrics);
                Util.closeQuietly((Closeable)response);
            }
            catch (Exception e) {
                if (e.getCause() instanceof QCloudServiceException) {
                    serviceException = (QCloudServiceException)e.getCause();
                    break;
                }
                if (this.retryStrategy.shouldRetry(attempt++, System.nanoTime() - startTime, 0)) continue;
                if (e.getCause() instanceof QCloudClientException) {
                    clientException = (QCloudClientException)e.getCause();
                    break;
                }
                clientException = new QCloudClientException((Throwable)e);
            }
            finally {
                Util.closeQuietly(response);
                continue;
            }
            break;
        }
        if (clientException != null) {
            throw clientException;
        }
        if (serviceException != null) {
            throw serviceException;
        }
        return httpResult;
    }

    protected HttpResult<T> convertResponse(HttpRequest<T> httpRequest, Response response) throws QCloudClientException, QCloudServiceException {
        HttpResponse httpResponse = new HttpResponse(httpRequest, response);
        ResponseBodyConverter converter = httpRequest.getResponseBodyConverter();
        Object content = converter.convert(httpResponse);
        return new HttpResult(httpResponse, content);
    }
}

