/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.quic.QLog;
import com.tencent.qcloud.quic.QuicNative;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class ConnectPool {
    private final int MAX_REQUEST_SIZE = 5;
    private Deque<QuicNative> quicNatives = new ArrayDeque<QuicNative>();
    private Object sync = new Object();

    protected void init(boolean isDebugLog) {
        QuicNative.init();
        QuicNative.setDebugLog(isDebugLog);
    }

    public static QuicNative createNewQuicNative(String host, String ip, int port, int tcpPort) {
        QuicNative quicNative = new QuicNative();
        quicNative.host = host;
        quicNative.ip = ip;
        quicNative.port = port;
        quicNative.tcpPort = tcpPort;
        quicNative.currentState = 0;
        return quicNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected QuicNative getQuicNative(String host, String ip, int port, int tcpPort) {
        QuicNative tmp = null;
        QLog.d("get an quic connect for(%s, %s, %d, %d)", host, ip, port, tcpPort);
        while (true) {
            Object object = this.sync;
            synchronized (object) {
                if (this.quicNatives.size() > 5) {
                    long idleTime = Long.MAX_VALUE;
                    for (QuicNative quicNative : this.quicNatives) {
                        if (!quicNative.host.equals(host) || !quicNative.ip.equals(ip) || quicNative.port != port || quicNative.tcpPort != tcpPort || !quicNative.isCompleted) continue;
                        QLog.d("has an old quic connect[%d] can reuse", quicNative.handleId);
                        quicNative.currentState = 1;
                        if (quicNative.idleStartTime > idleTime) continue;
                        tmp = quicNative;
                    }
                } else {
                    QLog.d("add new quic connect", new Object[0]);
                    QuicNative quicNative = new QuicNative();
                    quicNative.host = host;
                    quicNative.ip = ip;
                    quicNative.port = port;
                    quicNative.tcpPort = tcpPort;
                    this.quicNatives.add(quicNative);
                    quicNative.currentState = 0;
                    tmp = quicNative;
                    break;
                }
                if (tmp == null && (tmp = this.getLongestIdleConnect()) != null) {
                    QLog.d("get a longest idle quic connect[%d] for request", tmp.handleId);
                    tmp.host = host;
                    tmp.ip = ip;
                    tmp.port = port;
                    tmp.currentState = 0;
                    tmp.tcpPort = tcpPort;
                }
                if (tmp != null) {
                    tmp.isCompleted = false;
                    tmp.idleStartTime = Long.MAX_VALUE;
                }
            }
            if (tmp != null) break;
            QLog.d("wait an idle quic connect", new Object[0]);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateQuicNativeState(QuicNative quicNative, int newState) {
        Object object = this.sync;
        synchronized (object) {
            block2 : switch (newState) {
                case 1: {
                    quicNative.currentState = 1;
                    break;
                }
                case 3: {
                    quicNative.isCompleted = true;
                    quicNative.currentState = 3;
                    quicNative.idleStartTime = System.nanoTime();
                    break;
                }
                case 4: 
                case 5: {
                    Iterator<QuicNative> iterator = this.quicNatives.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next() != quicNative) continue;
                        iterator.remove();
                        break block2;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid state: " + newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QuicNative getLongestIdleConnect() {
        QuicNative longestIdleQuicNative = null;
        Object object = this.sync;
        synchronized (object) {
            long tmp = Long.MAX_VALUE;
            for (QuicNative quicNative : this.quicNatives) {
                if (!quicNative.isCompleted || quicNative.idleStartTime > tmp) continue;
                tmp = quicNative.idleStartTime;
                longestIdleQuicNative = quicNative;
            }
        }
        return longestIdleQuicNative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.sync;
        synchronized (object) {
            this.quicNatives.clear();
            QuicNative.destory();
        }
    }
}

