/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.quic;

import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.quic.ConnectPool;
import com.tencent.qcloud.quic.ProgressCallback;
import com.tencent.qcloud.quic.QLog;
import com.tencent.qcloud.quic.QuicException;
import com.tencent.qcloud.quic.QuicNative;
import com.tencent.qcloud.quic.QuicOutputStream;
import com.tencent.qcloud.quic.QuicRequest;
import com.tencent.qcloud.quic.QuicResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class QuicImpl
implements QuicNative.NetworkCallback,
Callable<QuicResponse> {
    private QuicRequest quicRequest;
    private QuicResponse quicResponse;
    private QuicException exception;
    private ConnectPool connectPool;
    private QuicNative realQuicCall;
    private boolean receivedHeader = false;
    private volatile boolean isOver = false;
    private boolean isCompleted = false;
    private boolean receivedResponse = false;
    private boolean reportException = false;
    private CallMetricsListener callMetricsListener;
    private CountDownLatch latch = new CountDownLatch(1);

    public QuicImpl(QuicRequest quicRequest, ConnectPool connectPool) {
        this.quicRequest = quicRequest;
        this.connectPool = connectPool;
        this.quicResponse = new QuicResponse();
    }

    public void setCallMetricsListener(CallMetricsListener callMetricsListener) {
        this.callMetricsListener = callMetricsListener;
    }

    public void setOutputDestination(OutputStream outputStream) {
        this.quicResponse.setOutputStream(outputStream);
    }

    public void setProgressCallback(ProgressCallback progress) {
        this.quicResponse.setProgressCallback(progress);
    }

    @Override
    public void onConnect(int handleId, int code) {
        this.onInternalConnect();
    }

    @Override
    public void onDataReceive(int handleId, byte[] data, int len) {
        this.onInternalReceiveResponse(data, len);
    }

    @Override
    public void onCompleted(int handleId, int code) {
        this.onInternalComplete(handleId, code);
    }

    @Override
    public void onClose(int handleId, int code, String desc) {
        this.onInternalClose(handleId, code, desc);
    }

    private void onInternalClientFailed(Exception clientException) {
        this.connectPool.updateQuicNativeState(this.realQuicCall, 5);
        this.reportException = true;
        this.exception = new QuicException(clientException);
        this.latch.countDown();
        this.quitSafely();
    }

    private void onInternalConnect() {
        this.connectPool.updateQuicNativeState(this.realQuicCall, 1);
        this.isOver = false;
        this.sendData();
    }

    private void onInternalReceiveResponse(byte[] data, int len) {
        if (!this.receivedHeader) {
            this.parseResponseHeader(data, len);
            this.callMetricsListener.responseHeadersEnd(null, null);
            this.receivedHeader = true;
            this.callMetricsListener.responseBodyStart(null);
        } else {
            this.parseBody(data, len);
            this.callMetricsListener.responseBodyEnd(null, -1L);
        }
        this.receivedResponse = true;
    }

    private void onInternalComplete(int handleId, int code) {
        this.isCompleted = true;
        this.connectPool.updateQuicNativeState(this.realQuicCall, 3);
        this.latch.countDown();
        this.quitSafely();
    }

    private void onInternalClose(int handleId, int code, String desc) {
        QLog.d("has been completed : %s", this.isOver);
        if (this.isOver) {
            return;
        }
        this.exception = new QuicException(String.format(Locale.ENGLISH, "Closed(%d, %s)", code, desc));
        this.connectPool.updateQuicNativeState(this.realQuicCall, 4);
        this.reportException = true;
        this.latch.countDown();
        this.quitSafely();
    }

    private void startConnect() {
        this.callMetricsListener.connectStart(null, null, null);
        this.realQuicCall.connect(this.quicRequest.host, this.quicRequest.ip, this.quicRequest.port, this.quicRequest.tcpPort);
    }

    private void sendData() {
        this.callMetricsListener.connectEnd(null, null, null, null);
        try {
            this.callMetricsListener.requestHeadersStart(null);
            for (Map.Entry<String, String> header : this.quicRequest.headers.entrySet()) {
                this.realQuicCall.addHeader(header.getKey(), header.getValue());
            }
            this.callMetricsListener.requestHeadersEnd(null, null);
            this.callMetricsListener.requestBodyStart(null);
            if (this.quicRequest.requestBody != null) {
                QuicOutputStream quicOutputStream = new QuicOutputStream(this.realQuicCall);
                BufferedSink bufferedSink = Okio.buffer((Sink)Okio.sink((OutputStream)quicOutputStream));
                this.quicRequest.requestBody.writeTo(bufferedSink);
                try {
                    bufferedSink.flush();
                    bufferedSink.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.realQuicCall.sendRequest(new byte[0], 0, true);
            } else {
                this.realQuicCall.sendRequest(new byte[0], 0, true);
            }
            this.callMetricsListener.requestBodyEnd(null, -1L);
            this.callMetricsListener.responseHeadersStart(null);
        }
        catch (IOException e) {
            this.onInternalClientFailed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponseHeader(byte[] data, int len) {
        try {
            String firtPakcet = new String(data, "ISO-8859-1");
            QLog.d("headers==>%s", firtPakcet);
        }
        catch (UnsupportedEncodingException firtPakcet) {
            // empty catch block
        }
        if (this.quicResponse != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(data, 0, len);
                bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (line.startsWith("HTTP/1.")) {
                        this.parseStateLine(line);
                    } else if (line.contains(":")) {
                        int index = line.indexOf(":");
                        String key = line.substring(0, index).trim();
                        String value = line.substring(index + 1).trim();
                        this.quicResponse.headers.put(key, value);
                        if (key.equalsIgnoreCase("content-length")) {
                            this.quicResponse.setContentLength(Long.valueOf(value));
                        } else if (key.equalsIgnoreCase("content-type")) {
                            this.quicResponse.contentType = value;
                        }
                    } else if (line.length() == 0) {
                        String bodyString = bufferedReader.readLine();
                        if (bodyString == null) break;
                        QLog.d("parseResponseHeader we reach the body data", new Object[0]);
                        byte[] bodyByte = bodyString.getBytes("ISO-8859-1");
                        this.parseBody(bodyByte, bodyByte.length);
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                this.onInternalClientFailed(e);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseStateLine(String statusLine) throws ProtocolException {
        int code;
        int codeStart;
        if (statusLine.startsWith("HTTP/1.")) {
            if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            int httpMinorVersion = statusLine.charAt(7) - 48;
            codeStart = 9;
            if (httpMinorVersion == 0) {
                QLog.d("HTTP/1.0", new Object[0]);
            } else {
                if (httpMinorVersion != 1) throw new ProtocolException("Unexpected status line: " + statusLine);
                QLog.d("HTTP/1.1", new Object[0]);
            }
        } else {
            if (!statusLine.startsWith("ICY ")) throw new ProtocolException("Unexpected status line: " + statusLine);
            QLog.d("HTTP/1.0", new Object[0]);
            codeStart = 4;
        }
        if (statusLine.length() < codeStart + 3) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        try {
            code = Integer.parseInt(statusLine.substring(codeStart, codeStart + 3));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Unexpected status line: " + statusLine);
        }
        String message = "";
        if (statusLine.length() > codeStart + 3) {
            if (statusLine.charAt(codeStart + 3) != ' ') {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            message = statusLine.substring(codeStart + 4);
        }
        this.quicResponse.code = code;
        this.quicResponse.message = message;
    }

    private void parseBody(byte[] data, int len) {
        try {
            if (this.quicResponse.code >= 200 && this.quicResponse.code < 300 && this.quicResponse.fileSink != null) {
                this.quicResponse.fileSink.write(data, 0, len);
                this.quicResponse.updateProgress(len);
            } else {
                this.quicResponse.buffer.write(data, 0, len);
                this.quicResponse.currentLength += (long)len;
            }
        }
        catch (Exception e) {
            this.onInternalClientFailed(e);
        }
    }

    private void finish() {
        try {
            if (this.quicResponse.code >= 200 && this.quicResponse.code < 300) {
                if (this.quicResponse.fileSink != null) {
                    this.quicResponse.fileSink.flush();
                    this.quicResponse.fileSink.close();
                }
            } else {
                this.quicResponse.buffer.flush();
            }
        }
        catch (Exception e) {
            this.onInternalClientFailed(e);
        }
        QLog.d("quic net info: %s", this.realQuicCall.getState());
    }

    public void cancelConnect() {
        this.realQuicCall.cancelRequest();
    }

    public void clear() {
        this.realQuicCall.clear();
    }

    @Override
    public QuicResponse call() throws QuicException {
        QLog.d("start get a connect: ", new Object[0]);
        this.realQuicCall = this.connectPool.getQuicNative(this.quicRequest.host, this.quicRequest.ip, this.quicRequest.port, this.quicRequest.tcpPort);
        this.realQuicCall.setCallback(this);
        QLog.d("handle message start call " + this.realQuicCall.toString(), new Object[0]);
        this.connectPool.dumpQuicNatives();
        if (this.realQuicCall.currentState == 1) {
            this.onInternalConnect();
        } else {
            this.startConnect();
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        QLog.d("handle message looper loop end", new Object[0]);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.quicResponse;
    }

    public QuicException getException() {
        return this.exception;
    }

    private void quitSafely() {
        QLog.d("isClose: %s; isCompleted: %s; hasReceiveResponse: %s", this.reportException, this.isCompleted, this.receivedResponse);
        if (!(this.reportException || this.isCompleted && this.receivedResponse)) {
            return;
        }
        this.isOver = true;
        if (this.isCompleted) {
            this.finish();
        }
        this.connectPool.updateQuicNativeState(this.realQuicCall, 3);
    }
}

