/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

public class RetryStrategy {
    private static final int BACKOFF_MULTIPLIER = 2;
    private static final int DEFAULT_INIT_BACKOFF = 1000;
    private static final int DEFAULT_ATTEMPTS = 3;
    private static final int DEFAULT_MAX_BACKOFF = 2000;
    private final int initBackoff;
    private final int maxBackoff;
    private final int maxAttempts;
    public static RetryStrategy DEFAULT = new RetryStrategy(1000, 2000, 3);
    public static RetryStrategy FAIL_FAST = new RetryStrategy(0, 0, 0);

    public RetryStrategy(int initBackoff, int maxBackoff, int maxAttempts) {
        this.initBackoff = initBackoff;
        this.maxBackoff = maxBackoff;
        this.maxAttempts = maxAttempts;
    }

    public int getNextDelay(int attempts) {
        return Math.min(this.maxBackoff, this.initBackoff * (int)Math.pow(2.0, attempts - 1));
    }

    public boolean shouldRetry(int attempts, long millstook) {
        return attempts < this.maxAttempts;
    }
}

