/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ResponseFileConverter;
import java.io.IOException;

public abstract class ResponseBodyConverter<T> {
    protected abstract T convert(HttpResponse<T> var1) throws QCloudClientException, QCloudServiceException;

    public static ResponseBodyConverter<Void> file(String filePath) {
        return ResponseBodyConverter.file(filePath, -1L);
    }

    public static ResponseBodyConverter<Void> file(String filePath, long offset) {
        return new ResponseFileConverter<Void>(filePath, offset);
    }

    public static ResponseBodyConverter<String> string() {
        return new StringConverter();
    }

    public static ResponseBodyConverter<byte[]> bytes() {
        return new BytesConverter();
    }

    private static final class BytesConverter
    extends ResponseBodyConverter<byte[]> {
        private BytesConverter() {
        }

        @Override
        protected byte[] convert(HttpResponse<byte[]> response) throws QCloudClientException, QCloudServiceException {
            try {
                return response.bytes();
            }
            catch (IOException e) {
                throw new QCloudClientException(e);
            }
        }
    }

    private static final class StringConverter
    extends ResponseBodyConverter<String> {
        private StringConverter() {
        }

        @Override
        protected String convert(HttpResponse<String> response) throws QCloudClientException, QCloudServiceException {
            try {
                return response.string();
            }
            catch (IOException e) {
                throw new QCloudClientException(e);
            }
        }
    }
}

